const { __ } = wp.i18n;
const { registerBlockCollection, registerBlockType, query } = wp.blocks;
const { RichText, InspectorControls, useBlockProps, InnerBlocks, BlockControls, PlainText, PanelColorSettings } = wp.blockEditor;
const { serverSideRender: ServerSideRender } = wp;
const { PanelBody, Icon, ColorPicker, GradientPicker, TextControl, SelectControl, ToggleControl } = wp.components;
const { useEffect } = wp.element;

import SimpleSliderControl from '../../admin/components/simpleSliderControl';
import initZypentoSimpleSlider from '../../general/simpleSlider';
import metadata from './block.json';


const runSimpleSliderCheck = () => {
    const maxAttempts = 50;
    let attempts = 0;
    function checkSlider() {

        const iframe = document.querySelector('iframe');
        if (iframe) {
            const iframeDocument = iframe.contentDocument || iframe.contentWindow.document;
            const sliders = iframeDocument.querySelectorAll('.zypento-blocks-simple-slider');
            if (sliders.length > 0) {
                sliders.forEach(function(slider) {
                    const loop = slider.getAttribute('data-loop') !== 'false';
                    initZypentoSimpleSlider(slider, loop);
                });
                return; // Stop checking once found
            }
        }
        attempts++;
        if (attempts < maxAttempts) {
            setTimeout(checkSlider, 200);
        }
    }
    checkSlider();
}

const Edit = ( { attributes, setAttributes, clientId } ) => {

    const { slides } = attributes;

    useEffect(() => {

        // Delay to ensure the iframe and its content are rendered
        setTimeout(() => {

            runSimpleSliderCheck();

        }, 10000); // Adjust the delay as needed
        
    }, [slides]);

    const isCategory = 'tag';

    return (

        <>
            <InspectorControls>

                <PanelBody
                    title={__('Slides', 'zypento-blocks')}
                    initialOpen={ true }
                >

                    <SimpleSliderControl
                        slides={slides}
                        onChange={(value) => {
                            setAttributes({ slides: value });
                        }}
                    />

                </PanelBody>

            </InspectorControls>
            <div { ...useBlockProps() }>
            <ServerSideRender
                        
                block="zypento-blocks/simple-slider"
                attributes={attributes}

            />
            </div>

        </>

    );
};
const save = () => { return null; };

registerBlockType( metadata.name, {
    edit: Edit,
    save: save,
} );
