const { __ } = wp.i18n;
const { registerBlockCollection, registerBlockType, query } = wp.blocks;
const { RichText, InspectorControls, useBlockProps, InnerBlocks, BlockControls, PlainText, PanelColorSettings } = wp.blockEditor;
const { serverSideRender: ServerSideRender } = wp;
const { PanelBody, Icon, ColorPicker, GradientPicker, TextControl, SelectControl, ToggleControl } = wp.components;
const { useEffect } = wp.element;

import simpleCountdown from '../../admin/components/simpleCountdown';
import ZypentoDateTimePicker from '../../admin/components/datePicker';
import metadata from './block.json';

const runSimpleCountdownCheck = () => {
    const maxAttempts = 50;
    let attempts = 0;
    function checkCountdown() {

        const iframe = document.querySelector('iframe');
        if (iframe) {
            const iframeDocument = iframe.contentDocument || iframe.contentWindow.document;
            const countdowns = iframeDocument.querySelectorAll('.zypento-blocks-simple-countdown');
            if (countdowns.length > 0) {

                countdowns.forEach(function(countdown) {
                    simpleCountdown(countdown);
                });
                return; // Stop checking once found
            }
        }
        attempts++;
        if (attempts < maxAttempts) {
            setTimeout(checkCountdown, 200);
        }
    }
    checkCountdown();
}

const defaultHtml = `<span>0<span>Days</span></span><span>0<span>Hours</span></span><span>0<span>Mins</span></span><span>0<span>Secs</span></span>`;

const Edit = ( { attributes, setAttributes } ) => {

    let { endTime } = attributes;
    let date;
    // If endTime is not set or invalid, set default to 2 days ahead
    if (!endTime || isNaN(new Date(endTime).getTime())) {
        date = new Date();
        date.setDate(date.getDate() + 2);
        endTime = date.toISOString();
        setAttributes({ endTime });
    } else {
        date = new Date(endTime);
    }
    const timestamp = date.getTime();

    useEffect(() => {

        // Delay to ensure the iframe and its content are rendered
        setTimeout(() => {

            runSimpleCountdownCheck();

        }, 2000); // Adjust the delay as needed
        
    }, [endTime]);

    return (

        <>
            <InspectorControls>

                <PanelBody
                    title={__('Zypento Simple Countdown', 'zypento-blocks')}
                    initialOpen={ false }
                >

                    <ZypentoDateTimePicker
                        value={endTime}
                        onChange={(value) => {
                            setAttributes({ endTime: value });
                        }}
                    />
                    
                </PanelBody>

            </InspectorControls>
            <div { ...useBlockProps() }>
                <div data-countdown={timestamp} class="zypento-blocks-simple-countdown" dangerouslySetInnerHTML={{ __html: defaultHtml }} />
            </div>

        </>

    );

};

const save = ({ attributes }) => {
    const { endTime } = attributes;
    const date = new Date(endTime);
    const timestamp = date.getTime();
    return (
        <div { ...useBlockProps.save() }>
            <div data-countdown={timestamp} class="zypento-blocks-simple-countdown" dangerouslySetInnerHTML={{ __html: defaultHtml }}>

            </div>
        </div>
    );
};

registerBlockType( metadata.name, {
    edit: Edit,
    save: save,
} );
