const { __ } = wp.i18n;
const { useState, useEffect } = wp.element;
const { ColorPicker, GradientPicker, TextControl, SelectControl, ToggleControl, Button } = wp.components;
const { MediaUpload } = wp.blockEditor;

const SimpleSliderControl = ( props ) => {

    const { onChange, slides } = props;

    let currentSlides = {
        '54ue2' :{
            'background' : {
                'color' : '#81b29a',
                'img' : zypentoBlocksEditorVariables['pluginUrl'] + '/assets/images/slides/03.jpg'
            },
            'padding' : {
                'container' : '',
                'content' : '12%'
            },
            'width' : {
                'content' : '1460px'
            },
            'heading' : __('End of Winter Season Sale', 'zypento-blocks'),
            'headingColor' : '#ffffff',
            'text' : __('Growing a business is about consistently delivering value, building strong relationships, and adapting quickly to changing needs and opportunities.', 'zypento-blocks'),
            'textColor' : '#ffffff',
            'button' : {
                'text' : __('Shop Now', 'zypento-blocks'),
                'link' : '#',
                'color' : {
                    'bg' : '',
                    'text' : ''
                },
                'type' : 'rounded'
            }
        },
        '54ue3' :{
            'background' : {
                'color' : '#f1ab86',
                'img' : zypentoBlocksEditorVariables['pluginUrl'] + '/assets/images/slides/04.jpg'
            },
            'padding' : {
                'container' : '',
                'content' : '12%'
            },
            'width' : {
                'content' : '1460px'
            },
            'heading' : __('Start of Summer Season Sale', 'zypento-blocks'),
            'headingColor' : '#ffffff',
            'text' : __('Growing a business is about consistently delivering value, building strong relationships, and adapting quickly to changing needs and opportunities.', 'zypento-blocks'),
            'textColor' : '#ffffff',
            'button' : {
                'text' : __('Shop Now', 'zypento-blocks'),
                'link' : '#',
                'color' : {
                    'bg' : '',
                    'text' : ''
                },
                'type' : 'rounded'
            }
        }
    };

    if (
        null !== slides &&
        'object' === typeof slides &&
        Object === slides.constructor &&
        0 !== Object.keys(slides).length
    ) {
        currentSlides = slides;
    }

    let newSlideData = {
        'background' : {
            'color' : '',
            'img' : ''
        },
        'padding' : {
            'container' : '',
            'content' : ''
        },
        'width' : {
            'content' : ''
        },
        'heading' : __('Slide Heading', 'zypento-blocks'),
        'headingColor' : '',
        'text' : __('Some super awesome text comes here', 'zypento-blocks'),
        'textColor' : '',
        'button' : {
            'text' : __('Click Here', 'zypento-blocks'),
            'link' : '',
            'color' : {
                'bg' : '',
                'text' : ''
            },
            'type' : ''
        }
    }

    const handleAddSlide = () => {
        // Generate a random string key
        let key = Math.random().toString(36).slice(2, 7);
        const newSlides = { ...currentSlides };
        newSlides[key] = structuredClone( newSlideData );
        onChange(newSlides);
    }

    const handleDeleteSlide = async (key) => {

        const newSlides = { ...currentSlides };
        delete newSlides[key];
        onChange(newSlides);

    };

    const [openHeadingKey, setOpenHeadingKey] = useState(null);

    return(
        <>
            <div className="zypento-blocks-simple-slider-container">
                <div className="zypento-blocks-simple-slider-slides">
                    {'object' === typeof currentSlides && Object.entries(currentSlides).map(([key, value]) => (
                        <div data-id={key} className="zypento-blocks-simple-slider-slide" key={key}>
                            <h4 className="zypento-heading">{__('Slide', 'zypento-blocks')}</h4>
                            <span
                                className="zypento-menu"
                                onClick={() => setOpenHeadingKey(openHeadingKey === key ? null : key)}
                            ></span>
                            <span onClick={() => handleDeleteSlide(key)} className="zypento-delete"></span>
                            <div
                                style={{ display: openHeadingKey === key ? 'block' : 'none' }}
                                className="zypento-blocks-simple-slider-slide-content"
                            >
                                <div className="zypento-item">
                                    <TextControl
                                        label={__('Heading', 'zypento-blocks')}
                                        value={value.heading}
                                        onChange={(newHeading) => {
                                            const newSlides = { ...currentSlides };
                                            newSlides[key] = { ...newSlides[key], heading: newHeading };
                                            onChange(newSlides);
                                        }}
                                    />
                                    <div className="zypento-colorpicker-wrap">
                                    <ColorPicker
                                        color={value.headingColor || '#000000'}
                                        onChangeComplete={(color) => {
                                            const newSlides = { ...currentSlides };
                                            newSlides[key] = {
                                                ...newSlides[key],
                                                headingColor: typeof color === 'string' ? color : color.hex
                                            };
                                            onChange(newSlides);
                                        }}
                                        disableAlpha
                                    />
                                    </div>
                                </div>
                                <div className="zypento-item">
                                    <TextControl
                                        label={__('Text', 'zypento-blocks')}
                                        value={value.text}
                                        onChange={(newHeading) => {
                                            const newSlides = { ...currentSlides };
                                            newSlides[key] = { ...newSlides[key], text: newHeading };
                                            onChange(newSlides);
                                        }}
                                    />
                                    <div className="zypento-colorpicker-wrap">
                                    <ColorPicker
                                        color={value.textColor || '#000000'}
                                        onChangeComplete={(color) => {
                                            const newSlides = { ...currentSlides };
                                            newSlides[key] = {
                                                ...newSlides[key],
                                                textColor: typeof color === 'string' ? color : color.hex
                                            };
                                            onChange(newSlides);
                                        }}
                                        disableAlpha
                                    />
                                    </div>
                                </div>
                                <div className="zypento-item">
                                    <TextControl
                                        label={__('Button text', 'zypento-blocks')}
                                        value={value.button?.text || ''}
                                        onChange={(newText) => {
                                            const newSlides = { ...currentSlides };
                                            newSlides[key] = {
                                                ...newSlides[key],
                                                button: {
                                                    ...((newSlides[key] && newSlides[key].button) || {}),
                                                    text: newText
                                                }
                                            };
                                            onChange(newSlides);
                                        }}
                                    />
                                    <TextControl
                                        label={__('Button link', 'zypento-blocks')}
                                        value={value.button?.link || ''}
                                        onChange={(newLink) => {
                                            const newSlides = { ...currentSlides };
                                            newSlides[key] = {
                                                ...newSlides[key],
                                                button: {
                                                    ...((newSlides[key] && newSlides[key].button) || {}),
                                                    link: newLink
                                                }
                                            };
                                            onChange(newSlides);
                                        }}
                                    />
                                    <ToggleControl
                                        label={__('Rounded Button', 'zypento-blocks')}
                                        checked={value.button?.type === 'rounded'}
                                        onChange={(isRounded) => {
                                            const newSlides = { ...currentSlides };
                                            newSlides[key] = {
                                                ...newSlides[key],
                                                button: {
                                                    ...((newSlides[key] && newSlides[key].button) || {}),
                                                    type: isRounded ? 'rounded' : 'normal'
                                                }
                                            };
                                            onChange(newSlides);
                                        }}
                                    />
                                    <div className="zypento-colorpicker-wrap">
                                        <label>{__('Button BG', 'zypento-blocks')}</label>
                                        <ColorPicker
                                            color={value.button?.color?.bg || '#ffffff'}
                                            onChangeComplete={(color) => {
                                                const newSlides = { ...currentSlides };
                                                newSlides[key] = {
                                                    ...newSlides[key],
                                                    button: {
                                                        ...((newSlides[key] && newSlides[key].button) || {}),
                                                        color: {
                                                            ...((newSlides[key] && newSlides[key].button && newSlides[key].button.color) || {}),
                                                            bg: typeof color === 'string' ? color : color.hex
                                                        }
                                                    }
                                                };
                                                onChange(newSlides);
                                            }}
                                            disableAlpha
                                        />
                                    </div>
                                    <div className="zypento-colorpicker-wrap">
                                        <label>{__('Button Text', 'zypento-blocks')}</label>
                                        <ColorPicker
                                            color={value.button?.color?.text || '#ffffff'}
                                            onChangeComplete={(color) => {
                                                const newSlides = { ...currentSlides };
                                                newSlides[key] = {
                                                    ...newSlides[key],
                                                    button: {
                                                        ...((newSlides[key] && newSlides[key].button) || {}),
                                                        color: {
                                                            ...((newSlides[key] && newSlides[key].button && newSlides[key].button.color) || {}),
                                                            text: typeof color === 'string' ? color : color.hex
                                                        }
                                                    }
                                                };
                                                onChange(newSlides);
                                            }}
                                            disableAlpha
                                        />
                                    </div>
                                </div>
                                <div className="zypento-item">
                                    <TextControl
                                        label={__('Slide Vertical Padding', 'zypento-blocks')}
                                        value={value.padding?.container || ''}
                                        onChange={(newPadding) => {
                                            const newSlides = { ...currentSlides };
                                            newSlides[key] = {
                                                ...newSlides[key],
                                                padding: {
                                                    ...((newSlides[key] && newSlides[key].padding) || {}),
                                                    container: newPadding
                                                }
                                            };
                                            onChange(newSlides);
                                        }}
                                    />
                                    <label>{__('Background Color', 'zypento-blocks')}</label>
                                    <div className="zypento-colorpicker-wrap">
                                    <ColorPicker
                                        color={value.background?.color || '#ffffff'}
                                        onChangeComplete={(color) => {
                                            const newSlides = { ...currentSlides };
                                            newSlides[key] = {
                                                ...newSlides[key],
                                                background: {
                                                    ...((newSlides[key] && newSlides[key].background) || {}),
                                                    color: typeof color === 'string' ? color : color.hex
                                                }
                                            };
                                            onChange(newSlides);
                                        }}
                                        disableAlpha
                                    />
                                    </div>
                                </div>
                                <div className="zypento-item">
                                    <TextControl
                                        label={__('Slide Content Vertical Padding', 'zypento-blocks')}
                                        value={value.padding?.content || ''}
                                        onChange={(newPadding) => {
                                            const newSlides = { ...currentSlides };
                                            newSlides[key] = {
                                                ...newSlides[key],
                                                padding: {
                                                    ...((newSlides[key] && newSlides[key].padding) || {}),
                                                    content: newPadding
                                                }
                                            };
                                            onChange(newSlides);
                                        }}
                                    />
                                    <TextControl
                                        label={__('Slide Content Width', 'zypento-blocks')}
                                        value={value.width?.content || ''}
                                        onChange={(newWidth) => {
                                            const newSlides = { ...currentSlides };
                                            newSlides[key] = {
                                                ...newSlides[key],
                                                width: {
                                                    ...((newSlides[key] && newSlides[key].width) || {}),
                                                    content: newWidth
                                                }
                                            };
                                            onChange(newSlides);
                                        }}
                                    />
                                        <label>{__('Background Image', 'zypento-blocks')}</label>
                                        <MediaUpload
                                            onSelect={(media) => {
                                                const newSlides = { ...currentSlides };
                                                newSlides[key] = {
                                                    ...newSlides[key],
                                                    background: {
                                                        ...((newSlides[key] && newSlides[key].background) || {}),
                                                        img: media.url || ''
                                                    }
                                                };
                                                onChange(newSlides);
                                            }}
                                            allowedTypes={['image']}
                                            value={value.background?.img || ''}
                                            render={({ open }) => (
                                                <Button onClick={open} isSecondary>
                                                    {value.background?.img ? __('Change Image', 'zypento-blocks') : __('Select Image', 'zypento-blocks')}
                                                </Button>
                                            )}
                                        />
                                        {value.background?.img && (
                                            <img src={value.background.img} alt={__('Slide Image', 'zypento-blocks')} style={{ maxWidth: '100%', marginTop: '8px' }} />
                                        )}
                                </div>
                            </div>
                        </div>
                    ))}
                </div>
                <div className="">

                </div>
                <p className="zypento-blocks-simple-slider-add-slide">
                    <span onClick={() => handleAddSlide()}>{__('Add Slide', 'zypento-blocks')}</span>
                </p>
            </div>
        </>
    )
}
  
export default SimpleSliderControl;
