<?php
/**
 * The plugin bootstrap file
 *
 * @link              zypento.com
 * @since             1.0.0
 * @package           zypento
 *
 * @wordpress-plugin
 * Plugin Name:       Zypento AgileCRM Integration for Contact Form 7 and Ninja Forms
 * Plugin URI:        http://zypento.com
 * Description:       Integration for Agilecrm and Contact Form 7, Ninja Forms.
 * Version:           1.0.0
 * Requires at least: 6.0
 * Requires PHP:      7.4
 * Author:            Zypento
 * Author URI:        https://zypento.com
 * License:           GPL v2 or later
 * License URI:       https://www.gnu.org/licenses/gpl-2.0.html
 * Text Domain:       zypento-agilecrm
 * Domain Path:       /languages
 */

// If this file is called directly, abort.
if ( ! defined( 'WPINC' ) ) {
	die;
}

/**
 * Autoloader
 */
require_once 'vendor/autoload.php';

/**
 * Currently plugin version.
 * Start at version 1.0.0 and use SemVer - https://semver.org
 * Rename this for your plugin and update it as you release new versions.
 */
define( 'ZYPENTO_AGILECRM_NAME', 'zypento-agilecrm' );
define( 'ZYPENTO_AGILECRM_VERSION', '1.0.0' );
define( 'ZYPENTO_AGILECRM_NAMESPACE', 'zypento-agilecrm/v1' );
define( 'ZYPENTO_AGILECRM_PLUGIN_PATH', plugin_dir_path( __FILE__ ) );
define( 'ZYPENTO_AGILECRM_PLUGIN_URL', plugins_url( '', __FILE__ ) );

$zypento_agilecrm_objects = array();

register_activation_hook(
	__FILE__,
	function() {
		\Zypento_Agilecrm\Plugin::activate();
	}
);
register_deactivation_hook(
	__FILE__,
	function() {
		\Zypento_Agilecrm\Plugin::deactivate();
	}
);

/**
 * Begins execution of the plugin.
 */
new \Zypento_Agilecrm\Plugin();

