<?php
/**
 * The file that displays admin page.
 *
 * @link       http://zypento.com
 * @since      1.0.0
 *
 * @package    zypento-agilecrm
 * @subpackage zypento-agilecrm/includes
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}
?>

<div class="zypento-agilecrm-settings">

	<div class="zypento-agilecrm-settings-heading">
		<h3><?php esc_html_e( 'Zypento Agile CRM Integration', 'zypento-agilecrm' ); ?></h3>
	</div>

	<h4 class="zypento-agilecrm-settings-sub-heading"><?php esc_html_e( 'Ninja Forms', 'zypento-agilecrm' ); ?></h4>

	<div class="zypento-agilecrm-settings-content">

		<?php if ( ! function_exists( 'Ninja_Forms' ) ) : ?>
		<p class="zypento-agilecrm-settings-content-error">
			<?php esc_html_e( 'Please install and activate Ninja Forms', 'zypento-agilecrm' ); ?>
		</p>
		<?php endif; ?>

		<?php foreach ( $forms as $form ) : ?>

			<div data-type="ninja" data-id="<?php echo esc_attr( $form->get_id() ); ?>" class="zypento-agilecrm-field-map">

				<h3 class="zypento-agilecrm-field-map-heading"><?php echo esc_html( $form->get_setting( 'title' ) ); ?></h3>
				<?php $this->display_crm_fields( $form->get_id() ); ?>

			</div>


		<?php endforeach; ?>

	</div>

</div>

