<?php
/**
 * The file that displays admin page.
 *
 * @link       http://zypento.com
 * @since      1.0.0
 *
 * @package    zypento-agilecrm
 * @subpackage zypento-agilecrm/includes
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}
?>

<div class="zypento-agilecrm-settings">

	<div class="zypento-agilecrm-settings-heading">
		<h3><?php esc_html_e( 'Zypento Agile CRM Integration', 'zypento-agilecrm' ); ?></h3>
	</div>

	<h4 class="zypento-agilecrm-settings-sub-heading"><?php esc_html_e( 'Contact Form 7', 'zypento-agilecrm' ); ?></h4>

	<div class="zypento-agilecrm-settings-content">

		<?php if ( ! function_exists( 'wpcf7_add_shortcode' ) ) : ?>
		<p class="zypento-agilecrm-settings-content-error">
			<?php esc_html_e( 'Please install and activate CF7', 'zypento-agilecrm' ); ?>
		</p>
		<?php endif; ?>

		<?php foreach ( $forms as $form ) : ?>

			<div data-type="cf7" data-id="<?php echo esc_attr( $form ); ?>" class="zypento-agilecrm-field-map">

				<h3 class="zypento-agilecrm-field-map-heading"><?php echo esc_html( get_the_title( $form ) ); ?></h3>
				<?php $this->display_crm_fields( $form ); ?>

			</div>

		<?php endforeach; ?>

	</div>

</div>

