(function( $ ) {
	'use strict';

	$(function () {

        var cf7Proceed = true;

        const zypentoAgileAddCustomField = ( options ) => {

            options = JSON.parse( options );

            let selectHtml = '';

            $.each(options, function(key, value){

                selectHtml += `<option value="${key}">${key}</option>`;

            });

            let content = `
            <div data-type="custom" class="zypento-agilecrm-field-map-item">

                <p class="zypento-agilecrm-field-map-item-message">
                    ${zypentoAgileAdminVariables.labels.settings.custom}
                    <span class="zypento-agilecrm-field-map-item-delete"></span>
                </p>
                <div class="zypento-agilecrm-field-map-item-content">
                    <div>
                        <p><input type="text" value="" /></p>
                    </div>

                    <div>
                        <select>
                        ${selectHtml}
                        </select>
                    </div>
                </div>

            </div>
            `;

            return content;

        };

        const zypentoResetCf7 = (el, type, message) => {
            if ( 'error' === type ) {
                el.find('.zypento-agilecrm-field-map-message').text(message).attr('data-type', 'error');
                el.find('.zypento-agilecrm-field-map-actions>span').attr('data-process', '');
            }
            if ( '' === type ) {
                el.find('.zypento-agilecrm-field-map-actions>span').attr('data-process', '');
                el.find('.zypento-agilecrm-field-map-message').text(message);
            }
            cf7Proceed = true;
        }

        const zypentoResetCf7Message = (el) => {
            el.find('.zypento-agilecrm-field-map-message').text('').attr('data-type', '').css({'display':'none'});
        }

        $('.zypento-agilecrm-submit>span').on('click', function(){

            var settings = {};
            var proceed = true;

            $('.zypento-agilecrm-message').text('').attr({'data-type':''}).removeAttr('style');

            $(this).closest('.zypento-agilecrm-settings-content').find('.zypento-agilecrm-option').each(function(){

                var el = $(this);
                var key = el.find('input').attr('name');
                var type = el.find('input').attr('type');
                var value = '';

                if ( 'text' === type || 'password' === type ) {
                    value = el.find('input').val();
                }

                if ( 'checkbox' === type ) {
                    value = el.find('input[type="checkbox"]:checked').map(function() {
                        return $(this).val();
                    }).get();
                }

                if ( 0 === value.length ) {
                    proceed = false;
                    el.find('.message').text(zypentoAgileAdminVariables.labels.settings.errors[key]['error']).attr({'data-type':'error'});
                }

                if ( 0 !== value.length ) {
                    el.find('.message').text('').attr({'data-type':''});
                    settings[key] = value;
                }

            });

            if ( ! proceed ) {
                $('.zypento-agilecrm-message').text(zypentoAgileAdminVariables.labels.settings.all).attr({'data-type':''}).css({'display':'block'});
            }

            if ( proceed ) {

                $('.zypento-agilecrm-message').text(zypentoAgileAdminVariables.labels.settings.wait).attr({'data-type':''}).css({'display':'block'});

                var sendData = {};
                sendData['nonce'] = zypentoAgileAdminVariables.nonce;
                sendData['value'] = JSON.stringify( settings );

                jQuery.ajax({

                    type: 'POST',
                    url: zypentoAgileAdminVariables.api.admin.settings,
                    data: sendData,
                    beforeSend: function (xhr) {
                        xhr.setRequestHeader('X-WP-Nonce', zypentoAgileAdminVariables.wpRestNonce);
                    },
                    timeout: 10000,
                    success: function(jsonData) {

                        if( 
                            Object.prototype.hasOwnProperty.call(jsonData, "result") &&
                            jsonData.result
                        ){

                            $('.zypento-agilecrm-message').text(zypentoAgileAdminVariables.labels.settings.success).attr({'data-type':''}).css({'display':'block'});

                        }

                        if( 
                            Object.prototype.hasOwnProperty.call(jsonData, "result") &&
                            ! jsonData.result &&
                            Object.prototype.hasOwnProperty.call(jsonData, "data") &&
                            Object.prototype.hasOwnProperty.call(jsonData.data, "reason") &&
                            'object' === typeof jsonData.data.reason
                        ){

                            $.each(jsonData.data.reason, function(key, value){

                                $('.zypento-agilecrm-option[data-type="' + key + '"]').find('.message').text(value).attr({'data-type':'error'});

                            });

                        }

                        if( 
                            Object.prototype.hasOwnProperty.call(jsonData, "result") &&
                            ! jsonData.result &&
                            Object.prototype.hasOwnProperty.call(jsonData, "data") &&
                            Object.prototype.hasOwnProperty.call(jsonData.data, "reason") &&
                            'object' !== typeof jsonData.data.reason
                        ){

                            $('.zypento-agilecrm-message').text(jsonData.data.reason).attr({'data-type':'error'}).css({'display':'block'});

                        }
            
                    },
                    error: function(xhr, status, error) {
            
                        $('.zypento-agilecrm-message').text(zypentoAgileAdminVariables.labels.settings.error).attr({'data-type':'error'}).css({'display':'block'});
            
                    },
            
                });

            }

        });

        $('.zypento-agilecrm-field-map-heading').on('click', function(){
            $(this).siblings('.zypento-agilecrm-field-map-items').slideToggle();
        });

        $('.zypento-agilecrm-field-map-actions>span').on('click', function(){
            let el = $(this).closest('.zypento-agilecrm-field-map');
            let type = $(this).attr('data-type');
            let form = $(this).closest('.zypento-agilecrm-field-map');
            let formId = form.attr('data-id');
            let formItems = form.find('.zypento-agilecrm-field-map-items');
            let targetType = el.attr('data-type');

            if ( 'add' === type ) {

                if ( ! cf7Proceed ) {
                    return;
                }

                zypentoResetCf7Message( el );
                let container = formItems.find('.zypento-agilecrm-field-map-custom-items');
                let options = container.attr('data-crm');
                let field = zypentoAgileAddCustomField( options );
                container.append( field );
            }
            if ( 'submit' === type ) {
                if ( ! cf7Proceed ) {
                    return;
                }
                cf7Proceed = false;
                $('.zypento-agilecrm-field-map-actions>span').attr('data-process', 'disabled');
                $('.zypento-agilecrm-field-map-message').text(zypentoAgileAdminVariables.labels.settings.wait).attr('data-type', '').css({'display':'block'});
                let crmFields = {
                    'system' : {},
                    'custom' : {},
                    'id' : formId,
                };
                let pattern = /^[-_ a-zA-Z0-9]+$/
                formItems.find('.zypento-agilecrm-field-map-system-items').find('.zypento-agilecrm-field-map-item').each(function(){
                    let crmKey = $(this).attr('data-key');
                    let cf7Field = $(this).find('select').val();
                    if ( '' !== crmKey && '' !== cf7Field && 'select' !== cf7Field ) {
                        crmFields['system'][ crmKey ] = cf7Field;
                    }
                });
                formItems.find('.zypento-agilecrm-field-map-custom-items').find('.zypento-agilecrm-field-map-item').each(function(){
                    let crmKey = $(this).find('input[type="text"]').val();
                    let cf7Field = $(this).find('select').val();
                    if ( '' !== crmKey && pattern.test(crmKey) && '' !== cf7Field && 'select' !== cf7Field ) {
                        crmFields['custom'][ crmKey ] = cf7Field;
                    }
                });

                var sendData = {};
                sendData['nonce'] = zypentoAgileAdminVariables.nonce;
                sendData['value'] = JSON.stringify( crmFields );

                let targetUrl = zypentoAgileAdminVariables.api.admin.cf7;
                if ( 'ninja' === targetType ) {
                    targetUrl = zypentoAgileAdminVariables.api.admin.ninja;
                }


                jQuery.ajax({

                    type: 'POST',
                    url: targetUrl,
                    data: sendData,
                    beforeSend: function (xhr) {
                        xhr.setRequestHeader('X-WP-Nonce', zypentoAgileAdminVariables.wpRestNonce);
                    },
                    timeout: 10000,
                    success: function(jsonData) {

                        if( 
                            Object.prototype.hasOwnProperty.call(jsonData, "result") &&
                            jsonData.result
                        ){
                            zypentoResetCf7(el,'', zypentoAgileAdminVariables.labels.settings.success);
                        } else {
                            zypentoResetCf7(el,'error', zypentoAgileAdminVariables.labels.settings.error);
                        }
                    },
                    error: function(xhr, status, error) {
            
                        zypentoResetCf7(el,'error', zypentoAgileAdminVariables.labels.settings.error);
            
                    },
            
                });

            }
        });

        $('.zypento-agilecrm-field-map-custom-items').on('click', '.zypento-agilecrm-field-map-item-delete', function(){
            let el = $(this).closest('.zypento-agilecrm-field-map-items');
            zypentoResetCf7Message(el);
            $(this).closest('.zypento-agilecrm-field-map-item').remove();
        });
        
	});

})( jQuery );
