<?php
/**
 * The file that displays admin page.
 *
 * @link       http://zypento.com
 * @since      1.0.0
 *
 * @package    zypento-agilecrm
 * @subpackage zypento-agilecrm/includes
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}
?>

<div class="zypento-agilecrm-settings">

	<div class="zypento-agilecrm-settings-heading">
		<h3><?php esc_html_e( 'Zypento Agile CRM Integration', 'zypento-agilecrm' ); ?></h3>
	</div>

	<h4 class="zypento-agilecrm-settings-sub-heading"><?php esc_html_e( 'API Settings', 'zypento-agilecrm' ); ?></h4>

	<div class="zypento-agilecrm-settings-content">

		<?php foreach ( $zypento_agilecrm_settings as $key => $value ) : ?>

			<?php
				$input_type = 'text';
			if ( 'api' === $key ) {
				$input_type = 'password';
			}
			?>

			<div data-type="<?php echo esc_attr( $key ); ?>" class="zypento-agilecrm-option">
				<h3><?php echo esc_html( $value['label'] ); ?></h3>
				<p><input name="<?php echo esc_attr( $key ); ?>" type="<?php echo esc_attr( $input_type ); ?>" value="<?php echo esc_attr( $zypento_agilecrm_settings_values[ $key ] ); ?>" /></p>
				<p class="message"><?php echo esc_html( $value['message'] ); ?></p>
			</div>

		<?php endforeach; ?>

		<p class="zypento-agilecrm-message"></p>

		<p class="zypento-agilecrm-submit">
		<span><?php esc_html_e( 'Save', 'zypento-agilecrm' ); ?></span>
		</p>

	</div>

</div>

