<?php
/**
 * The file that defines the core plugin class
 *
 * @link       http://zypento.com
 * @since      1.0.0
 *
 * @package    zypento-agilecrm
 * @subpackage zypento-agilecrm/includes
 */

namespace Zypento_Agilecrm;

/**
 * The core plugin class.
 *
 * @since      1.0.0
 * @package    zypento-agilecrm
 * @subpackage zypento-agilecrm/includes
 * @author     Zypento <dev@zypento.com>
 */
class Plugin {

	/**
	 * Define the core functionality of the plugin.
	 *
	 * @since    1.0.0
	 */
	public function __construct() {

		$this->loader();

	}

	/**
	 * Perform actions on activation.
	 *
	 * @since    1.0.0
	 */
	public static function activate() {

		if ( version_compare( PHP_VERSION, '8.1', '<' ) ) {
			die( esc_html__( 'This plugin requires PHP version 8.1 or greater.  Sorry about that.', 'zypento-agilecrm' ) );
		}

	}

	/**
	 * Perform actions on deactivation.
	 *
	 * @since    1.0.0
	 */
	public static function deactivate() {

	}

	/**
	 * Load all the features.
	 *
	 * @since    1.0.0
	 */
	public static function loader() {

		global $zypento_agilecrm_objects;

		$dir = ZYPENTO_AGILECRM_PLUGIN_PATH . 'includes';

		$iterator = new \RecursiveIteratorIterator( new \RecursiveDirectoryIterator( $dir ) );

		foreach ( $iterator as $file ) {

			if ( $file->isFile() && $file->getPath() !== $dir ) {

				$filename       = pathinfo( $file->getFilename(), PATHINFO_FILENAME );
				$class_name     = str_replace( 'class-', '', $filename );
				$class_name     = str_replace( '-', ' ', $class_name );
				$class_name_key = $class_name;
				$class_name     = ucwords( $class_name );
				$class_name     = str_replace( ' ', '_', $class_name );

				$class_name_key = str_replace( ' ', '_', $class_name_key );

				$namespace = str_replace( $dir . '/', '', $file->getPath() );
				$namespace = str_replace( '/', ' ', $namespace );
				$namespace = ucwords( $namespace );
				$namespace = str_replace( ' ', '\\', $namespace );
				$namespace = $namespace . '\\';

				$class_name = 'Zypento_Agilecrm\\' . $namespace . $class_name;

				if ( class_exists( $class_name ) ) {

					$zypento_agilecrm_objects[ $class_name_key ] = new $class_name();
				}
			}
		}

	}


}
