<?php
/**
 * Plugin Name: Z UpTime – Uptime Monitoring Node
 * Description: Lightweight WordPress uptime monitoring node that reports heartbeat and health to a Central dashboard. Alerts are handled by Central.
 * Version: 1.4.50
 * Author: Zubbin
 * Text Domain: zubbin-uptime-node
 * Domain Path: /languages
 * Author URI: https://zubbin.com/
 * License: GPLv2 or later
 * License URI: https://www.gnu.org/licenses/gpl-2.0.html
 */
if (!defined('ABSPATH')) exit;

define('ZUBBIN_UN_VERSION', '1.4.48');

// Default Central URL for client installs (override in wp-config.php if needed)
// define('ZUBBIN_UN_DEFAULT_CENTRAL_URL', 'https://your-central.example');
if (!defined('ZUBBIN_UN_DEFAULT_CENTRAL_URL')) {
  define('ZUBBIN_UN_DEFAULT_CENTRAL_URL', 'https://zubbin.com');
}
define('ZUBBIN_UN_DIR', plugin_dir_path(__FILE__));
define('ZUBBIN_UN_URL', plugin_dir_url(__FILE__));

require_once ZUBBIN_UN_DIR.'includes/brand.php';
require_once ZUBBIN_UN_DIR.'includes/settings.php';
require_once ZUBBIN_UN_DIR.'includes/logger.php';
require_once ZUBBIN_UN_DIR.'includes/client.php';
require_once ZUBBIN_UN_DIR.'includes/monitor.php';
require_once ZUBBIN_UN_DIR.'includes/health.php';
require_once ZUBBIN_UN_DIR.'includes/cron.php';
require_once ZUBBIN_UN_DIR.'includes/onboard.php';
require_once ZUBBIN_UN_DIR.'includes/admin.php';

// Register admin-post handlers at top-level to avoid any load-order issues
add_action('admin_post_zubbin_un_save_settings', ['ZUBBIN_UN_Admin','save_settings']);
add_action('admin_post_zubbin_un_bootstrap', ['ZUBBIN_UN_Admin','bootstrap']);
add_action('admin_post_zubbin_un_auto_register', ['ZUBBIN_UN_Admin','auto_register']);
add_action('admin_post_zubbin_un_force_sync', ['ZUBBIN_UN_Admin','force_sync']);;
add_action('admin_post_zubbin_un_test_auth', ['ZUBBIN_UN_Admin','test_auth']);
add_action('admin_post_zubbin_un_clear_logs', ['ZUBBIN_UN_Admin','clear_logs']);

register_activation_hook(__FILE__, ['ZUBBIN_UN_Onboard','activate']);
register_deactivation_hook(__FILE__, ['ZUBBIN_UN_Cron','deactivate']);

add_action('plugins_loaded', function(){
  ZUBBIN_UN_Health::init();
  ZUBBIN_UN_Cron::init();

  // Always register admin-post handlers (admin-post.php requests)
  if (class_exists('ZUBBIN_UN_Admin') && method_exists('ZUBBIN_UN_Admin', 'register_post_handlers')) {
    ZUBBIN_UN_Admin::register_post_handlers();
  }

  // Only load UI in wp-admin screens
  if (is_admin()) {
    ZUBBIN_UN_Admin::init();
  }
});
