<?php
if ( ! defined( 'WP_UNINSTALL_PLUGIN' ) ) {
  exit;
}

/**
 * Uninstall cleanup.
 *
 * Wrapped in a prefixed function to avoid leaking global-scope variables.
 */
function zubbin_un_uninstall_cleanup() {
  delete_option( 'zubbin_un_settings' );

  global $wpdb;
  $zubbin_un_db_prefix = isset( $wpdb->prefix ) ? (string) $wpdb->prefix : 'wp_';
  $zubbin_un_db_prefix = preg_replace( '/[^A-Za-z0-9_]/', '', $zubbin_un_db_prefix );
  $zubbin_un_table     = $zubbin_un_db_prefix . 'zubbin_un_node_logs';

  // phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching, WordPress.DB.PreparedSQL.InterpolatedNotPrepared, WordPress.DB.DirectDatabaseQuery.SchemaChange, PluginCheck.Security.DirectDB.UnescapedDBParameter
  $wpdb->query( "DROP TABLE IF EXISTS {$zubbin_un_table}" );
}

zubbin_un_uninstall_cleanup();
