<?php
if (!defined('ABSPATH')) exit;

class ZUBBIN_UN_Monitor {

  static function check($s) {
    $url = !empty($s['check_url']) ? $s['check_url'] : home_url('/');
    $url = esc_url_raw($url);

    $t0 = microtime(true);
    $res = wp_remote_get($url, [
      'timeout' => max(3, (int)$s['check_timeout']),
      'redirection' => 2,
      'headers' => ['User-Agent' => 'WebSentinelNode/'.ZUBBIN_UN_VERSION],
    ]);
    $ms = (int)round((microtime(true) - $t0) * 1000);

    if (is_wp_error($res)) {
      return ['status'=>'down','http'=>0,'ms'=>$ms,'msg'=>$res->get_error_message()];
    }

    $http = (int)wp_remote_retrieve_response_code($res);
    if ($http >= 200 && $http < 400) {
      return ['status'=>'up','http'=>$http,'ms'=>$ms,'msg'=>'ok'];
    }
    return ['status'=>'down','http'=>$http,'ms'=>$ms,'msg'=>'http_'.$http];
  }
}
