<?php
if ( ! defined( 'ABSPATH' ) ) exit;

/**
 * Get a bundled brand asset URL.
 *
 * @param string $file Filename inside assets/brand/
 * @return string
 */
function zubbin_un_brand_asset_url( $file ) {
    $file = ltrim( (string) $file, '/' );

    // Allow override via constant (future-proofing, optional).
    if ( defined( 'ZUBBIN_UN_BRAND_URL' ) && ZUBBIN_UN_BRAND_URL ) {
        return trailingslashit( ZUBBIN_UN_BRAND_URL ) . $file;
    }

    return trailingslashit( ZUBBIN_UN_URL ) . 'assets/brand/' . $file;
}
