<?php
/**
 * Plugin Name:      ZooMeet
 * Description:      Zoom Integration for WordPress.
 * Version:          1.2.1
 * Author:           Sovlix
 * Author URI:       https://sovlix.com/
 * License:          GPL-2.0+
 * License URI:      http://www.gnu.org/licenses/gpl-2.0.txt
 * Text Domain:      zoomeet
 * Requires at least: 5.0
 * Tested up to:     6.8
 *
 * @package ZMEET
 */

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

require_once __DIR__ . '/vendor/autoload.php';

if ( ! function_exists( 'zoo_fs' ) ) {
	// Create a helper function for easy SDK access.
	function zoo_fs() {
		global $zoo_fs;

		if ( ! isset( $zoo_fs ) ) {
			// Activate multisite network integration.
			if ( ! defined( 'WP_FS__PRODUCT_19621_MULTISITE' ) ) {
				define( 'WP_FS__PRODUCT_19621_MULTISITE', true );
			}

			require_once __DIR__ . '/vendor/freemius/wordpress-sdk/start.php';

			add_filter( 'fs_playground_anonymous_mode_zoomeet', '__return_false' );

			// Include Freemius SDK.
			$zoo_fs = fs_dynamic_init(
				array(
					'id'                  => '19621',
					'slug'                => 'zoomeet',
					'premium_slug'        => 'zoomeet-pro',
					'type'                => 'plugin',
					'public_key'          => 'pk_a82bf01d10ba1b94ea96a40151826',
					'is_premium'          => false,
					// If your plugin is a serviceware, set this option to false.
					'has_premium_version' => true,
					'has_addons'          => false,
					'has_paid_plans'      => true,
					'parallel_activation' => array(
						'enabled'                  => true,
						'premium_version_basename' => 'zoomeet-pro/zoomeet-pro.php',
					),
					'menu'                => array(
						'slug'       => 'zmeet',
						'first-path' => 'admin.php?page=zmeet-settings',
						'support'    => false,
						'network'    => true,
					),
					'is_live'             => true,
				),
			);
		}

		return $zoo_fs;
	}

	// Init Freemius.
	zoo_fs();
	// Signal that SDK was initiated.
	do_action( 'zoo_fs_loaded' );
}



if ( ! defined( 'ZMEET_VERSION' ) ) {
	define( 'ZMEET_VERSION', '1.2.1' );
	define( 'ZMEET_FILE', __FILE__ );
	define( 'ZMEET_PATH', dirname( ZMEET_FILE ) );
	define( 'ZMEET_INCLUDES', ZMEET_PATH . '/includes' );
	define( 'ZMEET_FRONTEND', ZMEET_PATH . '/includes/Frontend' );
	define( 'ZMEET_TEMPLATES', ZMEET_PATH . '/templates' );
	define( 'ZMEET_URL', plugin_dir_url( ZMEET_FILE ) );
	define( 'ZMEET_ASSETS_PATH', ZMEET_URL . 'assets' );
	define( 'ZMEET_CSS_DIR', ZMEET_URL . 'assets/css/' );
	define( 'ZMEET_BUILD_CSS_DIR', ZMEET_URL . 'assets/dist/' );
	define( 'ZMEET_JS_DIR', ZMEET_URL . 'assets/dist/' );

	// Load plugin base file.
	include_once ZMEET_INCLUDES . '/zmeet-plugin.php';
}
