<?php
/**
 * Notice Template - Premium Banner Design
 *
 * @package PromoSDK
 */

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Notice template variables.
 *
 * @var array  $promo_data Promotional data.
 * @var string $countdown_end_time Countdown end time in ISO 8601 format.
 */

// Handle both nested and flat data structures.
$notice_data = isset( $promo_data['notice'] ) ? $promo_data['notice'] : $promo_data;


$promo_id                 = isset( $promo_data['id'] ) ? absint( $promo_data['id'] ) : 0;
$notice_title             = isset( $notice_data['title'] ) ? $notice_data['title'] : ( isset( $promo_data['notice_title'] ) ? $promo_data['notice_title'] : '' );
$notice_cta_text          = isset( $notice_data['cta_text'] ) ? $notice_data['cta_text'] : ( isset( $promo_data['notice_cta_text'] ) ? $promo_data['notice_cta_text'] : '' );
$notice_percentage        = isset( $notice_data['percentage_off'] ) ? $notice_data['percentage_off'] : ( isset( $promo_data['notice_percentage_off'] ) ? $promo_data['notice_percentage_off'] : '' );
$notice_button_text       = isset( $notice_data['button_text'] ) ? $notice_data['button_text'] : ( isset( $promo_data['notice_button_text'] ) ? $promo_data['notice_button_text'] : '' );
$notice_button_url        = isset( $notice_data['button_url'] ) ? $notice_data['button_url'] : ( isset( $promo_data['notice_button_url'] ) ? $promo_data['notice_button_url'] : '' );
$notice_button_text_color = ! empty( $notice_data['button_text_color'] ) ? sanitize_hex_color( $notice_data['button_text_color'] ) : ( ! empty( $promo_data['notice_button_text_color'] ) ? sanitize_hex_color( $promo_data['notice_button_text_color'] ) : '#7428F8' );
$notice_button_bg_color   = ! empty( $notice_data['button_bg_color'] ) ? sanitize_hex_color( $notice_data['button_bg_color'] ) : ( ! empty( $promo_data['notice_button_bg_color'] ) ? sanitize_hex_color( $promo_data['notice_button_bg_color'] ) : '#FFFFFF' );


?>

<div class="notice ps-notice ps-gradient-animated is-dismissible ps-border-0"
	data-promo-id="<?php echo esc_attr( $promo_id ); ?>"
	data-specific-pages="<?php echo esc_attr( $this->config['specific_pages'] ?? '' ); ?>"
	data-plugin-page-slug="<?php echo esc_attr( $this->config['plugin_page_slug'] ?? '' ); ?>"
	style="display: none; background: linear-gradient(135deg, #667eea, #764ba2, #f093fb, #4facfe, #00f2fe); box-shadow: 0 -4px 20px rgba(0, 0, 0, 0.15) !important; position: fixed !important; bottom: 0 !important; left: 160px !important; right: 0 !important; z-index: 100 !important; margin: 0 !important; overflow: hidden !important;">

	<!-- Decorative Background Pattern -->
	<div class="ps-absolute ps-inset-0 ps-opacity-10 ps-pointer-events-none" style="background-image: repeating-linear-gradient(45deg, transparent, transparent 10px, rgba(255,255,255,.1) 10px, rgba(255,255,255,.1) 20px);"></div>

	<!-- Promo Bar Content -->
	<div class="ps-notice-bar ps-text-white ps-py-4 ps-px-6 ps-relative ps-z-10">
		<div class="ps-notice-inner">
			<!-- Left Section: Text -->
			<div class="ps-flex ps-items-center ps-gap-2">
				<span class="ps-font-semibold" style="font-size: 20px;">
					<?php echo wp_kses_post( $notice_title ); ?>
				</span>
			</div>

			<!-- Center Section: Countdown Timer -->
			<div class="ps-countdown-inline ps-flex ps-items-center ps-gap-4" data-end-time="<?php echo esc_attr( $countdown_end_time ); ?>">
				<?php if ( ! empty( $notice_cta_text ) ) : ?>
					<p class="ps-text-cyan-50 ps-text-sm ps-m-0 ps-leading-snug">
						<?php echo wp_kses_post( $notice_cta_text ); ?>
					</p>
				<?php endif; ?>

				<!-- Timer -->
				<div class="ps-flex ps-items-center ps-gap-1">
					<!-- Days -->
					<span class="ps-timer-number" data-unit="days">00</span>
					<span class="ps-timer-label"><?php esc_html_e( 'd:', 'promo-sdk' ); ?></span>

					<!-- Hours -->
					<span class="ps-timer-number" data-unit="hours">00</span>
					<span class="ps-timer-label"><?php esc_html_e( 'h:', 'promo-sdk' ); ?></span>

					<!-- Minutes -->
					<span class="ps-timer-number" data-unit="minutes">00</span>
					<span class="ps-timer-label"><?php esc_html_e( 'm:', 'promo-sdk' ); ?></span>

					<!-- Seconds -->
					<span class="ps-timer-number" data-unit="seconds" style="color: #F6FF00; animation: ps-countdown-glow 1s ease-in-out infinite;">00</span>
				</div>
			</div>

			<!-- Right Section: CTA Button -->
			<div class="ps-flex ps-items-center ps-gap-4">
				<a href="<?php echo esc_url( $notice_button_url ); ?>"
				class="ps-cta-button ps-inline-flex ps-items-center ps-gap-2 ps-font-semibold ps-px-6 ps-py-2 ps-no-underline ps-whitespace-nowrap"
				style="background: <?php echo esc_attr( $notice_button_bg_color ); ?>; color: <?php echo esc_attr( $notice_button_text_color ); ?>; border-radius: 12px;"
				target="_blank"
				rel="noopener noreferrer">
					<?php echo esc_html( $notice_button_text ); ?>
					<span class="ps-arrow-bounce">→</span>
				</a>
			</div>
		</div>
	</div>
</div>
