<?php
/**
 * Modal Template - Figma Design Match
 *
 * @package PromoSDK
 */

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
?>

<div id="promo-sdk-modal-<?php echo esc_attr( $this->config['product_slug'] ?? 'default' ); ?>" class="ps-modal" style="display:none;" data-promo-id="" data-product-slug="<?php echo esc_attr( $this->config['product_slug'] ?? '' ); ?>" tabindex="-1" role="dialog" aria-labelledby="promo-modal-title-<?php echo esc_attr( $this->config['product_slug'] ?? 'default' ); ?>" aria-hidden="true">
	<div class="ps-modal-overlay" aria-hidden="true"></div>
	<div class="ps-modal-container">
		<div class="ps-modal-content" style="width: 600px; max-width: 90vw; height: auto; background-image: url('<?php echo esc_url( plugin_dir_url( __FILE__ ) . '../assets/img/promo-bg.png' ); ?>'); background-size: cover; background-position: center; background-repeat: no-repeat; border-radius: 42px; position: relative; overflow: hidden;">
			
			<!-- Top Decorative Section -->
			<div style="position: relative; height: 160px; display: flex; align-items: center; justify-content: center;">
			</div>
			
			<!-- Close Button -->
			<button type="button" class="ps-modal-close" style="position: absolute; top: 16px; right: 20px; color: #FFFFFF66; font-size: 38px; background: none; border: none; cursor: pointer; z-index: 20; transition: all 0.2s; line-height: 1; padding: 0; font-weight: 300;" onmouseover="this.style.color='rgba(255,255,255,0.8)'" onmouseout="this.style.color='#FFFFFF66'" aria-label="<?php esc_attr_e( 'Close', 'promo-sdk' ); ?>">
				×
			</button>

			<!-- Content Section -->
			<div style="padding: 10px 50px 40px; text-align: center;">
				
				<!-- Title with Fire Emoji -->
				<h2 id="promo-modal-title-<?php echo esc_attr( $this->config['product_slug'] ?? 'default' ); ?>" style="color: #FFFFFF; font-size: 28px; font-weight: 700; margin: 0 0 10px 0; line-height: 1.3;">
					<!-- <span style="font-size: 28px; margin-right: 6px;">🔥</span> -->
					<span class="ps-modal-title-text"></span>
				</h2>

				<!-- Subtitle CTA -->
				<p class="ps-modal-cta-text" style="display: block; color: #9CA6C8; font-size: 13px; margin: 0 0 18px 0; font-weight: 500;">
					<span style="font-size: 14px; margin-right: 4px;">⏰</span>
					<span class="ps-modal-cta-text-content"></span>
				</p>

				<!-- Countdown Timer - Horizontal -->
				<div class="ps-countdown" data-end-time="" style="margin: 0 auto 28px; display: flex; justify-content: center; align-items: center; gap: 6px;">
					<!-- Days -->
					<div style="text-align: center;">
						<div style="background: #E8EAF0; border-radius: 10px; padding: 12px 8px; min-width: 30px;">
							<span class="ps-countdown-value" data-unit="days" style="font-size: 22px; font-weight: 700; color: #1F2937; display: block; line-height: 1;">0</span>
						</div>
						<div style="font-size: 11px; color: #8B92B0; font-weight: 500; margin-top: 5px;"><?php esc_html_e( 'Days', 'promo-sdk' ); ?></div>
					</div>
					<!-- Separator -->
					<div style="font-size: 20px; color: #8B92B0; font-weight: 600; padding-bottom: 18px;">:</div>
					<!-- Hours -->
					<div style="text-align: center;">
						<div style="background: #E8EAF0; border-radius: 10px; padding: 12px 8px; min-width: 30px;">
							<span class="ps-countdown-value" data-unit="hours" style="font-size: 22px; font-weight: 700; color: #1F2937; display: block; line-height: 1;">0</span>
						</div>
						<div style="font-size: 11px; color: #8B92B0; font-weight: 500; margin-top: 5px;"><?php esc_html_e( 'Hours', 'promo-sdk' ); ?></div>
					</div>
					<!-- Separator -->
					<div style="font-size: 20px; color: #8B92B0; font-weight: 600; padding-bottom: 18px;">:</div>
					<!-- Minutes -->
					<div style="text-align: center;">
						<div style="background: #E8EAF0; border-radius: 10px; padding: 12px 8px; min-width: 30px;">
							<span class="ps-countdown-value" data-unit="minutes" style="font-size: 22px; font-weight: 700; color: #1F2937; display: block; line-height: 1;">0</span>
						</div>
						<div style="font-size: 11px; color: #8B92B0; font-weight: 500; margin-top: 5px;"><?php esc_html_e( 'Mins', 'promo-sdk' ); ?></div>
					</div>
					<!-- Separator -->
					<div style="font-size: 20px; color: #8B92B0; font-weight: 600; padding-bottom: 18px;">:</div>
					<!-- Seconds -->
					<div style="text-align: center;">
						<div style="background: #E8EAF0; border-radius: 10px; padding: 12px 8px; min-width: 30px;">
							<span class="ps-countdown-value" data-unit="seconds" style="font-size: 22px; font-weight: 700; color: #FE3C06; display: block; line-height: 1;">0</span>
						</div>
						<div style="font-size: 11px; color: #8B92B0; font-weight: 500; margin-top: 5px;"><?php esc_html_e( 'Secs', 'promo-sdk' ); ?></div>
					</div>
				</div>

				<!-- CTA Button -->
				<a href="#" 
				class="ps-cta-button" 
				data-default-bg="#085DF2"
				data-default-text="#FFFFFF"
				style="display: inline-block; padding: 15px 45px; font-weight: 700; font-size: 24px; border-radius: 14px; text-decoration: none; cursor: pointer;"
				target="_blank"
				rel="noopener noreferrer">
				</a>

				<!-- Demo Link -->
				<?php if ( empty( $this->config['hide_modal_demo_link'] ) ) : ?>
					<div style="margin-top: 14px;">
						<a href="#" class="ps-demo-link" style="color: #8B92B0; font-size: 13px; text-decoration: underline; font-weight: 500; transition: color 0.2s;" onmouseover="this.style.color='#C7D2FE'" onmouseout="this.style.color='#8B92B0'" target="_blank" rel="noopener noreferrer">
							<?php esc_html_e( 'Try Free Demo', 'promo-sdk' ); ?>
						</a>
					</div>
				<?php endif; ?>
			</div>
		</div>
	</div>
</div>
