<?php
/**
 * Modal Renderer Class
 *
 * @package PromoSDK
 */

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}


if ( ! class_exists( 'Modal_Renderer' ) ) {
	/**
	 * Modal Renderer Class
	 *
	 * Handles rendering of modal popup component.
	 *
	 * @since 1.0.0
	 */
	class Modal_Renderer {
		/**
		 * Configuration array
		 *
		 * @var array
		 */
		private $config = array();

		/**
		 * Countdown Handler instance
		 *
		 * @var Countdown_Handler
		 */
		private $countdown_handler = null;

		/**
		 * Constructor
		 *
		 * @param array             $config Configuration array.
		 * @param Countdown_Handler $countdown_handler Countdown handler instance.
		 */
		public function __construct( $config, $countdown_handler ) {
			$this->config            = $config;
			$this->countdown_handler = $countdown_handler;
		}

		/**
		 * Render modal template (always rendered, hidden by default)
		 * JavaScript will populate and show it when needed
		 *
		 * @return void
		 */
		public function render_template() {
			// Include template - it will be hidden by default and shown via JS.
			$template_path = __DIR__ . '/templates/modal-template.php';

			if ( file_exists( $template_path ) ) {
				include $template_path;
			}
		}
	}
}
