<?php
/**
 * Handles translatable strings for ZooMeet.
 *
 * This class provides an array of commonly used time-related terms
 * that can be translated into different languages using WordPress internationalization functions.
 *
 * @since 1.0.0
 * @package SOVLIX\ZMEET
 */

namespace SOVLIX\ZMEET;

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( ! class_exists( 'Zmeet_Translate' ) ) {
	/**
	 * Provides translatable strings for time-related terms.
	 *
	 * @since 1.2.0
	 */
	class Zmeet_Translate {

		/**
		 * Retrieves an array of translatable time-related terms.
		 *
		 * @since 1.2.0
		 * @return array List of translatable strings.
		 */
		public static function strings() {
			return array(
				'day'                                                => __( 'Day', 'zoomeet' ),
				'days'                                               => __( 'Days', 'zoomeet' ),
				'hour'                                               => __( 'Hour', 'zoomeet' ),
				'hours'                                              => __( 'Hours', 'zoomeet' ),
				'minute'                                             => __( 'Minute', 'zoomeet' ),
				'minutes'                                            => __( 'Minutes', 'zoomeet' ),
				'second'                                             => __( 'Second', 'zoomeet' ),
				'seconds'                                            => __( 'Seconds', 'zoomeet' ),
				'are_you_sure_you_want_to_end'                       => __( 'Are you sure you want to end this meeting or webinar?', 'zoomeet' ),
				'are_you_sure_you_want_to_start'                     => __( 'Are you sure you want to Start this meeting?', 'zoomeet' ),
				'frontend_meeting'                                   => __( 'Frontend Meeting', 'zoomeet' ),
				'frontend_manage_msg'                                => __( 'Allow users to schedule and manage meetings directly from the frontend. Login is required.', 'zoomeet' ),
				'multivendor_addon'                                  => __( 'Multivendor Addon', 'zoomeet' ),
				'multivendor_desc'                                   => __( 'Seamlessly integrate ZooMeet with Dokan, WCFM, and MultivendorX. Empower vendors to schedule and host video meetings and webinars directly from their dashboards. Unlock new revenue streams by monetizing virtual events effortlessly.', 'zoomeet' ),

				'shortcode_instruction'                              => __( 'Use the shortcode below to display the meeting dashboard:', 'zoomeet' ),
				'toggle_activate_deactivate'                         => __( 'Toggle to activate/deactivate', 'zoomeet' ),
				'copy_shortcode'                                     => __( 'Copy Shortcode', 'zoomeet' ),
				'upgrade_to_pro'                                     => __( 'Upgrade to Pro', 'zoomeet' ),
				'available_in_pro'                                   => __( 'Available in Pro', 'zoomeet' ),
				'pro'                                                => __( 'Pro', 'zoomeet' ),
				'woocommerce'                                        => __( 'WooCommerce', 'zoomeet' ),
				'woocommerce_sell_msg'                               => __( 'Sell meetings as a product directly through WooCommerce. Customers can purchase and access meetings seamlessly after completing their orders.', 'zoomeet' ),
				'woocommerce_booking'                                => __( 'WooCommerce Booking', 'zoomeet' ),
				'booking_auto_meeting'                               => __( 'Automatically create meetings when an appointment is booked through WooCommerce Bookings. Simplify scheduling and improve customer experience.', 'zoomeet' ),
				'tutor_lms'                                          => __( 'Tutor LMS', 'zoomeet' ),
				'tutor_lms_msg'                                      => __( 'Enable instructors to create and manage meetings directly from the frontend. Easily attach meetings to lessons and courses for seamless online learning.', 'zoomeet' ),
				'academy_lms'                                        => __( 'Academy LMS', 'zoomeet' ),
				'academy_lms_msg'                                    => __( 'Enable instructors to schedule and host meetings from the frontend. Effortlessly link live sessions to courses and lessons for interactive online learning.', 'zoomeet' ),
				'google_calendar'                                    => __( 'Google Calendar', 'zoomeet' ),
				'google_calendar_msg'                                => __( 'Easily add scheduled meetings to Google Calendar with a single click. A button redirects users to Google Calendar, making it simple to store and organize meetings.', 'zoomeet' ),
				'settings_updated'                                   => __( 'Settings updated successfully.', 'zoomeet' ),
				'settings_failed_save'                               => __( 'Failed to save settings.', 'zoomeet' ),
				'settings_failed_update'                             => __( 'Failed to update settings.', 'zoomeet' ),
				'toggle_enable_disable'                              => __( 'Toggle to enable/disable', 'zoomeet' ),
				'error_fetching_data'                                => __( 'Error fetching data:', 'zoomeet' ),
				'search'                                             => __( 'Search', 'zoomeet' ),
				'actions'                                            => __( 'Actions', 'zoomeet' ),
				'topic'                                              => __( 'Topic', 'zoomeet' ),
				'start_time'                                         => __( 'Start Time', 'zoomeet' ),
				'meeting_link'                                       => __( 'Meeting Link', 'zoomeet' ),
				'no_webinar'                                         => __( 'No webinar available.', 'zoomeet' ),
				'no_meetings'                                        => __( 'No meetings available.', 'zoomeet' ),
				'no_records'                                         => __( 'No matching records found', 'zoomeet' ),
				'previous'                                           => __( 'Previous', 'zoomeet' ),
				'next'                                               => __( 'Next', 'zoomeet' ),
				'select_host'                                        => __( 'Select a Host to get recording data.', 'zoomeet' ),
				'no_recordings_range'                                => __( 'You have no recordings in this date range.', 'zoomeet' ),
				'api_error'                                          => __( 'API Error:', 'zoomeet' ),
				'recording_error'                                    => __( 'An error occurred while fetching recordings.', 'zoomeet' ),
				'get_recording_period'                               => __( 'Get recording for a specified period:', 'zoomeet' ),
				'show'                                               => __( 'Show', 'zoomeet' ),
				'select_host_placeholder'                            => __( 'Select a host..', 'zoomeet' ),
				'select_host_date'                                   => __( 'Please select a host and valid date range to get recording.', 'zoomeet' ),
				'daily_report'                                       => __( 'Daily Report', 'zoomeet' ),
				'account_report'                                     => __( 'Account Report', 'zoomeet' ),
				'enter_date'                                         => __( 'Enter the date to check:', 'zoomeet' ),
				'get_account_report'                                 => __( 'Get account report for a specified period:', 'zoomeet' ),
				'to'                                                 => __( 'To', 'zoomeet' ),
				'select_date'                                        => __( 'Please select a date to view reports', 'zoomeet' ),
				'select_valid_range'                                 => __( 'Please select valid date range to view reports', 'zoomeet' ),
				'copied'                                             => __( 'Copied', 'zoomeet' ),
				'note_no_hosts'                                      => __( 'Note: Did not find any hosts here ? Please check zoom settings to verify your API keys are working correctly.', 'zoomeet' ),
				'note_webinar_plan'                                  => __( 'Note: Webinar requires Zoom Webinar Plan enabled in your account', 'zoomeet' ),
				'zoom_email_info'                                    => __( 'Users will receive an email from Zoom containing a confirmation link. Clicking this link will activate their Zoom account. Users can then set or change their password within Zoom.', 'zoomeet' ),
				'create'                                             => __( 'Create', 'zoomeet' ),
				'automated_create'                                   => __( 'Automated Create', 'zoomeet' ),
				'automated_create_note'                              => __( 'This feature is intended for enterprise customers with managed domains. It is disabled by default due to the security risks associated with creating a user without their explicit notification.', 'zoomeet' ),
				'custom_create'                                      => __( 'Custom Create', 'zoomeet' ),
				'custom_create_note'                                 => __( 'This feature is only available for API partners. Users created in this manner do not have passwords and cannot log into the Zoom website or client.', 'zoomeet' ),
				'sso_create'                                         => __( 'SSO Create', 'zoomeet' ),
				'sso_create_note'                                    => __( 'This feature is available for users with the "Pre-provisioning SSO User" option enabled. Users created in this manner do not have passwords. If the user is not a basic user, a Personal Vanity URL will be generated using their username (without domain) from the provisioning email. If the username or PMI is invalid or already in use, a random number/random personal vanity URL will be assigned.', 'zoomeet' ),
				'upcoming'                                           => __( 'Upcomming', 'zoomeet' ),
				'ends_in'                                            => __( 'Ends in', 'zoomeet' ),
				'deal_note_once'                                     => __( 'This offer won’t come again, we promise!', 'zoomeet' ),
				'url_not_available'                                  => __( 'URL not available', 'zoomeet' ),
				'zmeet_data_missing'                                  => __( 'zmeetMeetingsData not defined', 'zoomeet' ),
				'unlock_all_features'                                => __( 'Stay Tuned — Something Awesome is on the Way 🎉', 'zoomeet' ),
				'black_friday_ltd'                                   => __( 'Black Friday Lifetime Deal', 'zoomeet' ),
				'deal_dont_miss'                                     => __( 'Don\'t miss the attractive deal! Grab it fast!', 'zoomeet' ),
				'claim'                                              => __( 'Claim', 'zoomeet' ),
				'off'                                                => __( 'OFF', 'zoomeet' ),
				'get_premium'                                        => __( 'Get Premium', 'zoomeet' ),
				'choose_thumbnail'                                   => __( 'Choose Thumbnail', 'zoomeet' ),
				'upload_thumbnail'                                   => __( 'Upload Thumbnail', 'zoomeet' ),
				'reset'                                              => __( 'Reset', 'zoomeet' ),
				'meeting_thumbnail'                                  => __( 'Meeting Thumbnail', 'zoomeet' ),
				'meeting_id'                                         => __( 'Meeting ID', 'zoomeet' ),
				'duration'                                           => __( 'Duration', 'zoomeet' ),
				'recorded'                                           => __( 'Recorded', 'zoomeet' ),
				'size'                                               => __( 'Size', 'zoomeet' ),
				'view_recordings'                                    => __( 'View Recordings', 'zoomeet' ),
				'file_type'                                          => __( 'File Type', 'zoomeet' ),
				'file_size'                                          => __( 'File Size', 'zoomeet' ),
				'play'                                               => __( 'Play:', 'zoomeet' ),
				'play2'                                              => __( 'Play', 'zoomeet' ),
				'download'                                           => __( 'Download', 'zoomeet' ),
				'download                                            :' => __( 'Download:', 'zoomeet' ),
				'no_recordings'                                      => __( 'No recordings available', 'zoomeet' ),
				'no_report_data'                                     => __( 'No report data found', 'zoomeet' ),
				'email'                                              => __( 'Email', 'zoomeet' ),
				'meetings_held'                                      => __( 'Meetings Held', 'zoomeet' ),
				'total_participants'                                 => __( 'Total Participants', 'zoomeet' ),
				'total_minutes'                                      => __( 'Total Meeting Minutes', 'zoomeet' ),
				'last_login_time'                                    => __( 'Last Login Time', 'zoomeet' ),
				'date'                                               => __( 'Date', 'zoomeet' ),
				'meetings'                                           => __( 'Meetings', 'zoomeet' ),
				'new_users'                                          => __( 'New Users', 'zoomeet' ),
				'participants'                                       => __( 'Participants', 'zoomeet' ),
				'meeting_minutes'                                    => __( 'Meeting Minutes', 'zoomeet' ),
				'all_users'                                          => __( 'All Users', 'zoomeet' ),
				'add_user'                                           => __( 'Add a User', 'zoomeet' ),
				'user_id'                                            => __( 'User ID', 'zoomeet' ),
				'name'                                               => __( 'Name', 'zoomeet' ),
				'created_on'                                         => __( 'Created On', 'zoomeet' ),
				'last_login'                                         => __( 'Last Login', 'zoomeet' ),
				'last_client'                                        => __( 'Last Client', 'zoomeet' ),
				'status'                                             => __( 'Status', 'zoomeet' ),
				'create_new_user'                                    => __( 'Create New User', 'zoomeet' ),
				'auto_create'                                        => __( 'Auto Create', 'zoomeet' ),
				'cust_create'                                        => __( 'Cust Create', 'zoomeet' ),
				'sso_create_short'                                   => __( 'SSO Create', 'zoomeet' ),
				'failed_create_user'                                 => __( 'Failed to Create User !', 'zoomeet' ),
				'no_permission_user'                                 => __( 'You don\'t have permission to add a new user', 'zoomeet' ),
				'user_created'                                       => __( 'User Created Successfully.', 'zoomeet' ),
				'back'                                               => __( 'Back', 'zoomeet' ),
				'add_user_short'                                     => __( 'Add User', 'zoomeet' ),
				'what_does_this'                                     => __( 'What does this do? Check out', 'zoomeet' ),
				'zoom_website'                                       => __( 'Zoom website', 'zoomeet' ),
				'pro_account_note'                                   => __( 'Please note this requires a PRO Zoom account or Higher.', 'zoomeet' ),
				'type_action'                                        => __( 'Type of Action', 'zoomeet' ),
				'email_address'                                      => __( 'Email Address', 'zoomeet' ),
				'email_note'                                         => __( 'This address is used for zoom', 'zoomeet' ),
				'first_name'                                         => __( 'First Name', 'zoomeet' ),
				'first_name_note'                                    => __( 'First Name of the User', 'zoomeet' ),
				'last_name'                                          => __( 'Last Name', 'zoomeet' ),
				'last_name_note'                                     => __( 'Last Name of the User', 'zoomeet' ),
				'user_type'                                          => __( 'User Type', 'zoomeet' ),
				'user_type_note'                                     => __( 'Type of User', 'zoomeet' ),
				'create_user'                                        => __( 'Create User', 'zoomeet' ),
				'add_new_meeting'                                    => __( 'Add New Meeting', 'zoomeet' ),
				'zoom'                                               => __( 'Zoom', 'zoomeet' ),
				'edit_meeting'                                       => __( 'Edit Meeting', 'zoomeet' ),
				'all_meetings'                                       => __( 'All Meetings', 'zoomeet' ),
				'add_new'                                            => __( 'Add new', 'zoomeet' ),
				'meeting_deleted'                                    => __( 'Meeting Deleted Successfully.', 'zoomeet' ),
				'meeting_delete_failed'                              => __( 'Failed to Delete Meeting !', 'zoomeet' ),
				'meetings_deleted'                                   => __( 'Meetings Deleted Successfully.', 'zoomeet' ),
				'meetings_delete_failed'                             => __( 'Failed to Delete Meetings !', 'zoomeet' ),
				'created_at'                                         => __( 'Created At', 'zoomeet' ),
				'platform'                                           => __( 'Platform', 'zoomeet' ),
				'shortcode'                                          => __( 'Shortcode', 'zoomeet' ),
				'no_meetings_yet'                                    => __( 'No meetings created yet', 'zoomeet' ),
				'copied_clipboard'                                   => __( 'Copied to clipboard', 'zoomeet' ),
				'delete_all_meetings'                                => __( 'Delete all Meetings?', 'zoomeet' ),
				'delete_meeting'                                     => __( 'Delete Meeting?', 'zoomeet' ),
				'confirm_delete_all'                                 => __( 'Are you sure you want to delete all selected meetings?', 'zoomeet' ),
				'confirm_delete_single'                              => __( 'Are you sure you want to delete this meeting?', 'zoomeet' ),
				'confirm_delete'                                     => __( 'Confirm Delete', 'zoomeet' ),
				'cancel'                                             => __( 'Cancel', 'zoomeet' ),
				'sunday'                                             => __( 'Sunday', 'zoomeet' ),
				'monday'                                             => __( 'Monday', 'zoomeet' ),
				'tuesday'                                            => __( 'Tuesday', 'zoomeet' ),
				'wednesday'                                          => __( 'Wednesday', 'zoomeet' ),
				'thursday'                                           => __( 'Thursday', 'zoomeet' ),
				'friday'                                             => __( 'Friday', 'zoomeet' ),
				'saturday'                                           => __( 'Saturday', 'zoomeet' ),
				'meeting_updated'                                    => __( 'Meeting Updated Successfully.', 'zoomeet' ),
				'failed_update_meeting'                              => __( 'Failed to Update Meeting!', 'zoomeet' ),
				'minutes_before_1'                                   => __( '1 Minutes Before', 'zoomeet' ),
				'minutes_before_5'                                   => __( '5 Minutes Before', 'zoomeet' ),
				'minutes_before_15'                                  => __( '15 Minutes Before', 'zoomeet' ),
				'minutes_before_30'                                  => __( '30 Minutes Before', 'zoomeet' ),
				'confirmed'                                          => __( 'Confirmed', 'zoomeet' ),
				'tentative'                                          => __( 'Tentative', 'zoomeet' ),
				'all'                                                => __( 'All', 'zoomeet' ),
				'external_only'                                      => __( 'External Only', 'zoomeet' ),
				'none'                                               => __( 'None', 'zoomeet' ),
				'opaque_block'                                       => __( 'Opaque, Blocks Time on the Calendar', 'zoomeet' ),
				'transparent_not_block'                              => __( 'Transparent, does not Blocks Time', 'zoomeet' ),
				'default'                                            => __( 'Default', 'zoomeet' ),
				'public'                                             => __( 'Public', 'zoomeet' ),
				'private'                                            => __( 'Private', 'zoomeet' ),
				'daily'                                              => __( 'Daily', 'zoomeet' ),
				'weekly'                                             => __( 'Weekly', 'zoomeet' ),
				'monthly'                                            => __( 'Monthly', 'zoomeet' ),
				'yearly'                                             => __( 'Yearly', 'zoomeet' ),
				'first_week'                                         => __( 'First week of the month', 'zoomeet' ),
				'second_week'                                        => __( 'Second week of the month', 'zoomeet' ),
				'third_week'                                         => __( 'Third week of the month', 'zoomeet' ),
				'fourth_week'                                        => __( 'Fourth week of the month', 'zoomeet' ),
				'last_week'                                          => __( 'Last week of the month', 'zoomeet' ),
				'by_date'                                            => __( 'By date', 'zoomeet' ),
				'by_occurrences'                                     => __( 'By occurrences', 'zoomeet' ),
				'never'                                              => __( 'Never', 'zoomeet' ),
				'weekdays'                                           => __( 'Weekdays', 'zoomeet' ),
				'updating'                                           => __( 'Updating...', 'zoomeet' ),
				'update_meeting'                                     => __( 'Update Meeting', 'zoomeet' ),
				'meeting_name'                                       => __( 'Meeting Name', 'zoomeet' ),
				'enter_meeting_name'                                 => __( 'Please enter the meeting name', 'zoomeet' ),
				'meeting_description'                                => __( 'Meeting Description', 'zoomeet' ),
				'meeting_description_help'                           => __( 'Provide the details for your meeting here', 'zoomeet' ),
				'meeting_summary'                                    => __( 'Meeting Summary', 'zoomeet' ),
				'meeting_summary_help'                               => __( 'Write summary for your meeting', 'zoomeet' ),
				'meeting_thumbnail_upload'                           => __( 'Upload an image to represent your meeting visually', 'zoomeet' ),
				'start_datetime'                                     => __( 'Start Date & Time', 'zoomeet' ),
				'start_datetime_help'                                => __( 'Starting date and time of the meeting', 'zoomeet' ),
				'select_duration'                                    => __( 'Select meeting duration.', 'zoomeet' ),
				'recurring_meeting'                                  => __( 'Recurring Meeting', 'zoomeet' ),
				'enable_recurring'                                   => __( 'Enable recurring meeting.', 'zoomeet' ),
				'recurrence'                                         => __( 'Recurrence', 'zoomeet' ),
				'select_recurrence'                                  => __( 'Select recurrence option.', 'zoomeet' ),
				'repeat_every'                                       => __( 'Repeat Every', 'zoomeet' ),
				'repeat_every_help'                                  => __( 'Define the interval at which the meeting/webinar should recur.', 'zoomeet' ),
				'occurs_on'                                          => __( 'Occurs On', 'zoomeet' ),
				'select_occurs_type'                                 => __( 'Select Occurs type.', 'zoomeet' ),
				'set_order'                                          => __( 'Set Order', 'zoomeet' ),
				'set_order_help'                                     => __( 'Set Order for the month.', 'zoomeet' ),
				'set_weekday'                                        => __( 'Set weekday', 'zoomeet' ),
				'select_weekday'                                     => __( 'Select weekday.', 'zoomeet' ),
				'select_weekdays'                                    => __( 'Select weekdays.', 'zoomeet' ),
				'ends'                                               => __( 'Ends', 'zoomeet' ),
				'end_date'                                           => __( 'End Date', 'zoomeet' ),
				'select_end_type'                                    => __( 'Select end type.', 'zoomeet' ),
				'set_num_occurrences'                                => __( 'Set Number Of Occurrences', 'zoomeet' ),
				'set_num_occurrences_help'                           => __( 'Select how many times the meeting/webinar should recur before it is canceled.', 'zoomeet' ),
				'set_end_date'                                       => __( 'Set End Date', 'zoomeet' ),
				'set_end_date_help'                                  => __( 'Select the final date on which meeting/webinar will recur before it is canceled.', 'zoomeet' ),
				'timezone'                                           => __( 'Timezone', 'zoomeet' ),
				'meeting_timezone'                                   => __( 'Meeting Timezone.', 'zoomeet' ),
				'show_user_timezone'                                 => __( 'Show Event Time in User’s Timezone', 'zoomeet' ),
				'show_user_timezone_help'                            => __( 'Enable this option to display meeting and webinar times in the user’s local timezone on the meeting page and within shortcodes.', 'zoomeet' ),
				'should_register'                                    => __( 'Should Register', 'zoomeet' ),
				'should_register_help'                               => __( 'If user should be register to join the meeting', 'zoomeet' ),
				'password'                                           => __( 'Password', 'zoomeet' ),
				'password_help'                                      => __( 'Set a password (max 10 characters, [a-zA-Z0-9])', 'zoomeet' ),
				'default_reminder_time'                              => __( 'Default Reminder Time', 'zoomeet' ),
				'default_reminder_time_help'                         => __( 'Set a default reminder time to get an email notification.', 'zoomeet' ),
				'default_event_status'                               => __( 'Set Default Event Status', 'zoomeet' ),
				'default_event_status_meet'                          => __( 'Set a default status for Google Meet event', 'zoomeet' ),
				'send_updates'                                       => __( 'Send Updates', 'zoomeet' ),
				'send_updates_help'                                  => __( 'Select how to send notifications about the creation of the new event. Note that some emails might still be sent.', 'zoomeet' ),
				'transparency'                                       => __( 'Transparency', 'zoomeet' ),
				'transparency_help'                                  => __( 'Select if the events block time on the calendar by default.', 'zoomeet' ),
				'visibility_on_calendar'                             => __( 'Visibility on Calendar', 'zoomeet' ),
				'visibility_on_calendar_help'                        => __( 'Set the default visibility of the event on the calendar.', 'zoomeet' ),
				'hide_sidebar'                                       => __( 'Hide Sidebar', 'zoomeet' ),
				'hide_sidebar_help'                                  => __( 'Hide meeting page right sidebar', 'zoomeet' ),
				'hide_header_footer'                                 => __( 'Hide Header & Footer', 'zoomeet' ),
				'hide_header_footer_help'                            => __( 'Hide header & footer on meeting page', 'zoomeet' ),
				'creating'                                           => __( 'Creating...', 'zoomeet' ),
				'create_meeting'                                     => __( 'Create Meeting', 'zoomeet' ),
				'action'                                             => 'Action',
				'no_users_found'                                     => 'No users found',
				'error'                                              => 'Error',
				'basic_user'                                         => 'Basic User',
				'pro_user'                                           => 'Pro User',
				'meeting_created'                                    => __( 'Meeting Created Successfully.', 'zoomeet' ),
				'failed_create_meeting'                              => __( 'Failed to Create Meeting!', 'zoomeet' ),
				'res_480p'                                           => __( '480p', 'zoomeet' ),
				'res_720p'                                           => __( '720p', 'zoomeet' ),
				'res_1080p'                                          => __( '1080p', 'zoomeet' ),
				'res_1440p'                                          => __( '1440p', 'zoomeet' ),
				'res_2160p'                                          => __( '2160p', 'zoomeet' ),
				'res_4320p'                                          => __( '4320p', 'zoomeet' ),
				'month_january'                                      => __( 'January', 'zoomeet' ),
				'month_february'                                     => __( 'February', 'zoomeet' ),
				'month_march'                                        => __( 'March', 'zoomeet' ),
				'month_april'                                        => __( 'April', 'zoomeet' ),
				'month_may'                                          => __( 'May', 'zoomeet' ),
				'month_june'                                         => __( 'June', 'zoomeet' ),
				'month_july'                                         => __( 'July', 'zoomeet' ),
				'month_august'                                       => __( 'August', 'zoomeet' ),
				'month_september'                                    => __( 'September', 'zoomeet' ),
				'month_october'                                      => __( 'October', 'zoomeet' ),
				'month_november'                                     => __( 'November', 'zoomeet' ),
				'month_december'                                     => __( 'December', 'zoomeet' ),
				'meeting_create_failed'                              => __( 'Failed to Create Meeting !', 'zoomeet' ),
				'repeat_month'                                       => __( 'Repeat Month', 'zoomeet' ),
				'repeat_month_hint'                                  => __( 'Define the month at which the meeting should recur', 'zoomeet' ),
				'repeat_every_hint'                                  => __( 'Define the day at which the meeting should recur', 'zoomeet' ),
				'recurrence_time'                                    => __( 'Recurrence time', 'zoomeet' ),
				'recurrence_time_hint'                               => __( 'Time when the meeting will start', 'zoomeet' ),
				'meeting_height'                                     => __( 'Height', 'zoomeet' ),
				'meeting_height_hint'                                => __( 'Meeting height in pixels', 'zoomeet' ),
				'meeting_width'                                      => __( 'Width', 'zoomeet' ),
				'meeting_width_hint'                                 => __( 'Meeting width in pixels', 'zoomeet' ),

				'yourself_muted'                                     => __( 'Yourself Muted', 'zoomeet' ),
				'start_muted_audio'                                  => __( 'Start with audio muted', 'zoomeet' ),
				'start_muted_video'                                  => __( 'Start Video Muted', 'zoomeet' ),
				'start_with_muted_video'                             => __( 'Start with video muted', 'zoomeet' ),
				'screen_sharing'                                     => __( 'Screen Sharing', 'zoomeet' ),
				'screen_sharing_hint'                                => __( 'By enabling this feature, you\'re able to share your screen while attending a meeting', 'zoomeet' ),

				'enable_inviting'                                    => __( 'Enable Inviting', 'zoomeet' ),
				'attendee_can_invite'                                => __( 'Attendee can invite people', 'zoomeet' ),
				'audio_only'                                         => __( 'Audio Only', 'zoomeet' ),
				'start_audio_only'                                   => __( 'Start conference on audio only', 'zoomeet' ),
				'start_silent'                                       => __( 'Start Silent', 'zoomeet' ),
				'disable_local_audio'                                => __( 'Disable local audio output', 'zoomeet' ),

				'video_resolution'                                   => __( 'Video Resolution', 'zoomeet' ),
				'preferred_resolution'                               => __( 'Start with preferred resolution.', 'zoomeet' ),
				'max_full_resolution'                                => __( 'Max Full Resolution', 'zoomeet' ),
				'default_resolution_count'                           => __( 'Number of participants with default resolution', 'zoomeet' ),
				'video_muted_after'                                  => __( 'Video Muted After', 'zoomeet' ),
				'video_muted_nth'                                    => __( 'Every participant after nth will start video muted', 'zoomeet' ),
				'audio_muted_after'                                  => __( 'Start Audio Muted', 'zoomeet' ),
				'audio_muted_nth'                                    => __( 'Participant after nth will be muted', 'zoomeet' ),
				'start_with_yourself_muted'                          => __( 'Start with yourself muted', 'zoomeet' ),

				'enable_recording'                                   => __( 'Enable Recording', 'zoomeet' ),
				'enable_recording_hint'                              => __( 'Turn on to record the meeting', 'zoomeet' ),
				'enable_simulcast'                                   => __( 'Simulcast', 'zoomeet' ),
				'simulcast_hint'                                     => __( 'Enable/Disable simulcast', 'zoomeet' ),
				'enable_livestream'                                  => __( 'Enable Livestream', 'zoomeet' ),
				'livestream_hint'                                    => __( 'Turn on livestreaming', 'zoomeet' ),
				'enable_welcome'                                     => __( 'Welcome Page', 'zoomeet' ),
				'welcome_hint'                                       => __( 'Enable/Disable welcome page', 'zoomeet' ),
				'enable_transcription'                               => __( 'Enable Transcription', 'zoomeet' ),
				'transcription_hint'                                 => __( 'Transcript the meeting', 'zoomeet' ),
				'enable_outbound'                                    => __( 'Enable Outbound', 'zoomeet' ),
				'outbound_hint'                                      => __( 'Allow outbound on the meeting', 'zoomeet' ),
				'select_which_day_week'                              => __( 'Select which day on the week', 'zoomeet' ),
				'failed_to_update'                                   => __( 'Failed to Update Meeting!', 'zoomeet' ),
				'meeting_agenda'                                     => __( 'Meeting agenda', 'zoomeet' ),
				'agenda_hint'                                        => __( 'Write agenda for your meeting', 'zoomeet' ),
				'join_before_host'                                   => __( 'Join Before Host', 'zoomeet' ),
				'join_before_host_hint'                              => __( 'Whether or not to allow any attendee to join the meeting before the host joins the meeting', 'zoomeet' ),

				'auto_record'                                        => __( 'Auto Record Meeting', 'zoomeet' ),
				'auto_record_hint'                                   => __( 'Whether or not meeting is recorded automatically', 'zoomeet' ),
				'enable_breakout'                                    => __( 'Enable Breakout sessions', 'zoomeet' ),
				'enable_breakout_hint'                               => __( 'Whether or not breakout sessions is enabled', 'zoomeet' ),
				'enable_auto_lock'                                   => __( 'Enable Automatic Lock', 'zoomeet' ),
				'enable_auto_lock_hint'                              => __( 'Whether or not automatically lock is enabled', 'zoomeet' ),
				'lock_after'                                         => __( 'Meetings Lock After', 'zoomeet' ),
				'lock_after_hint'                                    => __( 'Automatically lock my meeting after the meeting starts', 'zoomeet' ),
				'meeting_created_successfully'                       => __( 'Meeting Created Successfully.', 'zoomeet' ),
				'webinar_created_successfully'                       => __( 'Webinar Created Successfully.', 'zoomeet' ),
				'failed_to_create_meeting'                           => __( 'Failed to Create Meeting !', 'zoomeet' ),
				'failed_to_create_webinar'                           => __( 'Failed to Create Webinar  !', 'zoomeet' ),
				'meeting'                                            => __( 'Meeting', 'zoomeet' ),
				'webinar'                                            => __( 'Webinar', 'zoomeet' ),
				'local'                                              => __( 'Local', 'zoomeet' ),
				'cloud'                                              => __( 'Cloud', 'zoomeet' ),
				'no_fixed_time'                                      => __( 'No Fixed Time', 'zoomeet' ),
				'first_week_of_the_month'                            => __( 'First week of the month', 'zoomeet' ),
				'second_week_of_the_month'                           => __( 'Second week of the month', 'zoomeet' ),
				'third_week_of_the_month'                            => __( 'Third week of the month', 'zoomeet' ),
				'fourth_week_of_the_month'                           => __( 'Fourth week of the month', 'zoomeet' ),
				'last_week_of_the_month'                             => __( 'Last week of the month', 'zoomeet' ),
				'1'                                                  => __( '1', 'zoomeet' ),
				'2'                                                  => __( '2', 'zoomeet' ),
				'3'                                                  => __( '3', 'zoomeet' ),
				'automatic_approval'                                 => __( 'Automatic Approval', 'zoomeet' ),
				'manual_approval'                                    => __( 'Manual Approval', 'zoomeet' ),
				'no_registration'                                    => __( 'No Registration', 'zoomeet' ),
				'register_once_for_all_sessions'                     => __( 'Register once for all sessions', 'zoomeet' ),
				'register_for_each_session_separately'               => __( 'Register for each session separately', 'zoomeet' ),
				'register_once_and_choose_sessions'                  => __( 'Register once and choose sessions', 'zoomeet' ),
				'to_enable_zoom_please_set_up_its_api_settings'      => __( 'To enable Zoom, please set up its API settings. ', 'zoomeet' ),
				'please_enter_the_meeting_name'                      => __( 'Please enter the meeting name', 'zoomeet' ),
				'upload_an_image_to_represent_your_meeting_visually' => __( 'Upload an image to represent your meeting visually', 'zoomeet' ),
				'write_agenda_for_your_meeting'                      => __( 'Write agenda for your meeting', 'zoomeet' ),
				'no_permission_add_user'                             => __( 'You don\'t have permission to add a new user', 'zoomeet' ),
				'meeting_host'                                       => __( 'Meeting host', 'zoomeet' ),
				'meeting_host_hint'                                  => __( 'This is the meeting host id.', 'zoomeet' ),
				'meeting_type'                                       => __( 'Meeting Type', 'zoomeet' ),
				'meeting_type_hint'                                  => __( 'Which type of meeting do you want to create.', 'zoomeet' ),
				'day_of_month'                                       => __( 'Day Of The Month', 'zoomeet' ),
				'register_for_webinar'                               => __( 'If user should be register to join the webinar', 'zoomeet' ),
				'registration_approval'                              => __( 'Registration Approval', 'zoomeet' ),
				'registration_approval_hint'                         => __( 'Choose how registrations are processed. Automatic approval adds registrants immediately, manual approval requires host review.', 'zoomeet' ),
				'recurring_registration_type'                        => __( 'Registration Requirement (For Recurring Webinars)', 'zoomeet' ),
				'recurring_registration_hint'                        => __( 'This setting applies only to recurring webinars with a fixed time. "Register once for all sessions" allows a single registration for all occurrences, "Register for each session separately" requires individual registrations per session, and "Register once and choose sessions" allows attendees to pick specific sessions.', 'zoomeet' ),
				'email_notifications'                                => __( 'Registrant Email Notifications', 'zoomeet' ),
				'email_notifications_hint'                           => __( 'Send automatic email confirmations to registrants. Includes registration details and joining instructions.', 'zoomeet' ),
				'disable_waiting_room'                               => __( 'Disable Waiting Room', 'zoomeet' ),
				'disable_waiting_room_hint'                          => __( 'Waiting Room is enabled by default - if you want users to skip the waiting room and join the meeting directly - enable this option.', 'zoomeet' ),
				'meeting_authentication'                             => __( 'Meeting Authentication', 'zoomeet' ),
				'meeting_authentication_hint'                        => __( 'Only loggedin users in Zoom App can join this Meeting.', 'zoomeet' ),
				'start_when_host_joins'                              => __( 'Start When Host Joins', 'zoomeet' ),
				'start_when_host_joins_hint'                         => __( 'Start video when host join meeting.', 'zoomeet' ),
				'participants_video'                                 => __( 'Participants Video', 'zoomeet' ),
				'participants_video_hint'                            => __( 'Start video when participants join meeting.', 'zoomeet' ),
				'mute_on_entry'                                      => __( 'Mute Participants upon entry', 'zoomeet' ),
				'mute_on_entry_hint'                                 => __( 'Mutes Participants when entering the meeting.', 'zoomeet' ),
				'panelists_join'                                     => __( 'When Panelists Join', 'zoomeet' ),
				'panelists_video_hint'                               => __( 'Start video when panelists join webinar.', 'zoomeet' ),
				'practise_session'                                   => __( 'Practise Session', 'zoomeet' ),
				'practise_session_hint'                              => __( 'Enable Practise Session.', 'zoomeet' ),
				'hd_video'                                           => __( 'HD Video', 'zoomeet' ),
				'hd_video_hint'                                      => __( 'Defaults to HD video.', 'zoomeet' ),
				'multiple_devices'                                   => __( 'Allow Multiple Devices', 'zoomeet' ),
				'multiple_devices_hint'                              => __( 'Allow attendess to join from multiple devices.', 'zoomeet' ),
				'auto_recording'                                     => __( 'Auto Recording', 'zoomeet' ),
				'auto_recording_hint'                                => __( 'Set what type of auto recording feature you want to add. Default is none.', 'zoomeet' ),
				'alternative_host'                                   => __( 'Alternative Host', 'zoomeet' ),
				'alternative_host_hint'                              => __( 'Backup hosts for meeting/webinar', 'zoomeet' ),
				'select_alternative_hosts'                           => __( 'Select alternative hosts..', 'zoomeet' ),
				'hide'                                               => __( 'Hide', 'zoomeet' ),
				'copy'                                               => __( 'Copy', 'zoomeet' ),
				'failed_to_copy'                                     => __( 'Failed to copy:', 'zoomeet' ),
				'fallback_failed_to_copy'                            => __( 'Fallback: Failed to copy text:', 'zoomeet' ),
				'setup_your'                                         => __( 'Setup your', 'zoomeet' ),
				'integration'                                        => __( 'Integration', 'zoomeet' ),
				'link'                                               => __( 'Link', 'zoomeet' ),
				'zoom_meeting_list'                                  => __( 'Zoom Meeting List', 'zoomeet' ),
				'zoom_webinar_list'                                  => __( 'Zoom Webinar List', 'zoomeet' ),
				'zoom_single_recording'                              => __( 'Zoom Single Recording', 'zoomeet' ),
				'zoom_recording_archive'                             => __( 'Zoom Recording Archive', 'zoomeet' ),
				'embed_zoom_meetings'                                => __( 'Embed a list of upcoming Zoom meetings', 'zoomeet' ),
				'embed_zoom_webinars'                                => __( 'Embed a list of upcoming Zoom webinars', 'zoomeet' ),
				'embed_single_recording'                             => __( 'Display a single Zoom meeting/webinar recording with metadata and header', 'zoomeet' ),
				'embed_zoom_recordings'                              => __( 'Display all Zoom meeting/webinar recordings in a grid layout with thumbnails and video playback', 'zoomeet' ),
				'settings_tab_coming'                                => __( 'Settings Tab (Upcoming Feature)', 'zoomeet' ),
				'video_tutorial'                                     => __( 'video tutorial', 'zoomeet' ),
				'for_assistance'                                     => __( 'for assistance.', 'zoomeet' ),
				'view_our'                                           => __( 'View our', 'zoomeet' ),
				'zoom_developer_portal'                              => __( 'Zoom Developer Portal', 'zoomeet' ),
				'sdk_credentials_instruction'                        => __( 'To configure SDK App Credentials, go to the', 'zoomeet' ),
				'oauth_account_id'                                   => __( 'Oauth Account ID', 'zoomeet' ),
				'renew_oauth_token'                                  => __( 'Renew OAuth Token', 'zoomeet' ),
				'renewing'                                           => __( 'Renewing...', 'zoomeet' ),
				'oauth_token_renewed'                                => __( 'OAuth Token Renewed Successfully!', 'zoomeet' ),
				'renew_failed_check_credentials'                     => __( 'Renew failed. Please check your credentials.', 'zoomeet' ),
				'something_went_wrong'                               => __( 'Something went wrong. Try again later.', 'zoomeet' ),
				'server_to_server_credentials'                       => __( 'Server to Server OAuth Credentials', 'zoomeet' ),
				'server_oauth_setup_hint'                            => __( 'For Zoom "Server-to-Server OAuth" setup, visit the', 'zoomeet' ),
				'oauth_client_id'                                    => __( 'Oauth Client ID', 'zoomeet' ),
				'oauth_client_secret'                                => __( 'Oauth Client Secret', 'zoomeet' ),
				'client_id'                                          => __( 'Client ID', 'zoomeet' ),
				'client_secret'                                      => __( 'Client Secret', 'zoomeet' ),
				'app_credentials'                                    => __( 'Meeting SDK App Credentials', 'zoomeet' ),
				'error_fetching_link'                                => __( 'Error fetching link:', 'zoomeet' ),
				'credential_uploaded'                                => __( 'Credential Uploaded Successfully.', 'zoomeet' ),
				'credential_upload_failed'                           => __( 'Failed to Upload Credential!', 'zoomeet' ),
				'upload_error'                                       => __( 'Upload error:', 'zoomeet' ),
				'upload_failed_retry'                                => __( 'Failed to upload file. Please try again.', 'zoomeet' ),
				'invalid_json_file'                                  => __( 'Please upload a valid JSON file.', 'zoomeet' ),
				'credential_reset_success'                           => __( 'Credential reset successfully.', 'zoomeet' ),
				'credential_reset_failed'                            => __( 'Failed to reset credential. Please try again.', 'zoomeet' ),
				'error_resetting_credential'                         => __( 'Error resetting credential:', 'zoomeet' ),
				'settings_saved'                                     => __( 'Settings Saved Successfully.', 'zoomeet' ),
				'saved'                                              => __( 'Saved', 'zoomeet' ),
				'save_changes'                                       => __( 'Save Changes', 'zoomeet' ),
				'failed_update_settings'                             => __( 'Failed to Update Settings !', 'zoomeet' ),
				'back_to_settings'                                   => __( 'Back to main settings', 'zoomeet' ),
				'connect'                                            => __( 'Connect', 'zoomeet' ),
				'configurations'                                     => __( 'Configurations', 'zoomeet' ),
				'shortcodes'                                         => __( 'Shortcodes', 'zoomeet' ),
				'create_meeting'                                     => __( 'Create Meeting', 'zoomeet' ),
				'saving'                                             => __( 'Saving...', 'zoomeet' ),
				'api_settings'                                       => __( 'Api Settings', 'zoomeet' ),
				'video_settings'                                     => __( 'Video Settings', 'zoomeet' ),
				'audio_settings'                                     => __( 'Audio Settings', 'zoomeet' ),
				'account_connected'                                  => __( 'Account connected', 'zoomeet' ),
				'upcoming'                                           => __( 'Upcoming', 'zoomeet' ),
				'configure'                                          => __( 'Configure', 'zoomeet' ),
				'zoom_config_hint'                                   => __( 'Adjust your Zoom settings to personalize your video conferencing sessions. Customize audio, video, and meeting options according to your preferences.', 'zoomeet' ),
				'api_error'                                          => __( 'API Error:', 'zoomeet' ),
				'error_fetching_data'                                => __( 'An error occurred while fetching data.', 'zoomeet' ),
				'settings'                                           => __( 'Settings', 'zoomeet' ),
				'create_new_meeting'                                 => __( 'Create New Meeting', 'zoomeet' ),
				'Copied2'                                            => __( 'Copied!', 'zoomeet' ),
				'upcomming'                                          => __( 'Upcomming', 'zoomeet' ),
				'hide_recordings'             => __( 'Hide Recordings', 'zoomeet' ),
				'view_recordings'             => __( 'View Recordings', 'zoomeet' ),
				'copy_url'                    => __( 'Copy URL', 'zoomeet' ),
				'meeting_visibility'          => __( 'Meeting Visibility', 'zoomeet' ),
				'show_all_meetings'           => __( 'Show All Meetings', 'zoomeet' ),
				'show_all_webinars'           => __( 'Show All Webinars', 'zoomeet' ),
				'user_specific'               => __( 'Filter by User', 'zoomeet' ),
				'role_based'                  => __( 'Filter by Role', 'zoomeet' ),
				'select_roles'                => __( 'Select Roles', 'zoomeet' ),
				'select_users'                => __( 'Select Users', 'zoomeet' ),
				'loading_users'               => __( 'Loading users...', 'zoomeet' ),
				'type_to_search_users'        => __( 'Type at least 2 characters to search users', 'zoomeet' ),
				'no_users_found_search'       => __( 'No users found', 'zoomeet' ),
				'search_users_placeholder'    => __( 'Search users by name, username, or email...', 'zoomeet' ),
				'visibility_settings_saved'   => __( 'Visibility settings saved.', 'zoomeet' ),
			);
		}
	}
}
