<?php
/**
 * Register post type
 *
 * @package SOVLIX\ZMEET
 */

namespace SOVLIX\ZMEET;

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( ! class_exists( 'Zmeet_Post_Types' ) ) {
	/**
	 * The Zmeet_Post_Types class
	 *
	 * @since 1.0.0
	 */
	class Zmeet_Post_Types {
		/**
		 * Zmeet_Post_Types constructor.
		 */
		public function __construct() {
			add_action( 'init', array( $this, 'zmeet_register_post_type' ) );
			add_filter( 'single_template', array( $this, 'zmeet_zmeet_template' ) );

			// Hook into save_post to flush rewrite rules when a meeting is saved or updated.
			add_action( 'save_post', array( $this, 'zmeet_flush_rewrite_rules_on_save' ) );
		}

		/**
		 * Register meeting post type
		 *
		 * @return void
		 *
		 * @since 1.0.0
		 */
		public function zmeet_register_post_type() {
			$labels = array(
				'name'               => _x( 'Meeting', 'Post type general name', 'zoomeet' ),
				'singular_name'      => _x( 'Meeting', 'Post type singular name', 'zoomeet' ),
				'menu_name'          => _x( 'Meetings', 'Admin Menu text', 'zoomeet' ),
				'name_admin_bar'     => _x( 'Meeting', 'Add New on Toolbar', 'zoomeet' ),
				'add_new'            => __( 'Add New', 'zoomeet' ),
				'add_new_item'       => __( 'Add New Meeting', 'zoomeet' ),
				'new_item'           => __( 'New Meeting', 'zoomeet' ),
				'edit_item'          => __( 'Edit Meeting', 'zoomeet' ),
				'view_item'          => __( 'View Meeting', 'zoomeet' ),
				'all_items'          => __( 'All Meetings', 'zoomeet' ),
				'search_items'       => __( 'Search Meetings', 'zoomeet' ),
				'parent_item_colon'  => __( 'Parent Meetings:', 'zoomeet' ),
				'not_found'          => __( 'No meetings found.', 'zoomeet' ),
				'not_found_in_trash' => __( 'No meetings found in trash.', 'zoomeet' ),
			);

			$args = array(
				'labels'             => $labels,
				'public'             => false,
				'publicly_queryable' => true,
				'show_ui'            => true,
				'show_in_menu'       => false,
				'query_var'          => true,
				'rewrite'            => array(
					'slug'       => 'zoom~meetings',
					'with_front' => false,
				),
				'capability_type'    => 'post',
				'has_archive'        => true,
				'hierarchical'       => false,
				'menu_position'      => null,
				'supports'           => array( 'title', 'excerpt' ),
			);

			register_post_type( 'zmeet_meeting', $args );
		}

		/**
		 * Redirect to Single meeting template
		 *
		 * @param mixed $single Single meeting template.
		 *
		 * @return mixed
		 *
		 * @since 1.0.0
		 */
		public function zmeet_zmeet_template( $single ) {
			global $post;
			if ( 'zmeet_meeting' === $post->post_type ) {

				if ( ! locate_template( 'zmeet-single-meeting.php' ) && file_exists( ZMEET_FRONTEND . '/zmeet-single-meeting.php' ) ) {
					return ZMEET_FRONTEND . '/zmeet-single-meeting.php';
				}
			}
			return $single;
		}

		/**
		 * Flush rewrite rules when a meeting is saved or updated
		 *
		 * @param int $post_id Post ID.
		 */
		public function zmeet_flush_rewrite_rules_on_save( $post_id ) {
			$post_type = get_post_type( $post_id );

			if ( 'zmeet_meeting' === $post_type ) {
				flush_rewrite_rules();
			}
		}
	}
}
