<?php
/**
 * Zmeet_Gutenberg Class
 *
 * This class manages the frontend functionality for the ZooMeet plugin.
 *
 * @package SOVLIX\ZMEET
 */

namespace SOVLIX\ZMEET;

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( ! class_exists( 'Zmeet_Gutenberg' ) ) {
	/**
	 * Zmeet_Gutenberg Class
	 *
	 * Handles frontend-related tasks and functionality for the ZooMeet plugin.
	 *
	 * @since 1.0.0
	 */
	class Zmeet_Gutenberg {

		/**
		 * Zmeet_Gutenberg constructor.
		 *
		 * Initializes the frontend class.
		 */
		public function __construct() {
			add_action( 'enqueue_block_editor_assets', array( $this, 'register_block_assets' ) );
			add_action( 'wp_enqueue_scripts', array( $this, 'enqueue_frontend_assets' ) );
		}

		/**
		 * Register block assets.
		 *
		 * Enqueues block editor script and styles.
		 *
		 * @since 1.0.0
		 */
		public function register_block_assets() {
			// Enqueue block editor script.
			wp_enqueue_script(
				'zmeet-gutenberg-editor',
				ZMEET_ASSETS_PATH . '/dist/block.build.js',
				array( 'wp-blocks', 'wp-components', 'wp-editor' ),
				filemtime( ZMEET_PATH . '/assets/dist/block.build.js' ),
				true
			);

			// Localize script with zoom_users data.
			wp_localize_script(
				'zmeet-gutenberg-editor',
				'zmeetGutenbergData',
				array(
					'zoom_users' => get_option( 'zmeet_zoom_users' ),
					'ajax_url'   => admin_url( 'admin-ajax.php' ),
					'nonce'      => wp_create_nonce( 'zmeet_admin_nonce' ),
				)
			);

			wp_enqueue_style(
				'zmeet-gutenberg-editor-style',
				ZMEET_ASSETS_PATH . '/dist/block.build.css',
				array( 'wp-edit-blocks' ),
				filemtime( ZMEET_PATH . '/assets/dist/block.build.css' ),
				null
			);
		}

		/**
		 * Enqueue frontend assets.
		 *
		 * Enqueues frontend styles.
		 *
		 * @since 1.0.0
		 */
		public function enqueue_frontend_assets() {
			wp_enqueue_style(
				'zmeet-frontend-style',
				ZMEET_ASSETS_PATH . '/dist/block.build.css',
				array(),
				filemtime( ZMEET_PATH . '/assets/dist/block.build.css' )
			);
		}
	}
}
