<?php // phpcs:ignore
/**
 * Zmeet_Admin Class
 *
 * This class defines the administration functionality for the ZooMeet plugin.
 *
 * @package SOVLIX\ZMEET
 */

namespace SOVLIX\ZMEET;

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( ! class_exists( 'Zmeet_Admin' ) ) {
	/**
	 * Zmeet_Admin Class
	 *
	 * Responsible for handling administration-related tasks for the ZooMeet plugin.
	 *
	 * @since 1.0.0
	 */
	class Zmeet_Admin {
		/**
		 * Zmeet_Admin constructor.
		 *
		 * Initializes the admin class.
		 */
		public function __construct() {
			new Admin\Zmeet_Menu();
			new Admin\Zmeet_Notices();

			add_filter( 'plugin_action_links', array( $this, 'zmeet_settings_link' ), 11, 2 );
		}

		/**
		 * Adds a "Settings" link to the plugin actions on the WordPress Plugins page.
		 *
		 * This function is a WordPress filter function that specifically targets the "ZooMeet" plugin.
		 *
		 * @param array  $actions     The existing array of action links for the plugin.
		 * @param string $plugin_file The file path of the plugin being processed.
		 *
		 * @return array The modified array of action links, including the additional "Settings" link if the plugin is "ZooMeet".
		 *
		 * @since 1.2.0
		 */
		public function zmeet_settings_link( $actions, $plugin_file ) {
			if ( 'zmeet/zmeet.php' === $plugin_file ) {
				$settings_link = '<a href="' . admin_url( 'admin.php?page=zmeet-settings' ) . '">' . esc_html__( 'Settings', 'zoomeet' ) . '</a>';
				if ( ! in_array( $settings_link, $actions, true ) ) {
					array_push( $actions, $settings_link );
				}
			}

			return $actions;
		}


	}
}
