<?php // phpcs:ignore
/**
 * Zmeet_API Class
 *
 * This class manages the Zmeet_API functionality for the ZooMeet plugin.
 *
 * @package SOVLIX\ZMEET
 */

namespace SOVLIX\ZMEET;

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( ! class_exists( 'Zmeet_API' ) ) {
	/**
	 * Zmeet_API Class
	 *
	 * Handles Zmeet_API-related tasks and functionality for the ZooMeet plugin.
	 *
	 * @since 1.0.0
	 */
	class Zmeet_API {
		/**
		 * Zmeet_API constructor.
		 *
		 * Initializes the Zmeet_API class.
		 */
		public function __construct() {
			add_action( 'rest_api_init', array( $this, 'register_api' ) );
		}

		/**
		 * Register the Zmeet_API
		 *
		 * Performs tasks related to registering the Zmeet_API for the ZooMeet plugin.
		 *
		 * @return void
		 *
		 * @since 1.0.0
		 */
		public function register_api() {
			$meetings = new API\Zmeet_Meetings();
			$meetings->register_routes();
			$settings = new API\Zmeet_Settings();
			$settings->register_routes();
			$zoom = new API\Zmeet_Zoom();
			$zoom->register_routes();
			$zoom_reports = new API\Zmeet_Zoom_Reports();
			$zoom_reports->register_routes();
		}
	}
}
