<?php
/**
 * ZooMeet jitsi single Template sidebar
 *
 * @package ZooMeet
 */

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

?>


<div class="zmeet-sidebar-col">
	<div class="zmeet-sidebar">
		<div class="zmeet-single-widget zmeet-single-widget-countdown">
			<h4 class="zmeet-widget-title"><?php esc_html_e( 'Time to go', 'zoomeet' ); ?></h4>
			<div class="zmeet-widget-inner">
			<?php if ( ! $meeting_not_created ) { ?>
				<?php if ( ! $meeting_deleted ) { ?>
					<?php if ( 'end' !== $meeting_status ) { ?>
						<?php if ( $is_schedule ) { ?>
							<div class="zmeet_start_time" data-meeting-start-time="<?php echo esc_attr( $next_meeting_time ); ?>" data-meeting-time-offset="<?php echo esc_attr( $gmt_offset_val ); ?>" > </div>
							<?php } else { ?>
								<span class="zmeet-countdown-wrapper">
									<span class="zmeet-countdown-value"><?php 2 === $meeting_type ? esc_html_e( 'Meeting is running', 'zoomeet' ) : esc_html_e( 'Webinar is running', 'zoomeet' ); ?></span>
									<span class="zmeet-countdown-label"><?php 2 === $meeting_type ? esc_html_e( 'The meeting is started and running', 'zoomeet' ) : esc_html_e( 'The webinar is started and running', 'zoomeet' ); ?></span>
								</span>
							<?php } ?>
					<?php } else { ?>
						<span class="zmeet-countdown-wrapper">
							<span class="zmeet-countdown-value"><?php 2 === $meeting_type ? esc_html_e( 'Meeting is finished', 'zoomeet' ) : esc_html_e( 'Webinar is finished', 'zoomeet' ); ?></span>
							<span class="zmeet-countdown-label"><?php 2 === $meeting_type ? esc_html_e( 'This meeting has been ended by the host.', 'zoomeet' ) : esc_html_e( 'This webinar has been ended by the host.', 'zoomeet' ); ?></span>
						</span>
					<?php } ?>

				<?php } else { ?>
					<span class="zmeet-countdown-wrapper">
						<span class="zmeet-countdown-value"><?php 2 === $meeting_type ? esc_html_e( 'Meeting does not exist', 'zoomeet' ) : esc_html_e( 'Webinar does not exist', 'zoomeet' ); ?></span>
						<span class="zmeet-countdown-label"><?php 2 === $meeting_type ? esc_html_e( 'The meeting is not exists in zoom account.', 'zoomeet' ) : esc_html_e( 'The webinar is not exists in zoom account.', 'zoomeet' ); ?></span>
					</span>
				<?php } ?>
			<?php } else { ?>
				<?php if ( current_user_can( 'manage_options' ) ) { ?>
					<span class="zmeet-countdown-wrapper">
						<span class="zmeet-countdown-value"><?php 2 === $meeting_type ? esc_html_e( 'Meeting not created', 'zoomeet' ) : esc_html_e( 'Webinar not created', 'zoomeet' ); ?></span>
						<span class="zmeet-countdown-label"><?php esc_html_e( 'You have to setup zoom credentils first from settings.', 'zoomeet' ); ?></span>
					</span>
				<?php } else { ?>
					<span class="zmeet-countdown-wrapper">
						<span class="zmeet-countdown-value"><?php 2 === $meeting_type ? esc_html_e( 'Meeting does not exist', 'zoomeet' ) : esc_html_e( 'Webinar does not exist', 'zoomeet' ); ?></span>
						<span class="zmeet-countdown-label"><?php 2 === $meeting_type ? esc_html_e( 'The meeting is not exists in zoom account.', 'zoomeet' ) : esc_html_e( 'The webinar is not exists in zoom account.', 'zoomeet' ); ?></span>
					</span>
				<?php } ?>
			<?php } ?>
			</div>
		</div>

		<?php if ( ! $meeting_not_created ) { ?>
			<?php if ( ! $meeting_deleted ) { ?>
				<?php if ( current_user_can( 'manage_options' ) || current_user_can( 'tutor_instructor' ) ) { ?>
					<div class="zmeet-single-widget zmeet-single-widget-host-actions">
						<div class="zmeet-widget-inner">
							<?php if ( 'end' !== $meeting_status ) { ?>
							<button  class="zmeet-meeting-status" data-meeting-status="end" data-post-id="<?php echo esc_attr( $post->ID ); ?>" data-meeting-id="<?php echo esc_attr( $meeting_id ); ?>"><?php 2 === $meeting_type ? esc_html_e( 'End Meeting ?', 'zoomeet' ) : esc_html_e( 'End Webinar ?', 'zoomeet' ); ?>
							</button>
						<?php } else { ?>
							<button  class="zmeet-meeting-status" data-meeting-status="resume" data-post-id="<?php echo esc_attr( $post->ID ); ?>" data-meeting-id="<?php echo esc_attr( $meeting_id ); ?>"><?php 2 === $meeting_type ? esc_html_e( 'Enable Meeting Join ?', 'zoomeet' ) : esc_html_e( 'Enable Webinar Join ?', 'zoomeet' ); ?>
							</button>
						<?php } ?>
							<p><?php 2 === $meeting_type ? esc_html_e( 'You are seeing this because you are the author of this meeting', 'zoomeet' ) : esc_html_e( 'You are seeing this because you are the author of this webinar', 'zoomeet' ); ?></p>
						</div>
					</div>
				<?php } ?>
			<?php } ?>
		<?php } ?>

		<div class="zmeet-single-widget zmeet-single-widget-detail">
			<h4 class="zmeet-widget-title"><?php esc_html_e( 'Details', 'zoomeet' ); ?></h4>
			<div class="zmeet-widget-inner">
				<dl>
					<dt><?php esc_html_e( 'Topic:', 'zoomeet' ); ?></dt>
					<dd><?php echo esc_html( the_title() ); ?></dd>
					<dt><?php esc_html_e( 'Hosted By:', 'zoomeet' ); ?></dt>
					<dd>
					<?php
						$author_id   = get_post_field( 'post_author', $post->ID );
						$author_name = get_the_author_meta( 'display_name', $author_id );
						echo esc_html( $author_name );
					?>
					</dd>

					<?php if ( ! $options['enable_recurring_meeting'] ) { ?>
						<dt><?php esc_html_e( 'Start Time:', 'zoomeet' ); ?></dt>
						<dd class="mhbu-tm">
						<?php

						echo esc_html( gmdate( 'l, F j, Y g:i A', strtotime( $start_time ) ) );

						?>
						</dd>

					<?php } ?>

					<?php if ( $options['enable_recurring_meeting'] && ! empty( $zoom_response->occurrences ) ) { ?>
						<dt><?php 2 === $meeting_type ? esc_html_e( 'Recurring Meeting schedule:', 'zoomeet' ) : esc_html_e( 'Recurring Webinar schedule:', 'zoomeet' ); ?></dt>
						<dd style="margin-bottom:0;"> 
							<?php esc_html_e( 'From:', 'zoomeet' ); ?> 
							<span class="muhb-st"> <?php echo esc_html( gmdate( 'd M Y', strtotime( $next_meeting_time ) ) ); ?></span>
						</dd>
						<dd> 
							<?php esc_html_e( 'To:', 'zoomeet' ); ?> 
							<span class="muhb-et"> <?php echo esc_html( $recurring_end_date ); ?></span>
						</dd>

						<dt><?php 2 === $meeting_type ? esc_html_e( 'Meeting recurrence:', 'zoomeet' ) : esc_html_e( 'Webinar recurrence:', 'zoomeet' ); ?></dt>
						<dd> <?php esc_html_e( 'Every', 'zoomeet' ); ?> <?php echo esc_html( $recurring_repeat_interval ); ?> <span class="zmeet_reday"> <?php echo esc_html( $recurring_repeat_name ); ?> </span> <?php esc_html_e( 'at', 'zoomeet' ); ?> <span class="zmeet_retime"> <?php echo esc_html( gmdate( 'H:i', strtotime( $next_meeting_time ) ) ); ?>  </span></dd>

						<dt><?php esc_html_e( 'Next Start Time:', 'zoomeet' ); ?></dt>
						<dd class="mhbu-tm">
							<?php

							echo esc_html( gmdate( 'l, F j, Y g:i A', strtotime( $next_meeting_time ) ) );

							?>
						</dd>


						<dt><?php esc_html_e( 'Duration:', 'zoomeet' ); ?></dt>
						<dd class="zmeet-duration">
						<?php
						if ( 60 <= $recurring_duration ) {
							$hours   = floor( $recurring_duration / 60 );
							$minutes = $recurring_duration % 60;

							// Get the correct translation for "hour" or "hours".
							$hour_text = ( 1 == $hours ) ? __( 'hour', 'zoomeet' ) : __( 'hours', 'zoomeet' );
							$minute_text = ( 1 == $minutes ) ? __( 'minute', 'zoomeet' ) : __( 'minutes', 'zoomeet' );

							// Print hours.
							echo esc_html( number_format_i18n( $hours ) ) . ' ' . esc_html( $hour_text );

							// Print minutes if greater than 0.
							if ( $minutes > 0 ) {
								echo ' ' . esc_html( number_format_i18n( $minutes ) ) . ' ' . esc_html( $minute_text );
							}
						} else {
							// Get the correct translation for "minute" or "minutes".
							$minute_text = ( 1 == $recurring_duration ) ? __( 'minute', 'zoomeet' ) : __( 'minutes', 'zoomeet' );

							// Print minutes only.
							echo esc_html( number_format_i18n( $recurring_duration ) ) . ' ' . esc_html( $minute_text );
						}
						?>

						</dd>

					<?php } ?>

					<?php if ( ! $options['enable_recurring_meeting'] ) { ?>
						<dt><?php esc_html_e( 'Duration:', 'zoomeet' ); ?></dt>
						<dd class="zmeet-duration">
						<?php
						if ( 60 <= $meeting_duration ) {
							$hours   = floor( $meeting_duration / 60 );
							$minutes = $meeting_duration % 60;

							// Get the correct translation for "hour" or "hours".
							$hour_text   = ( 1 == $hours ) ? __( 'hour', 'zoomeet' ) : __( 'hours', 'zoomeet' );
							$minute_text = ( 1 == $minutes ) ? __( 'minute', 'zoomeet' ) : __( 'minutes', 'zoomeet' );

							// Print hours.
							echo esc_html( number_format_i18n( $hours ) ) . ' ' . esc_html( $hour_text );

							// Print minutes if greater than 0.
							if ( $minutes > 0 ) {
								echo ' ' . esc_html( number_format_i18n( $minutes ) ) . ' ' . esc_html( $minute_text );
							}
						} else {
							// Get the correct translation for "minute" or "minutes".
							$minute_text = ( 1 == $meeting_duration ) ? __( 'minute', 'zoomeet' ) : __( 'minutes', 'zoomeet' );

							// Print minutes only.
							echo esc_html( number_format_i18n( $meeting_duration ) ) . ' ' . esc_html( $minute_text );
						}
						?>
						</dd>
					<?php } ?>

					<dt><?php esc_html_e( 'Current Timezone:', 'zoomeet' ); ?></dt>
					<dd class="zmeet-tz">
					<?php
						echo esc_html( $time_zone );
					?>
					</dd>
					
				</dl>
			</div>
		</div>

		<?php
		if ( zoo_fs()->can_use_premium_code__premium_only() && ! empty( $integration_settings ) && ! empty( $integration_settings['google_calendar'] ) ) {
			require_once ZMEET_PRO_INCLUDES . '/Templates/zmeet-calander.php';
		}
		?>

		<div class="zmeet-buy-btn-wpapper">
			<?php
			if ( ! empty( $product_id ) && 'yes' === $meeting_as_product && ! current_user_can( 'manage_options' ) ) {
				$product_link = get_permalink( $product_id );
				?>
				<a href="<?php echo esc_url( $product_link ); ?>" class="zmeet-buy-button" target="__blank"> <?php esc_html_e( 'Buy Now !', 'zoomeet' ); ?></a>
			
			<?php } ?>
		</div>
	</div>
</div>
