<?php
/**
 * Template Name: ZooMeet Template
 *
 * This template is used to display the ZooMeet content.
 *
 * @package Zmeet
 * @since 1.0.0
 */

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

$serialize_options    = get_post_meta( get_the_ID(), 'zmeet__meeting_settings', true );
$meeting_description  = get_post_meta( get_the_ID(), 'meeting_description', true );
$integration_settings = get_option( 'zmeet_integration_settings', true );
$options              = maybe_unserialize( $serialize_options );
$hide_header_footer   = $options['hide_header_footer'];
$thumbnail_html       = get_the_post_thumbnail( get_the_ID() );
$is_header            = true;

$display_meeting = filter_input( INPUT_GET, 'display_meeting' );
$is_zoom_meeting = ! empty( $display_meeting );

// Remove header and footer if needed.
if ( ! $hide_header_footer && ! $is_zoom_meeting ) {
	if ( file_exists( get_template_directory() . '/header.php' ) ) {
		get_header();
	} else {
		wp_head();
	}
} else {
	wp_head();
}


// User name.
$user_id           = get_current_user_id();
$current_user_data = get_userdata( $user_id );
$current_user_name = $current_user_data ? $current_user_data->display_name : '';

$meeting_status       = get_post_meta( get_the_ID(), 'zmeet_meeting_status', true );
$meeting_start_status = get_post_meta( get_the_ID(), 'zmeet_meeting_start_status', true );
$hide_sidebar         = $options['hide_sidebar'];
$time_zone            = $options['meeting_timezone'];

$gmt_array       = zmeet_get_gmt_offset( $options['meeting_timezone'] );
$gmt_offset_val  = $gmt_array['gmt_offset_val'];
$gmt_offset      = $gmt_array['gmt_offset'];
$should_register = false;
$attendee_login  = false;
$login_status;
$meeting_as_product;
$product_id;
$po_meeting_id = $post->ID;

$meeting_title = get_the_title();

if ( zoo_fs()->can_use_premium_code__premium_only() ) {
	$cookie_key   = "zmeet_login_status_{$po_meeting_id}";
	$login_status = isset( $_COOKIE[ $cookie_key ] ) ? sanitize_text_field( wp_unslash( $_COOKIE[ $cookie_key ] ) ) : '';

	$meeting_as_product = get_post_meta( get_the_ID(), 'zmeet_connect_as_product', true );
	$product_id         = get_post_meta( get_the_ID(), 'zmeet_connect_product_id', true );
	$should_register    = isset( $options['enable_should_register'] ) ? $options['enable_should_register'] : false;
}

if ( ! empty( $display_meeting ) ) {
	include_once ZMEET_INCLUDES . '/Templates/zmeet-zoom-web-single-meting.php';
} else {
	require_once ZMEET_INCLUDES . '/Templates/zmeet-zoom-single-meting.php';
}

// Add footer only if not hidden.
if ( ! $hide_header_footer && ! $is_zoom_meeting ) {
	if ( file_exists( get_template_directory() . '/footer.php' ) ) {
		get_footer();
	} else {
		wp_footer();
	}
} else {
	wp_footer();
}
