<?php
/**
 * ZooMeet Elementor Integrator
 * Integrates ZooMeet widgets with Elementor.
 *
 * @package ZooMeet
 */

namespace SOVLIX\ZMEET\Elementor;

use Elementor\Elements_Manager;

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( ! class_exists( 'Zmeet_Elementor_Integrator' ) ) {
	/**
	 * Class Zmeet_Elementor_Integrator
	 * Integrates ZooMeet widgets with Elementor.
	 */
	class Zmeet_Elementor_Integrator {
		/**
		 * Class constructor.
		 *
		 * Hooks into the 'plugins_loaded' action to initiate the plugin.
		 */
		public function __construct() {
			add_action( 'elementor/elements/categories_registered', array( $this, 'add_elementor_widget_categories' ), 10 );
			add_action( 'elementor/widgets/register', array( $this, 'register_oembed_widget' ) );
		}

		/**
		 * Add custom category for ZooMeet widgets.
		 *
		 * @param \Elementor\Elements_Manager $elements_manager Elementor elements manager.
		 * @return void
		 */
		public function add_elementor_widget_categories( $elements_manager ) {
			$elements_manager->add_category(
				'zmeet-category',
				array(
					'title' => __( 'ZooMeet Widgets', 'zoomeet' ),
					'icon'  => 'fa fa-plug',
				)
			);
		}

		/**
		 * Register oEmbed Widget.
		 *
		 * Include widget file and register widget class.
		 *
		 * @since 1.0.0
		 * @param \Elementor\Widgets_Manager $widgets_manager Elementor widgets manager.
		 * @return void
		 */
		public function register_oembed_widget( $widgets_manager ) {
			$widgets_manager->register( new Widgets\Zmeet_Zoom_Direct_MW() );
		}
	}
}
