<?php
/**
 * Zmeet_Notices Class
 *
 * Handles admin notices for the ZooMeet plugin.
 *
 * @package SOVLIX\ZMEET\Admin
 */

namespace SOVLIX\ZMEET\Admin;

/**
 * Class Zmeet_Notices
 *
 * Responsible for displaying and managing admin notices.
 */
class Zmeet_Notices {

	/**
	 * Zmeet_Notices constructor.
	 */
	public function __construct() {
		add_action( 'admin_notices', array( $this, 'display_admin_notices' ) );
	}

	/**
	 * Display admin notices based on settings and requirements.
	 */
	public function display_admin_notices() {
		// notices are now handled in React
	}

	/**
	 * Display Zoom SDK notice.
	 */
	public function display_sdk_notice() {
		?>
		<div class="notice notice-warning is-dismissible">
			<p>
				<?php esc_html_e( 'Please configure the Zoom Meeting SDK to enable additional Zoom Client functionalities and ensure "Join In Browser" functionality works correctly. ', 'zoomeet' ); ?>
				<a href="<?php echo esc_url( admin_url( 'admin.php?page=zmeet-settings' ) ); ?>" ><?php esc_html_e( 'Configure Zoom SDK Settings', 'zoomeet' ); ?></a>
			</p>
		</div>
		<?php
	}

	/**
	 * Display Server to Server OAuth notice.
	 */
	public function display_auth_notice() {
		?>
		<div class="notice notice-warning is-dismissible">
			<p>
				<?php esc_html_e( 'Please configure Server to Server OAuth Credentials to enable the creation of Zoom meetings and webinars.', 'zoomeet' ); ?>
				<a href="<?php echo esc_url( admin_url( 'admin.php?page=zmeet-settings' ) ); ?>"><?php esc_html_e( 'Configure OAuth Credentials', 'zoomeet' ); ?></a>
			</p>
		</div>
		<?php
	}

	/**
	 * Display Zoom connect notice.
	 */
	public function display_zoom_connect_notice() {
		?>
		<div class="notice notice-info is-dismissible">
			<p>
				<?php esc_html_e( 'Zoom OAuth credentials are configured. Please ensure your token is active to create meetings. ', 'zoomeet' ); ?>
				<a href="<?php echo esc_url( admin_url( 'admin.php?page=zmeet-settings' ) ); ?>"><?php esc_html_e( 'Check Zoom Connection', 'zoomeet' ); ?></a>
			</p>
		</div>
		<?php
	}

	/**
	 * Display Google Meet auth notice.
	 */
	public function display_google_meet_auth_notice() {
		?>
		<div class="notice notice-warning is-dismissible">
			<p>
				<?php esc_html_e( 'Please upload the Google Meet credential JSON file to enable Google Meet meetings. ', 'zoomeet' ); ?>
				<a href="<?php echo esc_url( admin_url( 'admin.php?page=zmeet-settings' ) ); ?>"><?php esc_html_e( 'Configure Google Meet Settings', 'zoomeet' ); ?></a>
			</p>
		</div>
		<?php
	}

	/**
	 * Display Google Meet connect notice.
	 */
	public function display_google_meet_connect_notice() {
		?>
		<div class="notice notice-info is-dismissible">
			<p>
				<?php esc_html_e( 'Google Meet credentials are loaded. Please permit your account to start creating meetings. ', 'zoomeet' ); ?>
				<a href="<?php echo esc_url( admin_url( 'admin.php?page=zmeet-settings' ) ); ?>"><?php esc_html_e( 'Connect Google Meet Account', 'zoomeet' ); ?></a>
			</p>
		</div>
		<?php
	}
}
