<?php //phpcs:ignore
/**
 * File: Zmeet_Menu.php
 *
 * The Zmeet_Menu class defines the admin menu for the ZooMeet plugin,
 * including settings and sections, with proper sanitation and rendering.
 *
 * @package SOVLIX\ZMEET
 * @since   1.0.0
 */

namespace SOVLIX\ZMEET\Admin;

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( ! class_exists( 'Zmeet_Menu' ) ) {
	/**
	 * Zmeet_Menu
	 *
	 * Admin Zmeet_Menu class for the ZooMeet plugin.
	 *
	 * @since 1.0.0
	 */
	class Zmeet_Menu {

		/**
		 * Zmeet_Menu constructor.
		 * Initializes the admin menu by adding action hooks.
		 */
		public function __construct() {
			add_action( 'admin_menu', array( $this, 'add_zmeet_admin_menu' ) );
		}

		/**
		 * Add ZooMeet menu to the admin section.
		 */
		public function add_zmeet_admin_menu() {
			$parent_slug = 'zmeet';

			add_menu_page(
				__( 'ZooMeet', 'zoomeet' ),
				__( 'ZooMeet', 'zoomeet' ),
				'manage_options',
				$parent_slug,
				array( $this, 'zmeet_page_content' ),
				//phpcs:ignore
				'data:image/svg+xml;base64,' . base64_encode(
					'<svg width="105" height="96" viewBox="0 0 105 96" fill="none" xmlns="http://www.w3.org/2000/svg">
						<g filter="url(#filter0_d_573_76)">
						<path d="M19.464 33.188C19.576 33.188 19.688 33.188 19.804 33.188C20.179 33.188 20.553 33.188 20.928 33.189C21.197 33.189 21.466 33.189 21.735 33.189C22.314 33.189 22.893 33.189 23.472 33.189C24.309 33.19 25.145 33.191 25.982 33.191C27.34 33.191 28.698 33.192 30.056 33.192C31.374 33.193 32.693 33.194 34.012 33.195C34.093 33.195 34.174 33.195 34.258 33.195C34.666 33.195 35.074 33.195 35.482 33.195C38.865 33.196 42.248 33.198 45.631 33.2C45.748 33.433 45.746 33.574 45.75 33.833C45.752 33.923 45.754 34.013 45.755 34.106C45.757 34.253 45.757 34.253 45.76 34.403C45.761 34.505 45.763 34.606 45.765 34.711C45.771 35.039 45.776 35.366 45.781 35.694C45.809 37.482 45.809 37.482 45.878 39.27C45.882 39.346 45.885 39.422 45.889 39.5C45.915 39.978 45.974 40.435 46.091 40.899C46.139 41.136 46.134 41.359 46.131 41.6C46.045 41.6 46.045 41.6 45.957 41.601C42.552 41.611 39.146 41.622 35.741 41.633C35.333 41.635 34.924 41.636 34.516 41.637C34.434 41.638 34.353 41.638 34.269 41.638C32.951 41.642 31.632 41.647 30.314 41.65C28.962 41.655 27.61 41.659 26.258 41.664C25.424 41.667 24.589 41.669 23.754 41.672C23.182 41.673 22.611 41.675 22.039 41.677C21.709 41.679 21.378 41.68 21.048 41.68C20.691 41.681 20.333 41.683 19.976 41.684C19.818 41.684 19.818 41.684 19.656 41.685C19.514 41.685 19.514 41.685 19.368 41.686C19.286 41.686 19.203 41.687 19.118 41.687C18.93 41.68 18.93 41.68 18.831 41.8C18.822 42.019 18.819 42.238 18.819 42.457C18.819 42.562 18.819 42.562 18.819 42.669C18.818 42.906 18.819 43.143 18.819 43.38C18.819 43.55 18.819 43.721 18.819 43.891C18.819 44.362 18.819 44.833 18.82 45.303C18.82 45.81 18.82 46.317 18.82 46.823C18.82 47.702 18.82 48.581 18.821 49.459C18.822 50.73 18.822 52 18.822 53.27C18.822 55.331 18.823 57.392 18.824 59.453C18.825 61.455 18.825 63.458 18.826 65.46C18.826 65.584 18.826 65.707 18.826 65.834C18.826 66.453 18.826 67.071 18.826 67.69C18.827 72.827 18.829 77.963 18.831 83.1C24.969 83.15 24.969 83.15 31.231 83.2C31.231 82.507 31.231 81.814 31.231 81.1C31.63 78.001 33.149 75.089 35.644 73.15C37.059 72.132 38.596 71.393 40.288 70.981C40.356 70.965 40.425 70.948 40.495 70.931C41.418 70.718 42.341 70.685 43.284 70.685C43.45 70.685 43.45 70.685 43.62 70.684C43.983 70.684 44.347 70.683 44.71 70.683C44.965 70.683 45.22 70.683 45.475 70.682C46.008 70.682 46.542 70.681 47.075 70.681C47.687 70.682 48.3 70.681 48.912 70.679C49.506 70.677 50.1 70.677 50.693 70.677C50.944 70.677 51.194 70.677 51.445 70.676C53.276 70.671 54.976 70.716 56.731 71.3C56.837 71.335 56.943 71.37 57.051 71.405C59.883 72.416 62.176 74.563 63.464 77.275C64.33 79.201 64.534 80.959 64.631 83.1C71.462 83.133 78.293 83.166 85.331 83.2C85.326 80.954 85.32 78.707 85.314 76.393C85.311 74.973 85.309 73.553 85.307 72.134C85.306 71.388 85.305 70.643 85.304 69.897C85.304 69.804 85.304 69.711 85.304 69.614C85.301 68.105 85.297 66.596 85.293 65.086C85.288 63.538 85.285 61.989 85.284 60.441C85.284 59.485 85.281 58.529 85.277 57.573C85.275 56.918 85.274 56.263 85.275 55.608C85.275 55.23 85.274 54.852 85.272 54.474C85.269 54.064 85.27 53.654 85.271 53.245C85.27 53.125 85.268 53.005 85.267 52.881C85.275 51.987 85.275 51.987 85.571 51.679C85.814 51.512 86.001 51.409 86.283 51.33C86.411 51.292 86.411 51.292 86.541 51.253C86.63 51.227 86.72 51.202 86.813 51.175C88.195 50.745 89.344 50.088 90.476 49.195C90.971 48.817 90.971 48.817 91.231 48.7C91.586 48.811 91.867 48.977 92.167 49.193C92.246 49.25 92.324 49.307 92.405 49.365C92.527 49.454 92.527 49.454 92.65 49.544C92.773 49.632 92.773 49.632 92.898 49.721C93.506 50.162 93.506 50.162 93.731 50.5C93.757 50.746 93.757 50.746 93.758 51.046C93.758 51.16 93.759 51.274 93.76 51.392C93.76 51.518 93.759 51.644 93.759 51.774C93.76 51.908 93.76 52.043 93.761 52.178C93.763 52.549 93.763 52.92 93.763 53.291C93.763 53.691 93.765 54.091 93.766 54.49C93.769 55.183 93.77 55.876 93.771 56.569C93.773 57.571 93.775 58.573 93.778 59.575C93.782 61.2 93.786 62.826 93.789 64.451C93.792 66.03 93.796 67.609 93.8 69.188C93.8 69.286 93.8 69.383 93.8 69.483C93.802 69.971 93.803 70.459 93.804 70.947C93.814 74.998 93.823 79.049 93.831 83.1C93.886 83.101 93.941 83.102 93.997 83.102C94.568 83.111 95.139 83.121 95.71 83.132C95.923 83.136 96.136 83.139 96.348 83.142C96.655 83.147 96.962 83.153 97.269 83.159C97.363 83.16 97.457 83.161 97.555 83.162C98.761 83.189 99.916 83.55 100.826 84.364C101.687 85.327 102.115 86.408 102.09 87.703C102.023 88.847 101.616 89.753 100.813 90.565C99.661 91.526 98.421 91.63 96.987 91.626C96.828 91.626 96.67 91.626 96.511 91.627C96.074 91.628 95.636 91.627 95.199 91.627C94.724 91.627 94.249 91.627 93.773 91.628C92.94 91.629 92.106 91.629 91.273 91.629C90.034 91.629 88.794 91.63 87.555 91.631C85.213 91.633 82.871 91.633 80.529 91.633C78.721 91.634 76.912 91.634 75.104 91.635C74.583 91.635 74.063 91.635 73.543 91.635C73.413 91.635 73.284 91.635 73.151 91.635C69.512 91.636 65.873 91.637 62.234 91.637C62.096 91.637 61.957 91.637 61.818 91.637C61.192 91.637 60.567 91.637 59.941 91.637C59.662 91.637 59.383 91.637 59.104 91.637C58.964 91.637 58.824 91.637 58.684 91.637C54.268 91.637 49.851 91.638 45.434 91.641C44.321 91.642 43.208 91.643 42.096 91.643C41.993 91.643 41.993 91.643 41.888 91.643C39.776 91.645 37.664 91.645 35.552 91.646C35.452 91.646 35.452 91.646 35.351 91.646C33.83 91.646 32.309 91.646 30.787 91.646C30.267 91.646 29.747 91.646 29.226 91.646C29.034 91.646 29.034 91.646 28.838 91.646C26.774 91.646 24.711 91.647 22.647 91.649C20.574 91.65 18.5 91.651 16.427 91.649C15.195 91.649 13.962 91.649 12.73 91.651C11.907 91.652 11.084 91.652 10.261 91.65C9.792 91.65 9.324 91.649 8.855 91.651C8.428 91.653 8.001 91.652 7.574 91.65C7.42 91.65 7.267 91.65 7.114 91.651C5.706 91.661 4.448 91.409 3.331 90.5C2.503 89.671 2.027 88.667 2 87.494C2.011 86.442 2.4 85.625 3.031 84.8C3.104 84.701 3.177 84.602 3.252 84.5C3.55 84.147 3.899 83.969 4.313 83.775C4.38 83.741 4.447 83.707 4.517 83.673C5.333 83.276 6.074 83.17 6.972 83.18C7.117 83.181 7.117 83.181 7.265 83.181C7.57 83.182 7.876 83.185 8.181 83.188C8.39 83.189 8.598 83.189 8.806 83.19C9.315 83.192 9.823 83.196 10.331 83.2C10.331 83.067 10.331 83.067 10.331 82.932C10.327 77.691 10.323 72.45 10.321 67.21C10.321 66.58 10.321 65.951 10.32 65.322C10.32 65.196 10.32 65.071 10.32 64.942C10.319 62.914 10.318 60.885 10.316 58.857C10.314 56.775 10.313 54.694 10.313 52.612C10.312 51.328 10.311 50.044 10.31 48.76C10.309 47.879 10.308 46.998 10.309 46.117C10.309 45.609 10.309 45.101 10.308 44.593C10.307 44.127 10.307 43.662 10.307 43.196C10.307 43.028 10.307 42.86 10.306 42.692C10.297 39.963 11.051 37.58 12.95 35.569C14.737 33.89 17.061 33.181 19.464 33.188Z" fill="white"/>
						</g>
						<g filter="url(#filter1_d_573_76)">
						<path d="M53.0324 51.6C54.6104 52.91 55.7474 54.779 56.1324 56.8C56.1754 57.292 56.1804 57.781 56.1764 58.275C56.1754 58.341 56.1754 58.408 56.1754 58.476C56.1574 60.834 55.2774 62.787 53.6054 64.441C52.5124 65.474 51.2704 66.015 49.8324 66.4C49.7424 66.427 49.7424 66.427 49.6514 66.454C48.1464 66.771 46.2214 66.634 44.8324 66C44.7654 65.971 44.6994 65.942 44.6304 65.912C43.6864 65.499 42.8934 65.004 42.1324 64.3C42.0464 64.224 41.9604 64.148 41.8714 64.07C40.4914 62.79 39.5904 60.739 39.5114 58.862C39.4484 56.556 40.2164 54.34 41.7484 52.591C44.7634 49.417 49.5094 49.038 53.0324 51.6Z" fill="white"/>
						</g>
						<g filter="url(#filter2_d_573_76)">
						<path d="M83.3675 0H64.8982C57.5835 0 51.6328 5.95071 51.6328 13.2654V31.7346C51.6328 39.0493 57.5835 45 64.8982 45H83.3675C90.6821 45 96.6328 39.0493 96.6328 31.7346V13.2654C96.6328 5.95071 90.6821 0 83.3675 0ZM79.49 28.2707C79.49 29.2264 78.7164 30 77.7607 30H63.4239C61.0539 30 59.1328 28.0789 59.1328 25.7089V15.6568C59.1328 14.7021 59.9064 13.9286 60.8621 13.9286H75.2C77.5689 13.9286 79.49 15.8496 79.49 18.2196V28.2707ZM89.1328 28.0671C89.1328 28.9082 88.2071 29.4214 87.4935 28.9757L82.1364 25.6275C81.8235 25.4314 81.6328 25.0886 81.6328 24.7189V19.2107C81.6328 18.8411 81.8235 18.4982 82.1364 18.3021L87.4935 14.9539C88.2071 14.5071 89.1328 15.0204 89.1328 15.8614V28.0671Z" fill="white"/>
						</g>
						<defs>
						<filter id="filter0_d_573_76" x="0" y="33.188" width="104.092" height="62.4641" filterUnits="userSpaceOnUse" color-interpolation-filters="sRGB">
						<feFlood flood-opacity="0" result="BackgroundImageFix"/>
						<feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0" result="hardAlpha"/>
						<feOffset dy="2"/>
						<feGaussianBlur stdDeviation="1"/>
						<feComposite in2="hardAlpha" operator="out"/>
						<feColorMatrix type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.25 0"/>
						<feBlend mode="normal" in2="BackgroundImageFix" result="effect1_dropShadow_573_76"/>
						<feBlend mode="normal" in="SourceGraphic" in2="effect1_dropShadow_573_76" result="shape"/>
						</filter>
						<filter id="filter1_d_573_76" x="37.5078" y="49.9138" width="20.6699" height="20.7043" filterUnits="userSpaceOnUse" color-interpolation-filters="sRGB">
						<feFlood flood-opacity="0" result="BackgroundImageFix"/>
						<feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0" result="hardAlpha"/>
						<feOffset dy="2"/>
						<feGaussianBlur stdDeviation="1"/>
						<feComposite in2="hardAlpha" operator="out"/>
						<feColorMatrix type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.25 0"/>
						<feBlend mode="normal" in2="BackgroundImageFix" result="effect1_dropShadow_573_76"/>
						<feBlend mode="normal" in="SourceGraphic" in2="effect1_dropShadow_573_76" result="shape"/>
						</filter>
						<filter id="filter2_d_573_76" x="49.6328" y="0" width="49" height="49" filterUnits="userSpaceOnUse" color-interpolation-filters="sRGB">
						<feFlood flood-opacity="0" result="BackgroundImageFix"/>
						<feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0" result="hardAlpha"/>
						<feOffset dy="2"/>
						<feGaussianBlur stdDeviation="1"/>
						<feComposite in2="hardAlpha" operator="out"/>
						<feColorMatrix type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.25 0"/>
						<feBlend mode="normal" in2="BackgroundImageFix" result="effect1_dropShadow_573_76"/>
						<feBlend mode="normal" in="SourceGraphic" in2="effect1_dropShadow_573_76" result="shape"/>
						</filter>
						</defs>
					</svg>'
				),
				40
			);

			// Add All Meetings Submenu.
			add_submenu_page(
				$parent_slug,
				__( 'All Meetings', 'zoomeet' ),
				__( 'All Meetings', 'zoomeet' ),
				'manage_options',
				$parent_slug,
				array( $this, 'zmeet_page_content' )
			);

			// Add Settings Submenu.
			add_submenu_page(
				$parent_slug,
				__( 'Settings', 'zoomeet' ),
				__( 'Settings', 'zoomeet' ),
				'manage_options',
				'zmeet-settings',
				array( $this, 'settings_page_content' )
			);

			add_submenu_page(
				$parent_slug,
				__( 'Add-ons', 'zoomeet' ),
				__( 'Add-ons', 'zoomeet' ),
				'manage_options',
				'zmeet-addons',
				array( $this, 'addon_page_content' )
			);

			add_submenu_page(
				$parent_slug,
				__( 'Integrations', 'zoomeet' ),
				__( 'Integrations', 'zoomeet' ),
				'manage_options',
				'zmeet-integrations',
				array( $this, 'integrations_page_content' )
			);

			$oauth_data          = get_option( 'zmeet_zoom_global_oauth_data' );
			$server_auth_prepare = zmeet_is_server_auth_prepare();

			if ( ! empty( $oauth_data ) && $server_auth_prepare ) {
				// Add User Submenu.
				add_submenu_page(
					$parent_slug,
					__( 'Zoom Users', 'zoomeet' ),
					__( 'Zoom Users', 'zoomeet' ),
					'manage_options',
					'zmeet-zoom-users',
					array( $this, 'zoom_users_page_content' )
				);

				// Zoom Reports Submenu.
				add_submenu_page(
					$parent_slug,
					__( 'Zoom Reports', 'zoomeet' ),
					__( 'Zoom Reports', 'zoomeet' ),
					'manage_options',
					'zmeet-zoom-reports',
					array( $this, 'zoom_reports_page_content' )
				);

				// Zoom Recordings Submenu.
				add_submenu_page(
					$parent_slug,
					__( 'Zoom Recordings', 'zoomeet' ),
					__( 'Zoom Recordings', 'zoomeet' ),
					'manage_options',
					'zmeet-zoom-recordings',
					array( $this, 'zoom_recordings_page_content' )
				);

			}
		}


		/**
		 * Render the ZooMeet page content.
		 */
		public function zmeet_page_content() {
			?>
				<div id="zmeet_admin_dasboard" class="zmeet-admin-dasboard-bg">
				</div>
			<?php
		}

		/**
		 * Render the Settings page content.
		 */
		public function settings_page_content() {
			?>
				<div id="zmeet_admin_settings" class="zmeet-admin-dasboard-bg">
				</div>
			<?php
		}


		/**
		 * Render the Addon page content.
		 */
		public function addon_page_content() {
			?>
				<div id="zmeet_addons" class="zmeet-admin-dasboard-bg">
				</div>
			<?php
		}

		/**
		 * Render the Integrations page content.
		 */
		public function integrations_page_content() {
			?>
				<div id="zmeet_integrations" class="zmeet-admin-dasboard-bg">
				</div>
			<?php
		}

		/**
		 * Render the zoom users page content.
		 */
		public function zoom_users_page_content() {
			?>
				<div id="zmeet_zoom_users" class="zmeet-admin-dasboard-bg">
				</div>
			<?php
		}

		/**
		 * Render the zoom reports page content.
		 */
		public function zoom_reports_page_content() {
			?>
				<div id="zmeet_zoom_reports" class="zmeet-admin-dasboard-bg">
				</div>
			<?php
		}

		/**
		 * Render the zoom recordings page content.
		 */
		public function zoom_recordings_page_content() {
			?>
				<div id="zmeet_zoom_recordings" class="zmeet-admin-dasboard-bg">
				</div>
			<?php
		}
	}
}


