// ConnectTab.js
import React, { useState } from 'react';
import '../../../scss/settings/connect-tab.scss';
import Spinner from '../../common/Spinner';
import PassInputField from '../common-fields/PassInputField';
const { __ } = wp.i18n;
import { toast } from 'react-toastify';
import { langString } from '../../../Helpers';

const ConnectTab = ({ formData, setFormData, savedCredentials = {} }) => {

  const { oauth_account_id, oauth_client_id, oauth_client_secret, sdk_client_id, sdk_client_secret } = formData;
  const [renewText, setRenewText] = useState( langString('renew_oauth_token') );

  const handleInputChange = (field, value) => {
    setFormData(prevState => ({
      ...prevState,
      [field]: value
    }));
  };

  const handleRenewOAuth = async () => {
    setRenewText( langString('renewing') );
  
    try {
      const response = await fetch(zmeetMeetingsData.ajax_url, {
        method: 'POST',
        headers: {
          'Content-Type': 'application/x-www-form-urlencoded',
        },
        body: new URLSearchParams({
          action: 'zmeet_renew_zoom_oauth',
          security: zmeetMeetingsData.nonce,
        }),
      });
  
      const result = await response.json();
      
      if (result.success) {
        toast.success(langString('oauth_token_renewed') );
      } else {
        toast.error(result.message || langString('renew_failed_check_credentials') );
      }
    } catch (error) {
      toast.error(langString('something_went_wrong') );
    }
  
    setRenewText(langString('renew_oauth_token'));
  };
  
  return (
    <div className="zmeet-connect-tab-content">
        {/* Server to Server Oauth Credentials */}
        <div className="accordion" id="zmeet_s2sOauth-credentials">
          <div className="server-auth-credentials-info">
              <h3 className="title">
                {__('Server to Server OAuth Credentials', 'zoomeet')}
                {formData.oauth_account_id && formData.oauth_client_id && formData.oauth_client_secret &&
                  formData.oauth_account_id === savedCredentials.oauth_account_id &&
                  formData.oauth_client_id === savedCredentials.oauth_client_id &&
                  formData.oauth_client_secret === savedCredentials.oauth_client_secret && (
                    <span className="zmeet-status-connected">{__('Connected', 'zoomeet')}</span>
                  )}
              </h3>
              <p className="description">
                {langString('server_oauth_setup_hint')}{' '}
                <a
                  href="https://marketplace.zoom.us/"
                  target="_blank"
                  rel="noreferrer noopener"
                >
                  {langString('zoom_developer_portal')}
                </a>
                {'. '}
                {langString('watch_our')}{' '}
                <a
                  href="https://youtu.be/ApSm4QJXLGc"
                  target="_blank"
                  rel="noreferrer noopener"
                >
                  {langString('tutorial_video')}
                </a>
                {' '}
                {langString('for_guidance')}
              </p>
          </div>

          <div className="zmeet-section-pannel zmeet-zoon-connect-pannel">
            {/* Oauth Account ID */}
            <PassInputField
              label={langString('oauth_account_id')}
              type="password"
              id="zmeet_oauth_account_id"
              name="oauth_account_id"
              value={oauth_account_id}
              onChange={(value) =>
                handleInputChange('oauth_account_id', value)
              }
            />

            {/* Oauth Client ID */}
            <PassInputField
              label={langString('oauth_client_id') }
              type="password"
              id="zmeet_oauth_client_id"
              name="oauth_client_id"
              value={oauth_client_id}
              onChange={(value) =>
                 handleInputChange('oauth_client_id', value)
              }
            />

            {/* Oauth Client Secret */}
            <PassInputField
              label={langString('oauth_client_secret') }
              type="password"
              id="zmeet_oauth_client_secret"
              name="oauth_client_secret"
              value={oauth_client_secret}
              onChange={(value) =>
               handleInputChange('oauth_client_secret', value)
              }
            />
            
            <span className="zmeet-renew-oauth-button" onClick={handleRenewOAuth}> {renewText} </span>
          </div>         
        </div>

        {/* Meeting SDK App Credentials */}
        <div
          className="accordion"
          id="zmeet_s2sOauth-app-sdk-credentials"
        >
         <div className="server-auth-credentials-info">
            <h3 className="title">
              {langString('app_credentials')}
              {formData.sdk_client_id && formData.sdk_client_secret &&
                formData.sdk_client_id === savedCredentials.sdk_client_id &&
                formData.sdk_client_secret === savedCredentials.sdk_client_secret && (
                  <span className="zmeet-status-connected">{__('Connected', 'zoomeet')}</span>
                )}
            </h3>
            <p className="description">
              {langString('sdk_credentials_instruction')}{' '}
              <a
                href="https://marketplace.zoom.us/"
                target="_blank"
                rel="noreferrer noopener"
              >
                {langString('zoom_developer_portal')}
              </a>
              {'. '}
              {langString('view_our')}{' '}
              <a
                href="https://youtu.be/Q0Zt80PjvTE"
                target="_blank"
                rel="noreferrer noopener"
              >
                {langString('video_tutorial')}
              </a>
              {' '}
              {langString('for_assistance')}
            </p>
         </div>

          {/* Redirect URL Section */}
          <div className="msteams-redirect-url-section">
            <h3 className="title">Redirect URL for Zoom Meeting SDK</h3>
            <p className="description">
              Copy this URL and paste it as the Redirect URI when creating your Zoom Meeting SDK app in the Marketplace.
            </p>
            <div className="url-copy">
              <input
                type="text"
                readOnly
                value={zmeetMeetingsData.zoom_redirect_url || window.location.origin}
                id="zoom-redirect-url"
              />
              <span
                className="copy-button"
                onClick={(event) => {
                  const input = document.getElementById('zoom-redirect-url');
                  input.select();
                  document.execCommand('copy');
                  // Show a temporary "Copied!" message
                  const btn = event.target;
                  const originalText = btn.textContent;
                  btn.textContent = langString('copied') || 'Copied!';
                  setTimeout(() => {
                    btn.textContent = originalText;
                  }, 2000);
                }}
              >
                {langString('copy_url') || 'Copy URL'}
              </span>
            </div>
          </div>

          <div className="zmeet-section-pannel">
            {/* SDK Client ID */}
            <PassInputField
              label={langString('client_id') }
              type="password"
              id="zmeet_sdk_key"
              name="sdk_client_id"
              value={sdk_client_id}
              onChange={(value) =>
                handleInputChange('sdk_client_id', value)
              }
            />

            {/* SDK Client Secret */}
            <PassInputField
              label={langString('client_secret') }
              type="password"
              id="zmeet_sdk_secret_key"
              name="sdk_client_secret"
              value={sdk_client_secret}
              onChange={(value) =>
                handleInputChange('sdk_client_secret', value)
              }
            />
          </div>
        </div>

    </div>
  );
};

export default ConnectTab;
