
const SettingIcons = {};

SettingIcons.jitsi = (
	<svg width="50" height="49" viewBox="0 0 18 19" fill="none" xmlns="http://www.w3.org/2000/svg">
		<rect x="0.601624" y="0.525391" width="17" height="18" rx="4" fill="#17A0DB" />
		<path d="M11.5056 1.85879C11.4834 1.85897 11.4608 1.85993 11.4379 1.86174C11.1543 1.88411 10.9092 2.04669 10.7752 2.30135C10.724 2.39861 10.7109 2.48511 10.693 2.84207C10.6695 3.3125 10.6506 3.45117 10.5954 3.55896C10.5086 3.72849 10.1792 3.92995 9.70583 4.1029C9.37582 4.22346 9.14565 4.36633 8.91037 4.59668C8.57855 4.92155 8.44603 5.22016 8.3237 5.91837C8.29387 6.08863 8.2693 6.31583 8.26921 6.4233C8.26907 6.54716 8.25626 6.62835 8.23415 6.64498C8.21497 6.65942 8.11144 6.69384 8.00403 6.72155C7.36812 6.8856 6.84288 7.1941 6.49366 7.60863C6.31686 7.81848 6.11229 8.20801 6.05002 8.4534C5.95173 8.84077 5.95399 9.34748 6.05592 9.79187C6.11537 10.051 6.13159 10.189 6.10288 10.1913C6.08976 10.1924 5.95976 10.1964 5.81399 10.2003C5.3994 10.2114 5.11888 10.3501 4.75961 10.7218C4.37305 11.1217 4.1334 11.6469 4.03063 12.3194C3.98685 12.6059 3.99382 13.4075 4.0438 13.8356C4.09682 14.2899 4.19679 14.7406 4.32578 15.1073C4.39014 15.2902 4.61377 15.7374 4.98275 16.4207C5.29043 16.9904 5.54594 17.4529 5.55053 17.4484C5.55512 17.4439 5.67881 16.9087 5.82543 16.2591C6.1604 14.7751 6.22944 14.5496 6.44807 14.2256C6.59975 14.0009 6.60957 13.9997 6.96 14.1633C7.31935 14.3309 7.6896 14.4286 8.12881 14.4717C8.40247 14.4985 8.50781 14.4961 8.83599 14.4557C9.80404 14.3365 10.6369 13.9472 11.2861 13.3104C11.5398 13.0615 11.5659 13.0435 11.719 13.0123C12.3123 12.8912 12.9967 12.3102 13.4278 11.5616C13.8673 10.7982 14.0978 9.92974 14.1863 8.70248C14.2825 7.37037 13.9259 6.4895 13.1054 6.03251C13.0194 5.98463 12.8639 5.91907 12.7597 5.88677C12.6556 5.85447 12.5588 5.81315 12.5447 5.79494C12.5188 5.76158 12.397 5.32237 12.3977 5.26484C12.3979 5.24782 12.4401 5.16533 12.4914 5.08153C12.703 4.73625 12.8078 4.23767 12.7588 3.80866C12.7249 3.5111 12.4762 2.76813 12.2954 2.42406C12.0926 2.03815 11.8391 1.85618 11.5056 1.85879ZM11.4985 2.48572C11.6496 2.48572 11.7985 2.76284 12.0363 3.48632C12.2024 3.99182 12.155 4.44418 11.894 4.84459C11.8305 4.94198 11.7465 5.05521 11.7072 5.09626L11.6359 5.17087L11.7229 5.35667C11.7707 5.45887 11.8311 5.62268 11.857 5.72069C11.9047 5.90161 11.9202 6.23537 11.8858 6.3404C11.8677 6.39568 11.8781 6.39875 12.1394 6.41384C12.8524 6.45502 13.294 6.82083 13.4906 7.53304C13.5474 7.73871 13.5539 7.82281 13.5524 8.32516C13.5499 9.10905 13.4634 9.71515 13.2619 10.3587C12.977 11.2689 12.4805 11.9581 11.8657 12.2968C11.6795 12.3995 11.5366 12.4083 11.4168 12.3245C11.3711 12.2925 11.3242 12.2771 11.3127 12.2902C11.3012 12.3034 11.2304 12.4005 11.1554 12.506C10.4293 13.527 8.89227 14.0814 7.66919 13.7634C7.44256 13.7044 6.97761 13.4803 6.79372 13.3413L6.64351 13.2278L6.45125 13.3569C5.94523 13.6967 5.63308 14.2459 5.42339 15.1654C5.389 15.3162 5.34933 15.4611 5.3353 15.4874C5.30546 15.5436 5.24669 15.5499 5.20679 15.5012C5.1379 15.4171 4.97638 15.0605 4.89793 14.8194C4.71879 14.2687 4.64019 13.7156 4.63846 12.9935C4.63724 12.4853 4.66393 12.2732 4.77124 11.9366C4.88157 11.5906 5.02076 11.3528 5.24375 11.1295C5.54255 10.8304 5.72028 10.7733 6.073 10.8631C6.2943 10.9195 6.44285 10.9953 6.90034 11.2853C7.48846 11.6583 7.51237 11.6667 7.58091 11.5248C7.63965 11.4031 7.68632 11.192 7.65674 11.1818C7.56544 11.1503 7.31378 10.9428 7.20094 10.8058C7.02975 10.5981 6.81139 10.1641 6.72206 9.85416C6.59072 9.39843 6.57814 8.83637 6.69218 8.51873C6.86476 8.03807 7.23875 7.67741 7.79479 7.45531C8.06612 7.34693 8.23677 7.30097 8.64564 7.2264C8.82978 7.19282 8.98343 7.1633 8.98702 7.16081C8.99062 7.15832 8.97374 7.06458 8.94952 6.95251C8.89469 6.69886 8.90957 6.13157 8.97894 5.83037C9.135 5.15281 9.33562 4.91911 9.97084 4.67521C10.132 4.61335 10.3266 4.53168 10.4033 4.49369C10.7458 4.32412 11.0498 4.06162 11.1683 3.8332C11.2522 3.67173 11.3099 3.35 11.3288 2.93801C11.3465 2.55278 11.3717 2.48572 11.4985 2.48572ZM11.0292 4.66183C11.0207 4.65909 10.984 4.67676 10.9404 4.7052C10.8905 4.7377 10.6111 4.87991 10.3196 5.02121C9.66941 5.3363 9.58209 5.40435 9.50241 5.65751C9.4701 5.76014 9.43557 5.88922 9.42567 5.94434L9.40768 6.04456L9.76595 5.89552C10.3569 5.64983 10.3975 5.62914 10.5108 5.51508C10.6613 5.36363 10.825 5.12058 10.9368 4.88279C10.9886 4.77262 11.031 4.67433 11.031 4.66432C11.031 4.66307 11.0304 4.66222 11.0292 4.66183ZM11.3224 5.61101C11.3018 5.61101 11.2028 5.68837 11.1022 5.7829C10.9328 5.94219 10.9194 5.96335 10.9194 6.07213C10.9194 6.20687 10.9752 6.32893 11.065 6.39073C11.2565 6.52255 11.4495 6.32471 11.4495 5.99654C11.4495 5.81657 11.3817 5.61101 11.3224 5.61101ZM10.3767 6.13192C10.2454 6.13192 9.49204 6.46912 9.40042 6.56886C9.35111 6.62253 9.34912 6.64195 9.37853 6.77974C9.44486 7.09048 9.61565 7.35254 9.87048 7.53465C9.93741 7.58247 10.0144 7.61238 10.0706 7.61238C10.1771 7.61238 10.4771 7.46547 10.6837 7.31216C10.8211 7.21026 11.0031 6.98211 11.0031 6.91191C11.0031 6.8937 10.965 6.86325 10.9183 6.84426C10.6737 6.74468 10.5216 6.55357 10.4445 6.24848C10.4277 6.18189 10.3986 6.13192 10.3767 6.13192ZM12.4331 6.9327C12.4253 6.93318 12.4179 6.93466 12.411 6.93725C12.3659 6.95425 12.2865 7.20241 12.2865 7.32608C12.2865 7.37423 12.3569 7.6156 12.4429 7.86252C12.6894 8.56965 12.8314 9.00744 12.8862 9.22839C12.9478 9.47673 12.9661 9.44637 13.0094 9.02375C13.0811 8.32387 13.0356 7.7359 12.8839 7.39873C12.7719 7.14995 12.551 6.9256 12.4331 6.9327ZM11.8021 7.07504C11.7991 7.07443 11.7958 7.07495 11.7922 7.07629C11.7083 7.10794 11.4181 7.32104 11.1565 7.54312C10.6596 7.96509 10.2705 8.1884 10.0333 8.18781C9.8921 8.18745 9.68092 8.06416 9.44174 7.84244L9.24776 7.66262L9.04433 7.69359C8.73689 7.74032 8.26774 7.85096 8.0399 7.93053C7.62079 8.07688 7.36622 8.26835 7.23063 8.53898C7.13999 8.71992 7.13909 8.72517 7.13918 9.11969C7.13923 9.48079 7.14666 9.54066 7.21856 9.76447C7.3516 10.1786 7.55563 10.5116 7.75074 10.6332C7.82398 10.6789 7.86954 10.6846 8.05979 10.6719C8.18254 10.6637 8.43363 10.6258 8.61776 10.5877C9.00186 10.5084 10.1103 10.2124 10.1103 10.1892C10.1103 10.1621 9.75943 9.9457 9.61829 9.88575C9.13541 9.68065 8.68378 9.67151 7.91884 9.85139C7.73364 9.89494 7.58113 9.9167 7.53705 9.90583C7.45555 9.88573 7.41843 9.80784 7.44351 9.70967C7.46651 9.61962 7.8376 9.35183 8.17295 9.18323C8.98684 8.77403 9.83333 8.70743 10.6822 8.98591C11.1868 9.15144 11.5295 9.34142 12.3562 9.91386C12.4636 9.98823 12.5615 10.0394 12.5738 10.0275C12.6292 9.97368 12.403 9.12186 12.1327 8.3663C11.8393 7.54591 11.8354 7.53192 11.8322 7.2894C11.8301 7.13518 11.823 7.07934 11.8021 7.07504ZM9.50813 9.28827C9.1788 9.28479 9.1469 9.30912 9.39987 9.36475C9.83607 9.46068 10.2337 9.69633 10.6265 10.0917C10.9114 10.3784 10.9815 10.4307 11.1287 10.4656C11.3206 10.5111 11.8286 10.4745 12.0089 10.4022L12.0989 10.3661L11.7254 10.0904C11.279 9.76082 11.0928 9.64711 10.7873 9.51736C10.3884 9.34795 10.1778 9.30546 9.66751 9.29148C9.60828 9.28986 9.55517 9.28877 9.50813 9.28827ZM10.4415 10.5595L9.66914 10.8171C8.84954 11.0904 8.27111 11.3009 8.23043 11.3406C8.21687 11.3538 8.17001 11.452 8.12636 11.5588C7.93216 12.0338 7.58975 12.3936 7.05545 12.6843C6.96338 12.7344 6.88273 12.7798 6.87618 12.785C6.84167 12.8125 7.26659 13.0818 7.45595 13.1524C7.54258 13.1847 7.72012 13.2343 7.85055 13.2628C8.16527 13.3314 8.75972 13.3181 9.10027 13.2347C10.1854 12.9689 11.0758 12.0567 11.1862 11.0979L11.2053 10.9324L11.1251 10.9148C10.8588 10.8565 10.6663 10.7689 10.534 10.6457L10.4415 10.5595ZM12.5517 10.7198C12.5287 10.7191 12.452 10.7384 12.3665 10.7669C12.2688 10.7996 12.0822 10.8478 11.9518 10.874L11.7149 10.9217L11.6844 11.181C11.6676 11.3236 11.6312 11.5225 11.6035 11.623C11.5626 11.7714 11.5598 11.8135 11.5885 11.8474C11.6079 11.8704 11.6352 11.8892 11.6491 11.8892C11.6958 11.8892 12.1078 11.4664 12.2368 11.2861C12.3878 11.075 12.5779 10.7408 12.5581 10.7213C12.5571 10.7204 12.5549 10.7199 12.5517 10.7198ZM5.77112 11.4231C5.70807 11.4231 5.49255 11.6912 5.38706 11.9009C5.17131 12.3296 5.08698 12.8591 5.14204 13.439C5.16061 13.6345 5.18301 13.847 5.19181 13.9111C5.2006 13.9751 5.21214 14.0276 5.21751 14.0276C5.22287 14.0276 5.26373 13.9566 5.30832 13.8699C5.45426 13.5862 5.70023 13.2894 5.97964 13.0598L6.10351 12.9579L6.0176 12.8691C5.84705 12.6924 5.83569 12.6433 5.83987 12.1025C5.84396 11.5742 5.82865 11.4231 5.77112 11.4231ZM6.46941 11.6803C6.46576 11.6802 6.46316 11.6807 6.46178 11.682C6.41507 11.7279 6.35161 12.4085 6.39049 12.4467C6.40072 12.4567 6.41995 12.4649 6.43318 12.4649C6.48579 12.4649 6.78639 12.2992 6.95437 12.1775L7.13228 12.0486L6.98225 11.966C6.89974 11.9206 6.7534 11.8337 6.65704 11.7729C6.57272 11.7197 6.49495 11.6817 6.46941 11.6803Z" fill="white" />
	</svg>

);

SettingIcons.webex = (
	<svg width="50" height="46" viewBox="0 0 22 16" fill="none" xmlns="http://www.w3.org/2000/svg">
		<path d="M14.6027 0.0527829C13.8764 0.046217 13.1611 0.229283 12.5273 0.583883C11.8733 0.913805 11.3047 1.39085 10.8662 1.97755L8.7606 7.62754C8.72374 7.83862 8.67469 8.04739 8.61369 8.2528C8.58356 8.36957 8.55343 8.45997 8.52329 8.57673C8.34775 9.16145 8.14028 9.7361 7.9018 10.2981C7.721 10.622 7.45733 11.01 6.98273 10.9196L6.80193 10.8292C6.50513 10.6058 6.27043 10.3101 6.12016 9.9704C5.71821 9.2269 5.39988 8.44115 5.17097 7.62754C4.87508 6.61016 4.66714 5.56925 4.54946 4.51627C4.54765 4.03632 4.41761 3.56557 4.1728 3.15275C4.01164 2.93695 3.80939 2.75516 3.57767 2.61788C3.27317 2.43484 2.92704 2.33244 2.57197 2.32032C2.19167 2.31054 1.81455 2.39191 1.47211 2.55762C1.155 2.73268 0.893842 2.99384 0.718779 3.31095C0.518111 3.61864 0.414444 3.9795 0.42121 4.34678C0.427255 4.48657 0.447448 4.62538 0.481478 4.76111C0.598244 5.9476 1.10297 9.62763 2.7942 12.415C2.7942 12.415 4.18787 15.1119 7.18237 15.0516C7.90217 15.0327 8.60967 14.8606 9.25779 14.5469C9.91027 14.2418 10.4799 13.7846 10.9189 13.2135L12.1355 10.5166L13.0244 7.66897L13.1111 7.2245C13.2863 6.47382 13.5244 5.73924 13.823 5.02855C13.9176 4.73522 14.0924 4.47425 14.3277 4.27521L14.3578 4.24508C14.4628 4.19342 14.5808 4.17409 14.6968 4.18951C14.8128 4.20493 14.9216 4.25442 15.0095 4.33171C15.1206 4.40868 15.2122 4.51059 15.2769 4.62928C15.3673 4.74605 15.4238 4.86658 15.5142 4.98335C15.6581 5.22489 15.784 5.47668 15.8909 5.73668C15.9822 5.94801 16.0918 6.15092 16.2186 6.34311C16.2266 6.34311 16.2342 6.34628 16.2399 6.35193C16.2455 6.35758 16.2487 6.36524 16.2487 6.37323C16.4516 6.59225 16.6929 6.77226 16.9606 6.90433C17.224 7.04692 17.52 7.11834 17.8194 7.11151C18.0933 7.10929 18.3648 7.05958 18.6217 6.9646C18.8786 6.86791 19.1113 6.71621 19.3035 6.52014C19.4778 6.31109 19.627 6.08226 19.7479 5.83838C19.8382 5.58018 19.8878 5.30951 19.8948 5.03608C19.8951 4.74072 19.8349 4.44845 19.7178 4.17728C19.7178 4.17728 18.9155 2.10185 17.5218 1.06226C16.689 0.408909 15.6612 0.0534907 14.6027 0.0527829Z" fill="#21DEFF" />
		<path d="M14.6027 0.0527344C13.8749 0.0578526 13.1567 0.219729 12.4971 0.527337C11.8415 0.854799 11.2724 1.33229 10.836 1.92101L9.50262 5.50686L12.1129 10.5203L13.0018 7.67269L13.0885 7.22823C13.2637 6.47754 13.5018 5.74295 13.8004 5.03226C13.8949 4.73893 14.0698 4.47796 14.3051 4.27893L14.3352 4.2488C14.4402 4.19715 14.5582 4.17781 14.6742 4.19323C14.7902 4.20865 14.899 4.25814 14.9869 4.33543C15.098 4.4124 15.1896 4.5143 15.2543 4.63299C15.3447 4.74976 15.4012 4.87029 15.4916 4.98706C15.6355 5.2286 15.7613 5.48039 15.8683 5.74039C15.967 5.95123 16.0842 6.15291 16.2186 6.34306C16.2266 6.34306 16.2342 6.34624 16.2399 6.35189C16.2455 6.35754 16.2487 6.36519 16.2487 6.37319C16.4516 6.5922 16.6929 6.77221 16.9606 6.90429C17.224 7.04688 17.52 7.11829 17.8194 7.11146C18.0933 7.10924 18.3648 7.05953 18.6217 6.96455C18.8786 6.86786 19.1113 6.71617 19.3035 6.52009C19.4778 6.31104 19.627 6.08222 19.7479 5.83833C19.8382 5.58013 19.8878 5.30946 19.8948 5.03603C19.8951 4.74067 19.8348 4.4484 19.7178 4.17723C19.7178 4.17723 18.9155 2.10181 17.5218 1.06221C16.689 0.408861 15.6612 0.0534422 14.6027 0.0527344Z" fill="#44B044" />
		<path d="M6.80194 0.0527344C6.62382 0.0616567 6.44643 0.0817867 6.27084 0.113002C5.6021 0.248313 4.96796 0.518505 4.40713 0.907072C3.8463 1.29564 3.37054 1.79443 3.00891 2.373C3.2078 2.42059 3.39745 2.50077 3.57015 2.6103C3.80187 2.74758 4.00412 2.92937 4.16528 3.14517C4.41009 3.558 4.54013 4.02874 4.54194 4.5087C4.66647 5.53872 4.86536 6.55838 5.13707 7.55969C5.4206 6.46001 5.8921 5.41761 6.53074 4.47856C6.60531 4.36671 6.70619 4.27488 6.82454 4.21113C6.8874 4.17389 6.95867 4.15315 7.0317 4.15086C7.15691 4.14847 7.28048 4.17969 7.38954 4.24127C7.41967 4.24127 7.41967 4.2714 7.4498 4.2714C7.54507 4.36245 7.63322 4.46067 7.71348 4.56519C7.87086 4.85399 8.01048 5.1521 8.13157 5.45789C8.36887 6.10952 8.57603 6.93818 8.57603 6.93818L9.1674 9.31119C9.37451 10.1311 9.64269 10.9344 9.9697 11.7143C10.8888 13.8199 12.2824 14.4112 12.2824 14.4112C12.9707 14.7695 13.7295 14.9714 14.5048 15.0026C15.2428 15.0374 15.9776 14.8845 16.6404 14.5581C17.3677 14.1947 18.0095 13.6812 18.5238 13.0515C18.8336 12.6288 19.1106 12.183 19.3524 11.7181C19.9084 10.6231 20.3368 9.46799 20.6293 8.27536C20.8326 7.53219 20.9911 6.7775 21.1039 6.01536C21.1642 5.63869 21.2207 5.26203 21.2508 4.88536C21.3161 4.5319 21.3059 4.1686 21.2207 3.81939C21.1943 3.75913 21.1943 3.69887 21.1642 3.6386C20.9834 3.19958 20.6595 2.83455 20.2451 2.60277C19.9469 2.40289 19.5947 2.29905 19.2357 2.3052C19.0659 2.30858 18.8968 2.32877 18.731 2.36547C19.1142 2.925 19.4421 3.52042 19.7103 4.14333C19.8273 4.4145 19.8876 4.70678 19.8873 5.00213C19.8803 5.27556 19.8307 5.54623 19.7404 5.80443C19.6195 6.04832 19.4703 6.27714 19.2959 6.48619C19.1128 6.69292 18.8772 6.84646 18.6142 6.93066C18.3575 7.02692 18.086 7.0779 17.8119 7.08132C17.4446 7.08809 17.0837 6.98443 16.7761 6.78376L16.5651 7.58229C16.4066 8.19601 16.1883 8.79273 15.9135 9.36391C15.7666 9.71424 15.5889 10.0508 15.3824 10.3696C15.2473 10.5894 15.0509 10.7648 14.8174 10.8743C14.7305 10.8992 14.6402 10.9093 14.55 10.9045C14.4537 10.9022 14.3604 10.8706 14.2825 10.8141C14.1261 10.683 13.998 10.5216 13.9059 10.3395C13.786 10.1439 13.6779 9.94139 13.5819 9.73305C13.4049 9.28858 13.1073 8.19249 13.1073 8.19249L12.8286 7.02105L12.531 5.8647L12.3239 5.09252C12.0745 4.03233 11.6314 3.02734 11.0168 2.12817C10.4189 1.27669 9.56931 0.633886 8.58733 0.290036C8.20111 0.150638 7.79598 0.0706263 7.38577 0.0527344H6.80194Z" fill="#3774FF" />
	</svg>


);

SettingIcons.zoom = (
	<svg width="50" height="50" viewBox="0 0 19 19" fill="none" xmlns="http://www.w3.org/2000/svg">
		<g clipPath="url(#clip0_74_3)">
			<path d="M9.60162 18.5254C14.5722 18.5254 18.6016 14.496 18.6016 9.52539C18.6016 4.55483 14.5722 0.525391 9.60162 0.525391C4.63106 0.525391 0.601624 4.55483 0.601624 9.52539C0.601624 14.496 4.63106 18.5254 9.60162 18.5254Z" fill="#4A8CFF" />
			<path d="M3.82709 6.70767V10.9371C3.82931 11.3959 4.01356 11.835 4.33937 12.1579C4.66517 12.4808 5.10586 12.6612 5.5646 12.6594H11.7297C11.8131 12.6598 11.8932 12.6271 11.9524 12.5686C12.0117 12.51 12.0454 12.4303 12.046 12.347V8.11749C12.0438 7.65875 11.8595 7.21967 11.5337 6.89672C11.2079 6.57378 10.7672 6.3934 10.3085 6.39522H4.14525C4.10382 6.39477 4.06271 6.4025 4.02428 6.41797C3.98585 6.43344 3.95085 6.45635 3.92129 6.48538C3.89173 6.5144 3.86819 6.54898 3.85203 6.58713C3.83586 6.62527 3.82739 6.66624 3.82709 6.70767ZM12.4384 8.35754L14.9837 6.4981C15.2047 6.31482 15.3762 6.36093 15.3762 6.69242V12.3622C15.3762 12.7394 15.1666 12.6937 14.9837 12.5561L12.4384 10.7009V8.35754Z" fill="white" />
		</g>
		<defs>
			<clipPath id="clip0_74_3">
				<rect width="18" height="18" fill="white" transform="translate(0.601624 0.525391)" />
			</clipPath>
		</defs>
	</svg>
);

SettingIcons.google_meet = (
<svg width="51" height="43" viewBox="0 0 51 43" fill="none" xmlns="http://www.w3.org/2000/svg">
	<path d="M48.0561 5.8322L40.5713 12.0075V4.29094C40.5713 2.38503 39.0371 0.841064 37.143 0.841064H12.5747L0.861511 12.6288V30.454V38.7919C0.861511 40.6978 2.39575 42.2418 4.28978 42.2418H12.5747H37.143C39.0371 42.2418 40.5713 40.6978 40.5713 38.7919V31.3627L48.0902 37.5672C49.2154 38.4526 50.8615 37.645 50.8615 36.2047V7.16602C50.8615 5.70849 49.1787 4.90896 48.0561 5.8322ZM29.1439 30.454H12.5747V12.6288H29.1439V21.5414V30.454Z" fill="#F5BB41"/>
	<path d="M0.861511 30.4541V38.7919C0.861511 40.6978 2.39575 42.2418 4.28978 42.2418H12.5747V30.4541H0.861511Z" fill="#2167D1"/>
	<path d="M12.5747 12.6287H0.861511V30.4539H12.5747V12.6287Z" fill="#3D84F3"/>
	<path d="M48.0561 5.83213L40.5713 12.0074V31.3626L48.0901 37.5671C49.2154 38.4525 50.8615 37.6449 50.8615 36.2047V7.16595C50.8615 5.70842 49.1787 4.90889 48.0561 5.83213Z" fill="#4CA853"/>
	<path d="M29.1439 21.5413V30.4539H12.5746V42.2416H37.143C39.037 42.2416 40.5713 40.6976 40.5713 38.7917V31.3626L29.1439 21.5413Z" fill="#4CA853"/>
	<path d="M40.5713 31.3627V12.0134L29.1439 21.5414L40.5713 31.3627Z" fill="#398039"/>
	<path d="M0.861511 12.6288H12.5747V0.841064L0.861511 12.6288Z" fill="#D74F3F"/>
	<path d="M37.143 0.841064H12.5746V12.6288H29.1439V21.5414L40.5713 12.0135V12.0075V4.29094C40.5713 2.38503 39.037 0.841064 37.143 0.841064Z" fill="#F5BB41"/>
</svg>
);

SettingIcons.config_setting = (
	<svg fill="#2d8cff" height="30px" width="30px" version="1.1" id="Layer_1" 
		viewBox="0 0 512 512">
	<g>
		<g>
			<g>
				<path d="M256,192c-35.285,0-64,28.715-64,64s28.715,64,64,64s64-28.715,64-64S291.285,192,256,192z"/>
				<path d="M494.699,212.48l-28.245-5.44c-12.651-2.411-22.571-10.688-27.285-22.635c-4.715-12.011-3.051-24.832,4.587-35.221
					l17.728-24.192c6.229-8.469,5.312-20.245-2.133-27.669l-38.293-38.293c-7.211-7.232-18.603-8.299-27.029-2.581l-23.829,16.107
					c-10.624,7.232-23.467,8.405-35.307,3.285c-11.797-5.163-19.712-15.403-21.653-28.139l-4.565-29.611
					C307.072,7.68,298.112,0,287.573,0h-54.144c-10.219,0-19.008,7.253-20.949,17.301l-7.019,36.48
					c-2.368,12.352-10.389,22.208-22.016,27.008c-11.627,4.843-24.299,3.541-34.709-3.52l-30.763-20.821
					c-8.427-5.717-19.776-4.651-27.029,2.581L52.651,97.323c-7.445,7.424-8.363,19.2-2.133,27.669l17.728,24.213
					c7.637,10.368,9.301,23.189,4.587,35.2c-4.715,11.947-14.635,20.224-27.307,22.635l-28.224,5.44
					C7.253,214.421,0,223.211,0,233.429v54.144c0,10.539,7.68,19.499,18.091,21.099l29.611,4.565
					c12.736,1.941,22.976,9.856,28.139,21.653c5.141,11.797,3.947,24.661-3.285,35.328l-16.107,23.808
					c-5.739,8.448-4.651,19.797,2.581,27.029l38.293,38.293c7.445,7.467,19.2,8.32,27.669,2.133l24.213-17.728
					c10.368-7.616,23.168-9.259,35.2-4.587c11.947,4.715,20.224,14.635,22.635,27.307l5.44,28.224
					C214.421,504.747,223.211,512,233.429,512h54.144c10.539,0,19.499-7.68,21.099-18.091l3.2-20.821
					c2.005-13.035,10.133-23.381,22.293-28.395c12.075-5.035,25.195-3.477,35.84,4.331l17.003,12.459
					c8.427,6.187,20.224,5.333,27.669-2.133l38.293-38.293c7.232-7.232,8.32-18.581,2.581-27.029l-16.107-23.829
					c-7.232-10.645-8.427-23.509-3.285-35.307c5.163-11.797,15.403-19.712,28.139-21.653l29.611-4.565
					c10.411-1.6,18.091-10.56,18.091-21.099v-54.144C512,223.211,504.747,214.421,494.699,212.48z M256,362.667
					c-58.816,0-106.667-47.851-106.667-106.667S197.184,149.333,256,149.333S362.667,197.184,362.667,256
					S314.816,362.667,256,362.667z"/>
			</g>
		</g>
	</g>
	</svg>
);

SettingIcons.frontend_meeting = (
	<svg xmlns="http://www.w3.org/2000/svg" x="0px" y="0px" width="40" height="40" viewBox="0 0 80 80" fill="#339AF0">
	<path d="M 10 13 C 8.3550302 13 7 14.35503 7 16 L 7 56 C 7 57.64497 8.3550302 59 10 59 L 32 59 L 32 62 L 25.701172 62 L 19.763672 65.894531 L 19.720703 65.931641 C 19.26469 66.311652 19 66.875453 19 67.46875 L 19 69 L 61 69 L 61 67.46875 C 61 66.875454 60.733985 66.310547 60.279297 65.931641 L 60.236328 65.894531 L 54.298828 62 L 48 62 L 48 59 L 70 59 C 71.64497 59 73 57.64497 73 56 L 73 16 C 73 14.35503 71.64497 13 70 13 L 10 13 z M 10 15 L 70 15 C 70.56503 15 71 15.43497 71 16 L 71 56 C 71 56.56503 70.56503 57 70 57 L 48 57 L 32 57 L 10 57 C 9.4349698 57 9 56.56503 9 56 L 9 16 C 9 15.43497 9.4349698 15 10 15 z M 14 19 A 1 1 0 0 0 13 20 A 1 1 0 0 0 14 21 A 1 1 0 0 0 15 20 A 1 1 0 0 0 14 19 z M 18 19 A 1 1 0 0 0 17 20 A 1 1 0 0 0 18 21 A 1 1 0 0 0 19 20 A 1 1 0 0 0 18 19 z M 22 19 A 1 1 0 0 0 21 20 A 1 1 0 0 0 22 21 A 1 1 0 0 0 23 20 A 1 1 0 0 0 22 19 z M 26 19 A 1 1 0 0 0 25 20 A 1 1 0 0 0 26 21 A 1 1 0 0 0 27 20 A 1 1 0 0 0 26 19 z M 30 19 A 1 1 0 0 0 29 20 A 1 1 0 0 0 30 21 A 1 1 0 0 0 31 20 A 1 1 0 0 0 30 19 z M 34 19 A 1 1 0 0 0 33 20 A 1 1 0 0 0 34 21 A 1 1 0 0 0 35 20 A 1 1 0 0 0 34 19 z M 38 19 A 1 1 0 0 0 37 20 A 1 1 0 0 0 38 21 A 1 1 0 0 0 39 20 A 1 1 0 0 0 38 19 z M 42 19 A 1 1 0 0 0 41 20 A 1 1 0 0 0 42 21 A 1 1 0 0 0 43 20 A 1 1 0 0 0 42 19 z M 46 19 A 1 1 0 0 0 45 20 A 1 1 0 0 0 46 21 A 1 1 0 0 0 47 20 A 1 1 0 0 0 46 19 z M 50 19 A 1 1 0 0 0 49 20 A 1 1 0 0 0 50 21 A 1 1 0 0 0 51 20 A 1 1 0 0 0 50 19 z M 54 19 A 1 1 0 0 0 53 20 A 1 1 0 0 0 54 21 A 1 1 0 0 0 55 20 A 1 1 0 0 0 54 19 z M 58 19 A 1 1 0 0 0 57 20 A 1 1 0 0 0 58 21 A 1 1 0 0 0 59 20 A 1 1 0 0 0 58 19 z M 62 19 A 1 1 0 0 0 61 20 A 1 1 0 0 0 62 21 A 1 1 0 0 0 63 20 A 1 1 0 0 0 62 19 z M 66 19 A 1 1 0 0 0 65 20 A 1 1 0 0 0 66 21 A 1 1 0 0 0 67 20 A 1 1 0 0 0 66 19 z M 14 23 A 1 1 0 0 0 13 24 A 1 1 0 0 0 14 25 A 1 1 0 0 0 15 24 A 1 1 0 0 0 14 23 z M 66 23 A 1 1 0 0 0 65 24 A 1 1 0 0 0 66 25 A 1 1 0 0 0 67 24 A 1 1 0 0 0 66 23 z M 33.292969 25.292969 L 22.585938 36 L 33.292969 46.707031 L 34.707031 45.292969 L 25.414062 36 L 34.707031 26.707031 L 33.292969 25.292969 z M 46.707031 25.292969 L 45.292969 26.707031 L 54.585938 36 L 45.292969 45.292969 L 46.707031 46.707031 L 57.414062 36 L 46.707031 25.292969 z M 14 27 A 1 1 0 0 0 13 28 A 1 1 0 0 0 14 29 A 1 1 0 0 0 15 28 A 1 1 0 0 0 14 27 z M 66 27 A 1 1 0 0 0 65 28 A 1 1 0 0 0 66 29 A 1 1 0 0 0 67 28 A 1 1 0 0 0 66 27 z M 14 31 A 1 1 0 0 0 13 32 A 1 1 0 0 0 14 33 A 1 1 0 0 0 15 32 A 1 1 0 0 0 14 31 z M 66 31 A 1 1 0 0 0 65 32 A 1 1 0 0 0 66 33 A 1 1 0 0 0 67 32 A 1 1 0 0 0 66 31 z M 14 35 A 1 1 0 0 0 13 36 A 1 1 0 0 0 14 37 A 1 1 0 0 0 15 36 A 1 1 0 0 0 14 35 z M 66 35 A 1 1 0 0 0 65 36 A 1 1 0 0 0 66 37 A 1 1 0 0 0 67 36 A 1 1 0 0 0 66 35 z M 14 39 A 1 1 0 0 0 13 40 A 1 1 0 0 0 14 41 A 1 1 0 0 0 15 40 A 1 1 0 0 0 14 39 z M 66 39 A 1 1 0 0 0 65 40 A 1 1 0 0 0 66 41 A 1 1 0 0 0 67 40 A 1 1 0 0 0 66 39 z M 14 43 A 1 1 0 0 0 13 44 A 1 1 0 0 0 14 45 A 1 1 0 0 0 15 44 A 1 1 0 0 0 14 43 z M 66 43 A 1 1 0 0 0 65 44 A 1 1 0 0 0 66 45 A 1 1 0 0 0 67 44 A 1 1 0 0 0 66 43 z M 14 47 A 1 1 0 0 0 13 48 A 1 1 0 0 0 14 49 A 1 1 0 0 0 15 48 A 1 1 0 0 0 14 47 z M 66 47 A 1 1 0 0 0 65 48 A 1 1 0 0 0 66 49 A 1 1 0 0 0 67 48 A 1 1 0 0 0 66 47 z M 14 51 A 1 1 0 0 0 13 52 A 1 1 0 0 0 14 53 A 1 1 0 0 0 15 52 A 1 1 0 0 0 14 51 z M 18 51 A 1 1 0 0 0 17 52 A 1 1 0 0 0 18 53 A 1 1 0 0 0 19 52 A 1 1 0 0 0 18 51 z M 22 51 A 1 1 0 0 0 21 52 A 1 1 0 0 0 22 53 A 1 1 0 0 0 23 52 A 1 1 0 0 0 22 51 z M 26 51 A 1 1 0 0 0 25 52 A 1 1 0 0 0 26 53 A 1 1 0 0 0 27 52 A 1 1 0 0 0 26 51 z M 30 51 A 1 1 0 0 0 29 52 A 1 1 0 0 0 30 53 A 1 1 0 0 0 31 52 A 1 1 0 0 0 30 51 z M 34 51 A 1 1 0 0 0 33 52 A 1 1 0 0 0 34 53 A 1 1 0 0 0 35 52 A 1 1 0 0 0 34 51 z M 38 51 A 1 1 0 0 0 37 52 A 1 1 0 0 0 38 53 A 1 1 0 0 0 39 52 A 1 1 0 0 0 38 51 z M 42 51 A 1 1 0 0 0 41 52 A 1 1 0 0 0 42 53 A 1 1 0 0 0 43 52 A 1 1 0 0 0 42 51 z M 46 51 A 1 1 0 0 0 45 52 A 1 1 0 0 0 46 53 A 1 1 0 0 0 47 52 A 1 1 0 0 0 46 51 z M 50 51 A 1 1 0 0 0 49 52 A 1 1 0 0 0 50 53 A 1 1 0 0 0 51 52 A 1 1 0 0 0 50 51 z M 54 51 A 1 1 0 0 0 53 52 A 1 1 0 0 0 54 53 A 1 1 0 0 0 55 52 A 1 1 0 0 0 54 51 z M 58 51 A 1 1 0 0 0 57 52 A 1 1 0 0 0 58 53 A 1 1 0 0 0 59 52 A 1 1 0 0 0 58 51 z M 62 51 A 1 1 0 0 0 61 52 A 1 1 0 0 0 62 53 A 1 1 0 0 0 63 52 A 1 1 0 0 0 62 51 z M 66 51 A 1 1 0 0 0 65 52 A 1 1 0 0 0 66 53 A 1 1 0 0 0 67 52 A 1 1 0 0 0 66 51 z M 34 59 L 46 59 L 46 62 L 34 62 L 34 59 z M 26.298828 64 L 33 64 L 48 64 L 53.701172 64 L 58.273438 67 L 21.726562 67 L 26.298828 64 z">
	</path>
	</svg>
);

SettingIcons.multivendor = (
	<svg xmlns="http://www.w3.org/2000/svg" enableBackground="new 0 0 512 512" viewBox="0 0 512 512" id="ecommerce" width="35" height="35">
	<path fill="#fff" d="M486.4,83v352.6H25.6V83c0-16.2,13.1-29.3,29.3-29.3h402.3C473.3,53.8,486.4,66.9,486.4,83z"></path>
	<path fill="#ededed" d="M486.5,83.1v352.6h-29.2V83.1c0-16.2-13.1-29.3-29.3-29.3h29.2C473.4,53.8,486.5,66.9,486.5,83.1z"></path>
	<path fill="#d3f0fd" d="M54.7,406.5V83c0-4.5,3.6-8.1,8.1-8.1h386.3c4.5,0,8.1,3.6,8.1,8.1v323.4H54.7z"></path>
	<path fill="#fc8a8a" d="M333.8,199.3v11.1c0,2.5-2,4.6-4.6,4.6h-33.3c-2.5,0-4.6-2-4.6-4.6c0,0,0,0,0,0v-11.1c0-2.5,2-4.6,4.6-4.6h33.4C331.8,194.8,333.8,196.8,333.8,199.3z"></path>
	<path fill="#f96364" d="M333.8,199.3v11.1c0,2.5-2,4.6-4.6,4.6h-9.2c2.5,0,4.6-2,4.6-4.6v-11.1c0-2.5-2-4.6-4.6-4.6h9.2C331.8,194.8,333.8,196.8,333.8,199.3z"></path>
	<path fill="#fcb0b0" d="M305.1,215h-9.2c-2.5,0-4.6-2-4.6-4.5c0,0,0,0,0,0v-11.1c0-2.5,2-4.6,4.6-4.6c0,0,0,0,0,0h9.2c-2.5,0-4.6,2-4.6,4.6c0,0,0,0,0,0v11.1C300.6,212.9,302.6,215,305.1,215C305.1,215,305.1,215,305.1,215z"></path>
	<path fill="#a8b1b3" d="M155.3 364.3c0 9.1-7.4 16.5-16.5 16.5s-16.5-7.4-16.5-16.5c0-9.1 7.4-16.5 16.5-16.5C147.9 347.9 155.3 355.3 155.3 364.3zM243 364.3c0 9.1-7.4 16.5-16.5 16.5s-16.5-7.4-16.5-16.5c0-9.1 7.4-16.5 16.5-16.5 0 0 0 0 0 0C235.6 347.9 243 355.3 243 364.3z"></path>
	<path fill="#7c8b8e" d="M155.3 364.3c0 9.1-7.4 16.5-16.5 16.5-7 0-13.2-4.4-15.5-11 8.6 3 18-1.5 21-10.1 1.3-3.5 1.2-7.4 0-11C150.9 351.2 155.3 357.4 155.3 364.3zM243 364.3c0 9.1-7.4 16.5-16.5 16.5-7 0-13.2-4.4-15.5-11 8.6 3 18-1.5 21-10.1 1.3-3.6 1.3-7.4 0-11C238.6 351.2 243 357.4 243 364.3z"></path>
	<path fill="#7bde9e" d="M268.7,226.2l-30.8,99h-99.4c-4.1,0-7.8-2.7-9-6.7l-24.9-80c-1.5-5,1.3-10.3,6.3-11.9c0.9-0.3,1.8-0.4,2.8-0.4L268.7,226.2z"></path>
	<polygon fill="#51d27f" points="268.7 226.2 237.9 325.2 220.7 325.2 251.6 226.2"></polygon>
	<path fill="#a7eabf" d="M155.7,325.2h-17.1c-4.1,0-7.8-2.7-9-6.7l-24.9-80c-1.6-5,1.2-10.3,6.3-11.9c0.9-0.3,1.9-0.4,2.8-0.4h17.1c-5.2,0-9.5,4.3-9.5,9.5c0,0.9,0.1,1.9,0.4,2.8l24.9,80C147.9,322.5,151.5,325.2,155.7,325.2z"></path>
	<path fill="#333" d="M329.3,190.7h-33.4c-4.7,0-8.6,3.8-8.6,8.6v1.6h-4.3c-6.3,0-11.9,4.1-13.8,10.2l-3.5,11.2H113.6c-7.4,0-13.5,6-13.5,13.5c0,1.4,0.2,2.7,0.6,4l24.9,80c1.7,5.6,7,9.5,12.9,9.5h93.9l-4.3,13.8c-0.2,0.5-0.7,0.9-1.2,0.9h-88.1c-11.3,0-20.5,9.2-20.5,20.5s9.2,20.5,20.5,20.5c11.3,0,20.5-9.2,20.5-20.5c0,0,0,0,0,0c0-4.5-1.6-8.9-4.4-12.5h55.5c-2.8,3.6-4.3,7.9-4.4,12.5c0,11.3,9.1,20.5,20.4,20.6c11.3,0,20.5-9.1,20.6-20.4c0-7.9-4.4-15-11.5-18.5c0.1-0.2,0.2-0.5,0.3-0.7l41.1-131.9c0.8-2.7,3.3-4.6,6.2-4.6h4.3v1.6c0,4.7,3.8,8.6,8.6,8.6h33.3c4.7,0,8.6-3.8,8.6-8.6v-11.1C337.8,194.6,334,190.8,329.3,190.7z M133.3,317.3l-24.9-80c-0.9-2.9,0.7-6,3.6-6.9c0.5-0.2,1.1-0.2,1.6-0.2h149.7l-28.3,91h-96.4C136.1,321.2,134,319.6,133.3,317.3z M138.8,376.8c-6.9,0-12.5-5.6-12.5-12.5c0-6.9,5.6-12.5,12.5-12.5c6.9,0,12.5,5.6,12.5,12.5c0,0,0,0,0,0C151.3,371.2,145.7,376.8,138.8,376.8z M226.5,376.8c-6.9,0-12.5-5.6-12.5-12.5s5.6-12.5,12.5-12.5c6.9,0,12.5,5.6,12.5,12.5l0,0C239,371.2,233.4,376.8,226.5,376.8L226.5,376.8z M329.9,210.4c0,0.3-0.3,0.6-0.6,0.6h-33.3c-0.3,0-0.6-0.2-0.6-0.6v-11.1c0-0.3,0.3-0.6,0.6-0.6h33.4c0.3,0,0.6,0.3,0.6,0.6L329.9,210.4z"></path>
	<path fill="#333" d="M186.4 306.8c-2.2 0-4-1.8-4-4v-54.2c0-2.2 1.8-4 4-4s4 1.8 4 4v54.2C190.4 305 188.6 306.8 186.4 306.8zM217.6 306.8c-.2 0-.4 0-.7-.1-2.2-.4-3.7-2.4-3.3-4.6 0 0 0 0 0 0l9-54.2c.3-2.2 2.3-3.7 4.5-3.5 2.2.3 3.7 2.3 3.5 4.5 0 .1 0 .2 0 .3l-9 54.2C221.2 305.4 219.5 306.8 217.6 306.8zM155.3 306.8c-2 0-3.6-1.4-3.9-3.4l-8.9-54.2c-.3-2.2 1.3-4.2 3.5-4.5 2.1-.3 4 1.1 4.4 3.2l8.9 54.2c.4 2.2-1.1 4.2-3.3 4.6 0 0 0 0 0 0C155.7 306.8 155.5 306.8 155.3 306.8zM407.9 252.6H325c-2.2 0-4-1.8-4-4s1.8-4 4-4h82.9c2.2 0 4 1.8 4 4S410.1 252.6 407.9 252.6zM407.9 285.7h-100c-2.2 0-4-1.8-4-4s1.8-4 4-4h100c2.2 0 4 1.8 4 4S410.1 285.7 407.9 285.7zM407.9 318.8H290.8c-2.2 0-4-1.8-4-4s1.8-4 4-4h117.1c2.2 0 4 1.8 4 4S410.1 318.8 407.9 318.8zM407.9 351.9H273.6c-2.2 0-4-1.8-4-4s1.8-4 4-4h134.2c2.2 0 4 1.8 4 4S410.1 351.9 407.9 351.9z"></path>
	<path fill="#d3d9d9" d="M509,435.7v19.6c0,16.5-13.4,29.9-29.9,29.9H32.9C16.4,485.1,3,471.7,3,455.2v-19.6H509z"></path>
	<path fill="#ededed" d="M62.1,485.1H32.9C16.4,485.1,3,471.7,3,455.2v-19.6h29.3v19.6C32.3,471.7,45.6,485.1,62.1,485.1z"></path>
	<path fill="#a8b2b4" d="M509,435.7v19.6c0,16.5-13.4,29.9-29.9,29.9h-29.3c16.5,0,29.9-13.4,29.9-29.9v-19.6H509z"></path>
	<path fill="#fff" d="M328.6,435.7v14.1c0,4.9-4,8.9-8.9,8.9H192.2c-4.9,0-8.9-4-8.9-8.9v-14.1H328.6z"></path>
	<path fill="#ededed" d="M328.7,435.7v14.1c0,4.9-4,8.8-8.9,8.8h-23.7c4.9,0,8.8-4,8.8-8.8v-14.1H328.7z"></path>
	<path fill="#fedd8e" d="M76.1 118h72v15.1c0 19.9-16.1 36-36 36s-36-16.1-36-36c0 0 0 0 0 0V118zM435.9 118v15.1c.1 19.9-15.9 36.1-35.8 36.2-19.9.1-36.1-15.9-36.2-35.8 0-.1 0-.3 0-.4V118H435.9zM220 118h72v15.1c0 19.9-16.1 36-36 36-19.9 0-36-16.1-36-36V118z"></path>
	<path fill="#fc8a8a" d="M4.1 118h72v15.1c0 19.9-16.1 36-36 36s-36-16.1-36-36c0 0 0 0 0 0L4.1 118zM292 118h72v15.1c0 19.9-16.1 36-36 36-19.9 0-36-16.1-36-36V118zM148 118h72v15.1c0 19.9-16.1 36-36 36s-36-16.1-36-36c0 0 0 0 0 0V118zM507.9 118v15.1c0 19.9-16.1 36-36 36-19.9 0-36-16.1-36-36 0 0 0 0 0 0V118H507.9zM98.9 26.9L76.1 118h-72l26.3-74.7c3.5-9.8 12.7-16.4 23.2-16.4H98.9z"></path>
	<polygon fill="#fedd8e" points="161.8 26.9 148 118 76.1 118 98.9 26.9"></polygon>
	<polygon fill="#fc8a8a" points="224.6 26.9 220 118 148 118 161.8 26.9"></polygon>
	<polygon fill="#fedd8e" points="287.4 26.9 292 118 220 118 224.6 26.9"></polygon>
	<polygon fill="#fc8a8a" points="350.2 26.9 364 118 292 118 287.4 26.9"></polygon>
	<polygon fill="#fedd8e" points="413.1 26.9 435.9 118 364 118 350.2 26.9"></polygon>
	<path fill="#fc8a8a" d="M481.7,43.3l26.3,74.7h-72l-22.9-91.1h45.4C468.9,26.9,478.2,33.5,481.7,43.3z"></path>
	<path fill="#fee9b4" d="M120.8 168c-2.9.7-5.8 1-8.7 1-19.9 0-36-16.1-36-36V118h17.4v15.1C93.5 149.6 104.7 164 120.8 168zM408.7 168c-2.9.7-5.8 1-8.7 1-19.9 0-36-16.1-36-36V118h17.4v15.1C381.4 149.6 392.6 164 408.7 168zM264.7 168c-2.9.7-5.8 1-8.7 1-19.9 0-36-16.1-36-36V118h17.4v15.1C237.4 149.6 248.7 164 264.7 168z"></path>
	<path fill="#fcb0b0" d="M48.8 168c-2.9.7-5.8 1-8.7 1-19.9 0-36-16.1-36-36V118h17.4v15.1C21.5 149.6 32.7 164 48.8 168zM336.7 168c-2.9.7-5.8 1-8.7 1-19.9 0-36-16.1-36-36V118h17.4v15.1C309.4 149.6 320.7 164 336.7 168zM192.7 168c-2.9.7-5.8 1-8.7 1-19.9 0-36-16.1-36-36V118h17.4v15.1C165.4 149.6 176.7 164 192.7 168zM480.7 168c-2.9.7-5.8 1-8.7 1-19.9 0-36-16.1-36-36V118h17.4v15.1C453.4 149.6 464.6 164 480.7 168zM53.5 26.9l-32 91.1H4.1l26.3-74.7C33.8 33.5 43.1 26.9 53.5 26.9z"></path>
	<polygon fill="#fee9b4" points="116.3 26.9 93.5 118 93.5 118 76.1 118 76.1 118 98.9 26.9"></polygon>
	<polygon fill="#fcb0b0" points="179.1 26.9 165.4 118 148 118 161.8 26.9"></polygon>
	<polygon fill="#fee9b4" points="242 26.9 237.4 118 220 118 224.6 26.9"></polygon>
	<polygon fill="#fcb0b0" points="309.4 118 292 118 287.4 26.9 304.8 26.9"></polygon>
	<polygon fill="#fee9b4" points="381.4 118 364 118 350.3 26.9 367.6 26.9"></polygon>
	<polygon fill="#fcb0b0" points="453.3 118 435.9 118 413.1 26.9 430.5 26.9"></polygon>
	<path fill="#fdd367" d="M148 118v15.1c0 19.9-16.1 36-36 36-2.9 0-5.8-.3-8.7-1 6.3-1.6 12.1-4.9 16.7-9.5 6.8-6.7 10.6-15.9 10.6-25.4V118H148zM435.9 118v15.1c0 19.9-16.1 36-36 36-2.9 0-5.8-.3-8.7-1 6.3-1.6 12.1-4.9 16.7-9.5 6.8-6.7 10.6-15.9 10.6-25.4V118H435.9zM292 118v15.1c0 19.9-16.1 36-36 36-2.9 0-5.8-.3-8.7-1 6.3-1.6 12.1-4.9 16.7-9.5 6.8-6.7 10.6-15.9 10.6-25.4V118H292z"></path>
	<path fill="#f96364" d="M76.1 118v15.1c0 19.9-16.1 36-36 36-2.9 0-5.8-.3-8.7-1 6.3-1.6 12.1-4.9 16.7-9.5 6.8-6.7 10.6-15.9 10.6-25.4V118H76.1zM364 118v15.1c0 19.9-16.1 36-36 36-2.9 0-5.8-.3-8.7-1 6.3-1.6 12.1-4.9 16.7-9.5 6.8-6.7 10.6-15.9 10.6-25.4V118H364zM220 118v15.1c0 19.9-16.1 36-36 36-2.9 0-5.8-.3-8.7-1 6.3-1.6 12.1-4.9 16.7-9.5 6.8-6.7 10.6-15.9 10.6-25.4V118H220zM507.9 118v15.1c0 19.9-16.1 36-36 36-2.9 0-5.8-.3-8.7-1 6.3-1.6 12.1-4.9 16.7-9.5 6.8-6.7 10.6-15.9 10.6-25.4V118H507.9z"></path>
	<polygon fill="#f96364" points="98.9 26.9 76.1 118 58.7 118 81.5 26.9"></polygon>
	<polygon fill="#fdd367" points="161.8 26.9 148 118 148 118 130.6 118 130.6 118 144.4 26.9"></polygon>
	<polygon fill="#f96364" points="224.6 26.9 220 118 202.6 118 207.2 26.9"></polygon>
	<polygon fill="#fdd367" points="292 118 274.6 118 270 26.9 287.4 26.9"></polygon>
	<polygon fill="#f96364" points="364 118 346.6 118 332.9 26.9 350.2 26.9"></polygon>
	<polygon fill="#fdd367" points="435.9 118 418.5 118 395.7 26.9 413.1 26.9"></polygon>
	<path fill="#f96364" d="M507.9,118h-17.4l-32-91.1l0,0c10.4,0,19.7,6.6,23.2,16.4L507.9,118z"></path>
	<path fill="#333" d="M509,432.7h-19.6V167.9c3.7-1.9,7.1-4.3,10-7.2c7.4-7.3,11.5-17.2,11.4-27.6V118c0-0.2-0.1-0.9-0.2-1l-26.2-74.7c-3.9-11-14.3-18.4-26-18.4h-405c-11.7,0-22.1,7.4-26,18.4L1.2,117c0,0.1-0.1,0.8-0.2,1v15.1c0,14.7,8.3,28.2,21.5,34.8v264.8H3c-1.7,0-3,1.3-3,3v19.6c0,18.1,14.7,32.8,32.9,32.9h446.3c18.1,0,32.8-14.7,32.9-32.9v-19.6C512,434,510.7,432.7,509,432.7z M504.9,133.1c0,18.2-14.8,33-33,33c-18.2,0-33-14.8-33-33V121h66L504.9,133.1z M28.6,432.6V170.3c7.6,2.3,15.6,2.3,23.2-0.1v236.2c0,1.7,1.3,3,3,3h402.5c1.7,0,3-1.3,3-3V170.3c7.5,2.4,15.6,2.4,23.2,0.1v262.3L28.6,432.6z M325.6,438.7v11.1c0,3.2-2.6,5.9-5.9,5.9H192.2c-3.2,0-5.9-2.6-5.9-5.9v-11.1L325.6,438.7z M112,172.1c15.7-0.1,29.9-9.5,36-24c8.4,19.9,31.2,29.2,51.1,20.9c9.4-4,16.9-11.4,20.9-20.9c8.4,19.9,31.2,29.2,51.1,20.9c9.4-4,16.9-11.4,20.9-20.9c8.4,19.9,31.2,29.2,51.1,20.9c9.4-4,16.9-11.4,20.9-20.9c8.4,19.9,31.2,29.2,51.1,20.9c9.4-4,16.9-11.4,20.9-20.9c3.6,8.5,10.1,15.5,18.3,19.7v235.7H57.7V167.8c3.6-1.9,7-4.3,9.9-7.2c3.6-3.6,6.5-7.8,8.5-12.5C82.1,162.6,96.3,172.1,112,172.1L112,172.1z M79.1,133.1V121h66v12.1c0,18.2-14.8,33-33,33C93.8,166.1,79.1,151.3,79.1,133.1L79.1,133.1z M151,133.1V121h66v12.1c0,18.2-14.8,33-33,33C165.8,166.1,151.1,151.3,151,133.1L151,133.1z M295,133.1V121h66v12.1c0,18.2-14.8,33-33,33C309.8,166.1,295,151.3,295,133.1L295,133.1z M367,133.1V121h66v12.1c0,18.2-14.8,33-33,33C381.7,166.1,367,151.3,367,133.1L367,133.1z M458.5,29.9c9.1,0,17.3,5.8,20.3,14.4l24.9,70.7h-65.4l-21.4-85.1H458.5z M410.7,29.9l21.4,85.1h-65.6l-12.8-85.1H410.7z M347.7,29.9l12.8,85.1h-65.6l-4.3-85.1H347.7z M227.4,29.9h57.1l4.3,85.1h-65.7L227.4,29.9z M223,121h66v12.1c0,18.2-14.8,33-33,33c-18.2,0-33-14.8-33-33L223,121z M164.3,29.9h57.1l-4.3,85.1h-65.6L164.3,29.9z M101.3,29.9h57L145.4,115H79.9L101.3,29.9z M33.2,44.3c3-8.6,11.2-14.4,20.3-14.4h41.6L73.7,115H8.3L33.2,44.3z M7.1,133.1V121h66v12.1c0,18.2-14.8,33-33,33C21.9,166.1,7.1,151.3,7.1,133.1z M506,455.2c0,14.8-12,26.9-26.9,26.9H32.9C18,482.1,6,470.1,6,455.2v-16.6h174.4v11.1c0,6.5,5.3,11.8,11.9,11.9h127.6c6.5,0,11.8-5.3,11.9-11.9v-11.1H506V455.2z"></path>
	</svg>
);

SettingIcons.woocommerce = (
<svg width="40px" height="40px" viewBox="0 -51.5 256 256" xmlns="http://www.w3.org/2000/svg" preserveAspectRatio="xMidYMid">
<path d="M23.759 0h208.378C245.325 0 256 10.675 256 23.863v79.541c0 13.188-10.675 23.863-23.863 23.863H157.41l10.257 25.118-45.109-25.118H23.863c-13.187 0-23.862-10.675-23.862-23.863V23.863C-.104 10.78 10.57 0 23.759 0z" fill="#9B5C8F"/><path d="M14.578 21.75c1.457-1.978 3.642-3.018 6.556-3.226 5.308-.417 8.326 2.08 9.054 7.492 3.226 21.75 6.764 40.17 10.51 55.259l22.79-43.395c2.082-3.955 4.684-6.036 7.806-6.244 4.579-.312 7.388 2.601 8.533 8.741 2.602 13.84 5.932 25.6 9.886 35.59 2.706-26.432 7.285-45.476 13.737-57.235 1.56-2.914 3.85-4.371 6.868-4.58 2.394-.207 4.579.521 6.556 2.082 1.977 1.561 3.018 3.538 3.226 5.932.104 1.873-.208 3.434-1.04 4.995-4.059 7.493-7.39 20.085-10.095 37.567-2.601 16.963-3.538 30.18-2.914 39.65.209 2.6-.208 4.89-1.248 6.868-1.25 2.289-3.122 3.538-5.516 3.746-2.706.208-5.515-1.04-8.221-3.85-9.678-9.887-17.379-24.664-22.998-44.332-6.765 13.32-11.76 23.31-14.986 29.97-6.14 11.76-11.343 17.796-15.714 18.108-2.81.208-5.203-2.186-7.284-7.18-5.307-13.633-11.031-39.962-17.17-78.986-.417-2.706.207-5.1 1.664-6.972zm223.636 16.338c-3.746-6.556-9.262-10.51-16.65-12.072-1.978-.416-3.85-.624-5.62-.624-9.99 0-18.107 5.203-24.455 15.61-5.412 8.845-8.117 18.627-8.117 29.346 0 8.013 1.665 14.881 4.995 20.605 3.746 6.556 9.262 10.51 16.65 12.071 1.977.417 3.85.625 5.62.625 10.094 0 18.211-5.203 24.455-15.61 5.411-8.95 8.117-18.732 8.117-29.45.104-8.117-1.665-14.882-4.995-20.501zm-13.112 28.826c-1.457 6.868-4.059 11.967-7.91 15.401-3.017 2.706-5.827 3.85-8.428 3.33-2.498-.52-4.58-2.705-6.14-6.764-1.25-3.226-1.873-6.452-1.873-9.47 0-2.601.208-5.203.728-7.596.937-4.267 2.706-8.43 5.515-12.384 3.435-5.1 7.077-7.18 10.823-6.452 2.498.52 4.58 2.706 6.14 6.764 1.249 3.226 1.873 6.452 1.873 9.47 0 2.706-.208 5.307-.728 7.7zm-52.033-28.826c-3.746-6.556-9.366-10.51-16.65-12.072-1.977-.416-3.85-.624-5.62-.624-9.99 0-18.107 5.203-24.455 15.61-5.411 8.845-8.117 18.627-8.117 29.346 0 8.013 1.665 14.881 4.995 20.605 3.746 6.556 9.262 10.51 16.65 12.071 1.978.417 3.85.625 5.62.625 10.094 0 18.211-5.203 24.455-15.61 5.412-8.95 8.117-18.732 8.117-29.45 0-8.117-1.665-14.882-4.995-20.501zm-13.216 28.826c-1.457 6.868-4.059 11.967-7.909 15.401-3.018 2.706-5.828 3.85-8.43 3.33-2.497-.52-4.578-2.705-6.14-6.764-1.248-3.226-1.872-6.452-1.872-9.47 0-2.601.208-5.203.728-7.596.937-4.267 2.706-8.43 5.516-12.384 3.434-5.1 7.076-7.18 10.822-6.452 2.498.52 4.58 2.706 6.14 6.764 1.25 3.226 1.873 6.452 1.873 9.47.105 2.706-.208 5.307-.728 7.7z" fill="#FFF"/></svg>
);

SettingIcons.google_clender = (
	<svg xmlns="http://www.w3.org/2000/svg" x="0px" y="0px" width="40" height="40" viewBox="0 0 48 48">
	<rect width="22" height="22" x="13" y="13" fill="#fff"></rect><polygon fill="#1e88e5" points="25.68,20.92 26.688,22.36 28.272,21.208 28.272,29.56 30,29.56 30,18.616 28.56,18.616"></polygon><path fill="#1e88e5" d="M22.943,23.745c0.625-0.574,1.013-1.37,1.013-2.249c0-1.747-1.533-3.168-3.417-3.168 c-1.602,0-2.972,1.009-3.33,2.453l1.657,0.421c0.165-0.664,0.868-1.146,1.673-1.146c0.942,0,1.709,0.646,1.709,1.44 c0,0.794-0.767,1.44-1.709,1.44h-0.997v1.728h0.997c1.081,0,1.993,0.751,1.993,1.64c0,0.904-0.866,1.64-1.931,1.64 c-0.962,0-1.784-0.61-1.914-1.418L17,26.802c0.262,1.636,1.81,2.87,3.6,2.87c2.007,0,3.64-1.511,3.64-3.368 C24.24,25.281,23.736,24.363,22.943,23.745z"></path><polygon fill="#fbc02d" points="34,42 14,42 13,38 14,34 34,34 35,38"></polygon><polygon fill="#4caf50" points="38,35 42,34 42,14 38,13 34,14 34,34"></polygon><path fill="#1e88e5" d="M34,14l1-4l-1-4H9C7.343,6,6,7.343,6,9v25l4,1l4-1V14H34z"></path><polygon fill="#e53935" points="34,34 34,42 42,34"></polygon><path fill="#1565c0" d="M39,6h-5v8h8V9C42,7.343,40.657,6,39,6z"></path><path fill="#1565c0" d="M9,42h5v-8H6v5C6,40.657,7.343,42,9,42z"></path>
	</svg>
);

SettingIcons.google_clender = (
	<svg xmlns="http://www.w3.org/2000/svg" x="0px" y="0px" width="40" height="40" viewBox="0 0 48 48">
	<rect width="22" height="22" x="13" y="13" fill="#fff"></rect><polygon fill="#1e88e5" points="25.68,20.92 26.688,22.36 28.272,21.208 28.272,29.56 30,29.56 30,18.616 28.56,18.616"></polygon><path fill="#1e88e5" d="M22.943,23.745c0.625-0.574,1.013-1.37,1.013-2.249c0-1.747-1.533-3.168-3.417-3.168 c-1.602,0-2.972,1.009-3.33,2.453l1.657,0.421c0.165-0.664,0.868-1.146,1.673-1.146c0.942,0,1.709,0.646,1.709,1.44 c0,0.794-0.767,1.44-1.709,1.44h-0.997v1.728h0.997c1.081,0,1.993,0.751,1.993,1.64c0,0.904-0.866,1.64-1.931,1.64 c-0.962,0-1.784-0.61-1.914-1.418L17,26.802c0.262,1.636,1.81,2.87,3.6,2.87c2.007,0,3.64-1.511,3.64-3.368 C24.24,25.281,23.736,24.363,22.943,23.745z"></path><polygon fill="#fbc02d" points="34,42 14,42 13,38 14,34 34,34 35,38"></polygon><polygon fill="#4caf50" points="38,35 42,34 42,14 38,13 34,14 34,34"></polygon><path fill="#1e88e5" d="M34,14l1-4l-1-4H9C7.343,6,6,7.343,6,9v25l4,1l4-1V14H34z"></path><polygon fill="#e53935" points="34,34 34,42 42,34"></polygon><path fill="#1565c0" d="M39,6h-5v8h8V9C42,7.343,40.657,6,39,6z"></path><path fill="#1565c0" d="M9,42h5v-8H6v5C6,40.657,7.343,42,9,42z"></path>
	</svg>
);

SettingIcons.tutor_lms = (
	<svg fill="#0049F8" xmlns="http://www.w3.org/2000/svg" width="40" height="40" viewBox="0 0 1000 1139"><defs/><path fillRule="evenodd" clipRule="evenodd" d="M341.652 622.4c-23.412 0-43.222-19.8-43.222-43.2v-99c0-23.4 19.81-43.2 43.222-43.2 23.412 0 43.222 19.8 43.222 43.2v99c0 23.4-18.009 43.2-43.222 43.2 1.801 0 1.801 0 0 0zM655.01 622.4c-23.412 0-43.222-18-43.222-43.2v-99c0-23.4 19.81-43.2 43.222-43.2 23.412 0 43.222 19.8 43.222 43.2v99c0 25.2-19.81 43.2-43.222 43.2z" fill="#0049F8"/><path fillRule="evenodd" clipRule="evenodd" d="M255.204 406.4c18.009-37.8 54.028-63 95.449-63 61.231 1.8 108.055 52.2 106.254 113.4v203.4c3.602 21.6 23.412 37.8 45.023 34.2 18.009-1.8 32.416-16.2 34.217-34.2V455c-1.801-61.2 46.824-111.6 106.254-113.4 39.621 0 75.639 21.6 93.648 59.4 68.435 133.2 14.407 295.2-117.06 363.6C487.523 833 325.44 779 258.806 647.6c-39.62-75.6-39.62-165.6-3.602-241.2zM426.291 140h151.277v59.4c-25.212-5.4-52.226-9-77.439-9-25.213 0-50.426 3.6-75.639 7.2l1.801-57.6zm414.211 388.8c0-122.4-66.634-235.8-172.888-295.2V140h64.833c25.213 0 45.023-19.8 45.023-45s-21.611-45-45.023-45H271.413C246.2 51.8 226.39 71.6 226.39 96.8c0 25.2 19.81 45 45.023 45h66.633v91.8c-163.883 90-230.517 298.8-135.068 459 3.602 5.4-3.602-5.4 0 0C338.046 930.2 687.424 948.2 802.683 950c10.805 0 19.81-3.6 27.014-10.8 7.203-7.2 10.805-18 10.805-27V528.8z" fill="#0049F8"/></svg>
);

SettingIcons.woo_booking = (
	<svg xmlns="http://www.w3.org/2000/svg" x="0px" y="0px" width="40" height="40" viewBox="0 0 48 48">
	<linearGradient id="gDhs_GJdOvNXmd9k7HRk_a_kzZctsAbGur5_gr1" x1="23.02" x2="25.063" y1="4.362" y2="18.044" gradientUnits="userSpaceOnUse"><stop offset=".042" stopColor="#076db4"></stop><stop offset=".85" stopColor="#0461af"></stop></linearGradient><path fill="url(#gDhs_GJdOvNXmd9k7HRk_a_kzZctsAbGur5_gr1)" d="M42,14H6V8c0-1.105,0.895-2,2-2h32c1.105,0,2,0.895,2,2V14z"></path><linearGradient id="gDhs_GJdOvNXmd9k7HRk_b_kzZctsAbGur5_gr2" x1="21.635" x2="27.567" y1="6.417" y2="58.193" gradientUnits="userSpaceOnUse"><stop offset="0" stopColor="#33bef0"></stop><stop offset="1" stopColor="#0a85d9"></stop></linearGradient>
	<path fill="url(#gDhs_GJdOvNXmd9k7HRk_b_kzZctsAbGur5_gr2)" d="M6,14v26c0,1.105,0.895,2,2,2h32c1.105,0,2-0.895,2-2V14H6z"></path><path fill="#fff" d="M21,23h-2c-0.552,0-1-0.448-1-1v-2c0-0.552,0.448-1,1-1h2c0.552,0,1,0.448,1,1v2 C22,22.552,21.552,23,21,23z"></path><path fill="#fff" d="M29,23h-2c-0.552,0-1-0.448-1-1v-2c0-0.552,0.448-1,1-1h2c0.552,0,1,0.448,1,1v2 C30,22.552,29.552,23,29,23z"></path><path fill="#fff" d="M37,23h-2c-0.552,0-1-0.448-1-1v-2c0-0.552,0.448-1,1-1h2c0.552,0,1,0.448,1,1v2 C38,22.552,37.552,23,37,23z"></path><path fill="#fff" d="M21,30h-2c-0.552,0-1-0.448-1-1v-2c0-0.552,0.448-1,1-1h2c0.552,0,1,0.448,1,1v2 C22,29.552,21.552,30,21,30z"></path><path fill="#fff" d="M13,30h-2c-0.552,0-1-0.448-1-1v-2c0-0.552,0.448-1,1-1h2c0.552,0,1,0.448,1,1v2 C14,29.552,13.552,30,13,30z"></path><path fill="#fff" d="M29,30h-2c-0.552,0-1-0.448-1-1v-2c0-0.552,0.448-1,1-1h2c0.552,0,1,0.448,1,1v2 C30,29.552,29.552,30,29,30z"></path><path fill="#fff" d="M21,37h-2c-0.552,0-1-0.448-1-1v-2c0-0.552,0.448-1,1-1h2c0.552,0,1,0.448,1,1v2 C22,36.552,21.552,37,21,37z"></path><path fill="#fff" d="M13,37h-2c-0.552,0-1-0.448-1-1v-2c0-0.552,0.448-1,1-1h2c0.552,0,1,0.448,1,1v2 C14,36.552,13.552,37,13,37z"></path><path fill="#fff" d="M29,37h-2c-0.552,0-1-0.448-1-1v-2c0-0.552,0.448-1,1-1h2c0.552,0,1,0.448,1,1v2 C30,36.552,29.552,37,29,37z"></path><path fill="#fff" d="M37,30h-2c-0.552,0-1-0.448-1-1v-2c0-0.552,0.448-1,1-1h2c0.552,0,1,0.448,1,1v2 C38,29.552,37.552,30,37,30z"></path><path d="M14,6v3.5c0,0.276-0.225,0.5-0.5,0.5S13,9.776,13,9.5V6h-2v3.5c0,1.378,1.121,2.5,2.5,2.5 S16,10.878,16,9.5V6H14z" opacity=".05"></path><path d="M14.5,6v3.5c0,0.551-0.448,1-1,1s-1-0.449-1-1V6h-1v3.5c0,1.103,0.897,2,2,2s2-0.897,2-2V6H14.5z" opacity=".07"></path><path d="M35,6v3.5c0,0.276-0.225,0.5-0.5,0.5S34,9.776,34,9.5V6h-2v3.5c0,1.378,1.121,2.5,2.5,2.5 S37,10.878,37,9.5V6H35z" opacity=".05"></path><path d="M35.5,6v3.5c0,0.551-0.448,1-1,1s-1-0.449-1-1V6h-1v3.5c0,1.103,0.897,2,2,2s2-0.897,2-2V6H35.5z" opacity=".07"></path><path fill="#54daff" d="M34.5,11L34.5,11c-0.828,0-1.5-0.672-1.5-1.5v-5C33,3.672,33.672,3,34.5,3l0,0 C35.328,3,36,3.672,36,4.5v5C36,10.328,35.328,11,34.5,11z"></path><path fill="#54daff" d="M13.5,11L13.5,11c-0.828,0-1.5-0.672-1.5-1.5v-5C12,3.672,12.672,3,13.5,3h0 C14.328,3,15,3.672,15,4.5v5C15,10.328,14.328,11,13.5,11z"></path>
	</svg>
);

SettingIcons.academy = (
	<svg width="45" height="45" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
	<path d="M3.57956 14.2103C3.53443 14.2103 3.4893 14.2103 3.46674 14.1877C3.44418 14.1651 3.39905 14.1426 3.35393 14.12C3.33136 14.0974 3.3088 14.0523 3.28624 14.0072C3.26367 13.9621 3.26367 13.9169 3.26367 13.8944V8.77251C3.26367 8.72738 3.26367 8.68226 3.28624 8.65969C3.3088 8.61457 3.33136 8.592 3.35393 8.54688C3.39905 8.52431 3.42161 8.50175 3.46674 8.50175C3.51187 8.47919 3.55699 8.47919 3.57956 8.47919C3.62468 8.47919 3.66981 8.47919 3.69237 8.50175C3.7375 8.52431 3.76006 8.54688 3.80519 8.56944C3.82775 8.592 3.85032 8.63713 3.87288 8.68226C3.89544 8.72738 3.89544 8.77251 3.89544 8.79507V13.9169C3.89544 13.9621 3.89544 14.0072 3.87288 14.0523C3.85032 14.0974 3.85032 14.0974 3.82775 14.12C3.80519 14.1426 3.76006 14.1651 3.71494 14.1877C3.66981 14.2103 3.62468 14.2103 3.57956 14.2103Z" fill="#7B68EE"/>
	<path d="M21.4949 8.02792L13.0788 3.22193C12.4695 2.86092 11.3865 2.90605 10.687 3.31219L2.69964 7.89254C1.97761 8.29868 1.90992 8.88532 2.51913 9.24633L10.9352 14.0298C11.5445 14.3682 12.6275 14.3231 13.327 13.9395L21.3369 9.38171C22.0364 8.97557 22.1041 8.38893 21.4949 8.02792ZM13.9813 8.77251C13.9136 8.88532 13.8233 8.97557 13.7105 9.0207L11.7926 9.9458C11.6798 9.99092 11.567 10.0135 11.4542 10.0135C11.3414 10.0135 11.2286 9.96836 11.1383 9.90067C11.0481 9.83298 10.9578 9.76529 10.9127 9.65247C10.845 9.56222 10.8224 9.4494 10.8224 9.33659V7.44127C10.8224 7.32845 10.845 7.21564 10.9127 7.12538C10.9804 7.03513 11.0481 6.94488 11.1383 6.87719C11.2286 6.8095 11.3414 6.78693 11.4542 6.78693C11.567 6.78693 11.6798 6.8095 11.7926 6.85463L13.688 7.77972C13.8008 7.84741 13.891 7.9151 13.9587 8.02792C14.0264 8.14073 14.0715 8.25355 14.0715 8.38893C14.0715 8.54687 14.049 8.65969 13.9813 8.77251Z" fill="#7B68EE"/>
	<g opacity="0.5">
	<path opacity="0.5" d="M18.9224 17.7978L13.3944 20.9567C13.0785 21.1372 12.8303 20.9567 12.8303 20.528V16.7374C12.8303 16.5343 12.8754 16.3087 12.9883 16.1282C13.1011 15.9477 13.2365 15.7671 13.3944 15.6543L18.8999 12.4955C19.2157 12.315 19.4639 12.4955 19.4639 12.9242V16.7148C19.4639 16.9179 19.4414 17.1435 19.3286 17.324C19.2383 17.5271 19.1029 17.685 18.9224 17.7978Z" fill="#949494"/>
	</g>
	<path d="M16.1696 15.7445L14.545 16.6471C14.4548 16.6922 14.3871 16.6471 14.3871 16.5117C14.3871 16.444 14.4096 16.3989 14.4322 16.3312C14.4548 16.286 14.4999 16.2409 14.545 16.1958L16.1696 15.2933C16.2598 15.2481 16.3275 15.2933 16.3275 15.4286C16.3275 15.4963 16.3275 15.5415 16.2824 15.6091C16.2598 15.6543 16.2373 15.6994 16.1696 15.7445Z" fill="#7B68EE"/>
	<path d="M16.7565 16.6019L14.5679 17.8655C14.4776 17.9106 14.4099 17.8655 14.4099 17.7301C14.4099 17.6624 14.4325 17.6173 14.455 17.5496C14.4776 17.5045 14.5227 17.4593 14.5679 17.4142L16.7791 16.1732C16.8693 16.1281 16.937 16.1732 16.937 16.3086C16.937 16.3763 16.9144 16.4214 16.8919 16.4666C16.8693 16.5342 16.8242 16.5794 16.7565 16.6019Z" fill="#7B68EE"/>
	<path d="M15.222 18.7229L14.5902 19.0839C14.4999 19.1291 14.4323 19.0839 14.4323 18.9486C14.4323 18.8809 14.4548 18.8357 14.4774 18.768C14.4999 18.7229 14.5451 18.6778 14.5902 18.6327L15.222 18.2717C15.3122 18.2265 15.3799 18.2717 15.3799 18.407C15.3799 18.4747 15.3573 18.5198 15.3348 18.5875C15.3122 18.6327 15.2671 18.6778 15.222 18.7229Z" fill="#7B68EE"/>
	<g opacity="0.5">
	<path opacity="0.5" d="M10.5965 20.9567L5.06848 17.7978C4.88797 17.6624 4.75259 17.5045 4.66234 17.324C4.57208 17.1435 4.50439 16.9178 4.50439 16.7148V12.9467C4.50439 12.518 4.75259 12.3375 5.06848 12.518L10.5739 15.6769C10.7544 15.8122 10.8898 15.9702 10.9801 16.1507C11.0703 16.3312 11.138 16.5568 11.138 16.7599V20.528C11.1606 20.9567 10.9124 21.1372 10.5965 20.9567Z" fill="#949494"/>
	</g>
	<path d="M7.86636 15.7671L6.24181 14.8646C6.19668 14.8194 6.15155 14.7743 6.12899 14.7292C6.10643 14.6841 6.08386 14.6164 6.08386 14.5487C6.08386 14.4359 6.15155 14.3682 6.24181 14.4133L7.86636 15.3158C7.91149 15.361 7.95662 15.4061 7.97918 15.4512C8.00174 15.4963 8.02431 15.564 8.02431 15.6317C8.04687 15.7671 7.95662 15.8122 7.86636 15.7671Z" fill="#7B68EE"/>
	<path d="M8.45301 17.324L6.24181 16.083C6.19668 16.0379 6.15155 15.9928 6.12899 15.9476C6.10643 15.9025 6.08386 15.8348 6.08386 15.7671C6.08386 15.6543 6.15155 15.5866 6.24181 15.6317L8.45301 16.8727C8.49814 16.9179 8.54326 16.963 8.56583 17.0081C8.58839 17.0532 8.61095 17.1209 8.61095 17.1886C8.63352 17.324 8.54326 17.3691 8.45301 17.324Z" fill="#7B68EE"/>
	<path d="M6.89604 17.6399L6.26427 17.2788C6.21914 17.2337 6.17401 17.1886 6.15145 17.1435C6.12889 17.0983 6.10632 17.0307 6.10632 16.963C6.10632 16.8501 6.17401 16.7825 6.26427 16.8276L6.89604 17.1886C6.94117 17.2337 6.98629 17.2788 7.00886 17.324C7.03142 17.3691 7.05398 17.4368 7.05398 17.5045C7.05398 17.6399 6.98629 17.7075 6.89604 17.6399Z" fill="#7B68EE"/>
	</svg>

);

SettingIcons.lifterlms = (
	<svg version="1.1" viewBox="0 0 238.17 256" xmlns="http://www.w3.org/2000/svg" width="40" height="40">
		<g transform="matrix(1.25 0 0 1.25 -41.904 -32.607)" fill="#a7aaad">
			<path d="m89.312 154.28-6.883-3.93-18.485 31.852c-16.712-23.201-20.056-54.468-7.078-81.408l0.195-0.197c0.788-1.769 1.771-3.344 2.556-4.915 13.176-22.814 36.185-36.775 60.568-39.33 4.327-5.898 9.047-11.013 14.356-15.928-34.807-1.966-69.615 15.336-88.295 47.589-23.991 41.687-12.977 93.993 23.991 122.71l18.484-54.866c0.199-0.391 0.396-0.983 0.591-1.573m112.48-50.932c9.833 22.617 9.243 49.358-3.933 72.171-0.786 1.574-1.769 3.142-2.752 4.719l-0.198 0.199c-16.91 24.776-45.62 37.556-74.134 34.606l18.486-31.857-6.884-3.934c-0.393 0.398-0.786 0.789-1.18 1.185l-38.149 43.458c43.263 17.699 94.193 0.983 118.18-40.709 18.683-32.245 16.324-70.987-2.947-100.09-1.574 6.88-3.541 13.763-6.491 20.251" />
			<path transform="translate(33.523 26.087)" d="m154.57 0.0039062c-0.4126 0.01533-0.83055 0.071547-1.248 0.16992-4.524 1.182-9.0453 2.7534-13.57 4.5234-18.68 7.472-34.608 19.859-45.816 36.574-7.08 10.62-11.997 22.025-14.947 34.021l-39.129 1.375c-2.756 0-5.1151 1.9667-5.7051 4.7207-0.786 2.752 0.39522 5.3089 2.9492 6.8809l38.543 22.223c-3.342 7.473-2.164 15.926 1.377 23.598 1.18 2.36 3.5397 3.7381 6.0957 3.5391 8.454-0.785 16.32-4.1291 21.238-10.621l38.543 22.223c2.358 1.378 5.3084 1.1808 7.2754-0.78516 2.162-1.967 2.5577-4.9186 1.1797-7.4746l-18.289-34.414c8.848-8.65 16.518-18.482 22.025-29.889 8.65-18.091 11.601-38.147 8.8477-58.207-0.785-4.717-1.7705-9.438-3.1465-13.957-0.68951-2.7545-3.3345-4.6073-6.2227-4.5zm-26.934 42.99c1.9827 0.04978 3.9792 0.57609 5.8223 1.6211 5.899 3.539 7.8654 11.012 4.5234 16.91-3.343 5.9-11.009 7.8674-16.91 4.5234-5.899-3.344-7.8664-11.013-4.5254-16.912 2.4344-4.0556 6.7279-6.2521 11.09-6.1426z" />
			<path d="m80.266 219.76 41.689-47.392c-1.572 0.197-3.146 0.393-4.72 0.59-6.293 0.394-12.192-2.951-14.942-8.847-0.789-1.377-1.379-2.755-1.968-4.328z" />
		</g>
	</svg>
);

export default SettingIcons;