const { __ } = wp.i18n;
import { useZmeetAdmin } from "../../../App/ZmeetAdminContext";
import { langString } from "../../../Helpers";

const MhSwitcher = ({ label, description, checked, onChange, name, disabled, isLocked, isUpcomming = false }) => {
	const { openProModal } = useZmeetAdmin();

	return (
	  <div className="zmeet-form-group">
		<label>
		  {label}
		  {description && <small className="description">{description}</small>}
		</label>
		<div className="input-wrapper">
		  <div className={`zmeet-switch-field ${disabled ? 'disabled' : ''}`}>
			<input
			  type="checkbox"
			  id={name}
			  checked={checked}
			  onChange={() => onChange(name, !checked)}
			  disabled={disabled}
			/>
			<label htmlFor={name} className={`${isLocked ? 'zmeet-locked' : ''}`}  {...(disabled && !isUpcomming && { onClick: openProModal })}></label>

			{ isLocked ? (<span className="zmeet-pro-tag" onClick={openProModal}>{ langString('pro') }</span>) : ''}
			{ isUpcomming ? (<span className="zmeet-upcomming-tag">{ langString('upcomming') }</span>) : ''}

		  </div>
		</div>
	  </div>
	);
};
  
export default MhSwitcher;
  