// MhInput.js
import React from 'react';
const { __ } = wp.i18n;
import { useZmeetAdmin } from "../../../App/ZmeetAdminContext";
import { langString } from '../../../Helpers';

const MhInput = ({ label, description, type, value, onChange, name, required, maxLength, disabled, isLocked }) => {
  const { openProModal } = useZmeetAdmin();
  return (
    <div className="zmeet-form-group">
      <label>
        {label}
        <small className="description">
          {description}
        </small>
      </label>
      <div className="input-wrapper">
        <input
          type={type}
          className={`form-control ${isLocked ? 'zmeet-locked' : ''}`}
          name={name}
          value={value}
          {...(required === "yes" && { required: true })}
          {...(maxLength && { maxLength: maxLength })}
          onChange={(e) => {
            if (maxLength && e.target.value.length > maxLength) {
              return;  // Prevent input if maxLength is exceeded
            }
            onChange(name, e.target.value);
          }}
         disabled={disabled} // Apply the disabled prop here
        />
  
        { disabled && ( <div className="zmeet_disabled" onClick={openProModal}></div>)}
       
        {isLocked ? (<span className="zmeet-pro-tag input-pro" onClick={openProModal}>{langString('pro')}</span>) : ''}
    
      </div>
    </div>
  );
};

export default MhInput;
