import React, { useState, useEffect } from 'react';
import { useZmeetAdmin } from '../../App/ZmeetAdminContext';
import '../../scss/common/_get_pro.scss';
import CountdownTimer from './CountdownTimer';
import { langString } from '../../Helpers';

const GetProModal = () => {
  const { isModalOpen, closeProModal } = useZmeetAdmin();

  const [startTime, setStartTime] = useState('2024-10-21 16:00:00');
  const [endTime, setEndTime] = useState('2024-12-10 24:00:00');
  const [showTimer, setShowTimer] = useState(false);

  // Automatically show timer if the times are valid
  const startCountdown = () => {
    const now = new Date();
    if (new Date(startTime) < new Date(endTime) && now < new Date(endTime)) {
      setShowTimer(true);
    } else {
      setShowTimer(false);
    }
  };

  useEffect(() => {
    startCountdown(); // Start countdown automatically
  }, []);

    const handleCheckout = () => {
    if (typeof zmeetMeetingsData !== 'undefined') {
      // Determine the URL based on is_paying
      const url = zmeetMeetingsData.is_paying
        ? zmeetMeetingsData.pricing_url
        : zmeetMeetingsData.checkout_url;

      if (url) {
        // If it's checkout_url, open in the same tab; otherwise, open in a new tab
        if (zmeetMeetingsData.is_paying) {
          window.open(url, '_blank'); // Open in a new tab
        } else {
          window.location.href = url; // Redirect in the same tab
        }
      } else {
        console.error('URL not available');
      }
    } else {
      console.error('zmeetMeetingsData not defined');
    }
  };


  if (!isModalOpen) return null;


  return (
    <div className="zmeet-modal-overlay" onClick={closeProModal}>
      <div className="zmeet-modal" onClick={e => e.stopPropagation()}>
        <button className="zmeet-modal-close" onClick={closeProModal}>×</button>
        <div className="zmeet-modal-content">
          <h2>Unlock access to all features 🎉</h2>
          
          {showTimer ? (
            <p className='ltd-title' >Black Friday Lifetime Deal</p>
          ) : (
            <p >Don't miss the attractive deal! Grab it fast!</p>
          )}

          {showTimer && (
            <CountdownTimer startTime={startTime} endTime={endTime} />
          )}

          {showTimer ? (
            <button className="zmeet-cta-btn" onClick={handleCheckout}>
              Claim 84% OFF
            </button>
          ) : (
            <button className="zmeet-modal-button" onClick={handleCheckout}>
              Get Premium
            </button>
          )}
  
        </div>
      </div>
    </div>
  );
};

export default GetProModal;

