// ZmeetAdminContext.jsx
import React, { createContext, useContext, useState } from 'react';

// Create a context
const ZmeetAdminContext = createContext();

// Create a provider component
export const ZmeetAdminProvider = ({ children }) => {
  const [isModalOpen, setIsProModalOpen] = useState(false);

  // Updated to use SDK modal instead of React modal
  const openProModal = () => {
    // Call SDK modal if available
    if (window.PromoSDK && window.PromoSDK.Modal) {
      // Get the Zoomeet instance
      const instance = window.PromoSDK.Modal.instances['zoomeet'];
      
      if (instance) {
        window.PromoSDK.Modal.show(instance);
      } 
    } else {
      // Fallback to old modal if SDK not loaded
      setIsProModalOpen(true);
    }
  };
  
  const closeProModal = () => setIsProModalOpen(false);


  const contextValue = {
    isModalOpen,
    openProModal,
    closeProModal,
    // Add other functions here
  };

  return (
    <ZmeetAdminContext.Provider value={contextValue}>
      {children}
    </ZmeetAdminContext.Provider>
  );
};

// Custom hook to use the context
export const useZmeetAdmin = () => useContext(ZmeetAdminContext);
