import React from "react";
import { Route, Routes } from "react-router-dom";
import ZoomSettings from "../components/settings/ZoomSettings";
import "../scss/settings/settings.scss";
import 'react-toastify/dist/ReactToastify.css';
import { ToastContainer, toast } from 'react-toastify';
import { ZmeetAdminProvider } from "./ZmeetAdminContext";
import GetProModal from "../components/common/GetProModal";


import ZmeetNotice from "../components/common/ZmeetNotice";

function SettingsApp() {
  const notices = zmeetMeetingsData.noticeData || [];

  return (
    <>
     <ZmeetAdminProvider>
        <div className="zmeet-admin-settings-container" style={{ padding: '0 20px' }}>
          <ZmeetNotice notices={notices} />
          <Routes>
            <Route path="/" element={<ZoomSettings />} />
          </Routes>
        </div>
        <GetProModal />
      </ZmeetAdminProvider>

      <ToastContainer
        position="top-right"
        autoClose={3000}
        hideProgressBar={false}
        newestOnTop={false}
        closeOnClick
        rtl={false}
        pauseOnFocusLoss
        draggable
        pauseOnHover
        theme="light"
        style={{ marginTop: '30px' }}
      />
    </>
  );
}

export default SettingsApp;