jQuery(document).ready(function($) {
    var meetingStartTime = $(".zmeet_start_time").data("meeting-start-time");
    
    // Check if meeting start time is valid
    if (!meetingStartTime || meetingStartTime === '' || meetingStartTime === 'undefined') {
        return; // Exit if no valid start time
    }
    
    var countdownDate = new Date(meetingStartTime).getTime();
    
    // Check if the date is valid
    if (isNaN(countdownDate)) {
        return; // Exit if invalid date
    }
    
    const strings = zmeettran.strings;

    var countdown = setInterval(function() {
        var now = new Date().getTime();
        var distance = countdownDate - now;

        var days = Math.floor(distance / (1000 * 60 * 60 * 24));
        var hours = Math.floor((distance % (1000 * 60 * 60 * 24)) / (1000 * 60 * 60));
        var minutes = Math.floor((distance % (1000 * 60 * 60)) / (1000 * 60));
        var seconds = Math.floor((distance % (1000 * 60)) / 1000);

        $(".zmeet_start_time").empty(); // Clear existing content

        if (days > 0) {
            var dayLabel = days === 1 ? strings.day : strings.days;
            $(".zmeet_start_time").append('<span class="zmeet-countdown-wrapper"><span class="zmeet-countdown-value">' + days + '</span><span class="zmeet-countdown-label">' + dayLabel + '</span></span>');
        }

        if (hours > 0 || days > 0) {
            var hourLabel = hours === 1 ? strings.hour : strings.hours;
            $(".zmeet_start_time").append('<span class="zmeet-countdown-wrapper"><span class="zmeet-countdown-value">' + hours + '</span><span class="zmeet-countdown-label">' + hourLabel + '</span></span>');
        }

        if (minutes > 0 || hours > 0 || days > 0) {
            var minuteLabel = minutes === 1 ? strings.minute : strings.minutes;
            $(".zmeet_start_time").append('<span class="zmeet-countdown-wrapper"><span class="zmeet-countdown-value">' + minutes + '</span><span class="zmeet-countdown-label">' + minuteLabel + '</span></span>');
        }

        var secondLabel = seconds === 1 ? "Second" : (seconds === 0 ? strings.second : strings.seconds);
        $(".zmeet_start_time").append('<span class="zmeet-countdown-wrapper"><span class="zmeet-countdown-value">' + seconds + '</span><span class="zmeet-countdown-label">' + secondLabel + '</span></span>');

        if (distance < 0) {
            clearInterval(countdown);
            $(".zmeet_start_time").html("");
            $(".zmeet_meeting").show();
            location.reload();
        }
    }, 1000);


    $('.zmeet-usertime').each(function () {
        var date = new Date($(this).data('time'));
        $(this).html(date.toString());
      });
});
