window.$ = window.$ || jQuery;

const ZmeetAdmin = {
    init() {
        this.bindEvents();
        this.changeBackground();
    },

    bindEvents() {
        $(document).on('mouseenter', '.zmeet-rating .rating-wrapper .star', this.handleMouseEnter);
        $(document).on('mouseleave', '.zmeet-rating .rating-wrapper .star', this.handleMouseLeave);
    },

    handleMouseEnter() {
        const ratingStars = $('.zmeet-rating .rating-wrapper .star');
        const index = ratingStars.index(this);

        ratingStars.each(function(i) {
            if (i <= index) {
                $(this).addClass('filled'); // Add filled class to the hovered and previous stars
            }
        });
    },

    handleMouseLeave() {
        $('.zmeet-rating .rating-wrapper .star').removeClass('filled'); // Remove filled class from all stars
    },

    changeBackground() {
        // Check if #wpwrap has the class directly
        const wpwrap = document.getElementById('wpwrap');
        if (wpwrap && wpwrap.classList.contains('zmeet-admin-dasboard-bg')) {
            wpwrap.style.backgroundColor = '#f4f7ff';
            return;
        }
        // If not found, check descendants
        const zmeetAdminDasboardBg = wpwrap ? wpwrap.querySelector('.zmeet-admin-dasboard-bg') : null;
        if (zmeetAdminDasboardBg) {
            wpwrap.style.backgroundColor = '#f4f7ff';
        }
    }
    
};

$(document).ready(function(){
    ZmeetAdmin.init();
});
