<?php
/**
 * Plugin Name: Zippy Message Floating Chat
 * Plugin URI:  https://wordpress.org/plugins/zippy-message-floating-chat/
 * Description: Fastest, zero-JS floating chat button for instant connection. Optimized for Core Web Vitals.
 * Version:     1.3.7
 * Author:      Sapthesh V
 * License:     GPLv2 or later
 * Text Domain: zippy-message-floating-chat
 */

if ( ! defined( 'ABSPATH' ) ) exit;

function zpmfc_register_settings() {
    register_setting( 'zpmfc_settings_group', 'zpmfc_phone', 'sanitize_text_field' );
    register_setting( 'zpmfc_settings_group', 'zpmfc_pos', 'sanitize_text_field' );
    register_setting( 'zpmfc_settings_group', 'zpmfc_color', 'sanitize_hex_color' );
    register_setting( 'zpmfc_settings_group', 'zpmfc_text', 'sanitize_text_field' );
}
add_action( 'admin_init', 'zpmfc_register_settings' );

function zpmfc_add_menu() {
    add_options_page( 
        'Zippy Message Settings', 
        'Zippy Message', 
        'manage_options', 
        'zippy-message-floating-chat', 
        'zpmfc_settings_page' 
    );
}
add_action( 'admin_menu', 'zpmfc_add_menu' );

function zpmfc_settings_page() {
    ?>
    <div class="wrap">
        <h1>Zippy Message Settings</h1>
        <form method="post" action="options.php">
            <?php 
            settings_fields( 'zpmfc_settings_group' );
            do_settings_sections( 'zpmfc_settings_group' );
            ?>
            <table class="form-table">
                <tr><th>Phone Number</th><td><input type="text" name="zpmfc_phone" value="<?php echo esc_attr(get_option('zpmfc_phone')); ?>" placeholder="e.g. 1234567890"></td></tr>
                <tr><th>Tooltip Message</th><td><input type="text" name="zpmfc_text" value="<?php echo esc_attr(get_option('zpmfc_text', 'Chat with us!')); ?>"></td></tr>
                <tr><th>Position</th><td>
                    <select name="zpmfc_pos">
                        <option value="right" <?php selected(get_option('zpmfc_pos'), 'right'); ?>>Right</option>
                        <option value="left" <?php selected(get_option('zpmfc_pos'), 'left'); ?>>Left</option>
                    </select>
                </td></tr>
                <tr><th>Brand Color</th><td><input type="color" name="zpmfc_color" value="<?php echo esc_attr(get_option('zpmfc_color', '#25D366')); ?>"></td></tr>
            </table>
            <?php submit_button(); ?>
        </form>
    </div>
    <?php
}

function zpmfc_enqueue_styles() {
    $phone = preg_replace('/[^0-9]/', '', get_option('zpmfc_phone'));
    if ( ! $phone ) return;

    $color    = get_option('zpmfc_color', '#25D366');
    $pos      = get_option('zpmfc_pos', 'right');
    $side     = ( $pos === 'left' ) ? 'left: 25px;' : 'right: 25px;';
    $tip_side = ( $pos === 'left' ) ? 'left: 75px;' : 'right: 75px;';
    $tooltip  = get_option('zpmfc_text', 'Chat with us!');

    $custom_css = "
        .zpmfc-btn {
            position: fixed; bottom: 25px; $side
            background: " . esc_attr($color) . ";
            width: 60px; height: 60px; border-radius: 50%;
            display: flex; align-items: center; justify-content: center;
            box-shadow: 0 4px 15px rgba(0,0,0,0.2); z-index: 99999;
            transition: transform 0.3s ease;
            animation: zpmfcEntrance 0.6s cubic-bezier(0.17, 0.67, 0.83, 1.2) forwards;
        }
        .zpmfc-btn svg { width: 34px; height: 34px; fill: #fff; }
        .zpy-fl-btn::after, .zpmfc-btn::after {
            content: '" . esc_js($tooltip) . "';
            position: absolute; bottom: 12px; $tip_side
            background: #fff; color: #333; padding: 8px 14px;
            border-radius: 10px; font-size: 14px; font-weight: 600;
            font-family: sans-serif; white-space: nowrap;
            box-shadow: 0 4px 12px rgba(0,0,0,0.1);
            pointer-events: none; opacity: 0; visibility: hidden;
            transition: opacity 0.3s ease, visibility 0.3s ease;
        }
        .zpmfc-btn:hover { transform: scale(1.1); }
        .zpmfc-btn:hover::after { opacity: 1; visibility: visible; }
        @keyframes zpmfcEntrance {
            0% { transform: scale(0) rotate(-45deg); opacity: 0; }
            100% { transform: scale(1) rotate(0); opacity: 1; }
        }
    ";
 
    wp_register_style( 'zpmfc-main-style', false, array(), '1.3.7' );
    wp_enqueue_style( 'zpmfc-main-style' );
    wp_add_inline_style( 'zpmfc-main-style', $custom_css );
}
add_action( 'wp_enqueue_scripts', 'zpmfc_enqueue_styles' );

function zpmfc_output_button() {
    $phone = preg_replace('/[^0-9]/', '', get_option('zpmfc_phone'));
    if ( ! $phone ) return;
    ?>
    <a href="https://wa.me/<?php echo esc_attr($phone); ?>" class="zpmfc-btn" target="_blank" rel="noopener" aria-label="Chat">
        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512"><path d="M380.9 97.1C339 55.1 283.2 32 223.9 32c-122.4 0-222 99.6-222 222 0 39.1 10.2 77.3 29.6 111L0 480l117.7-30.9c32.4 17.7 68.9 27 106.1 27h.1c122.3 0 224.1-99.6 224.1-222 0-59.3-25.2-115-67.1-157zm-157 341.6c-33.2 0-65.7-8.9-94-25.7l-6.7-4-69.8 18.3L72 359.2l-4.4-7c-18.5-29.4-28.2-63.3-28.2-98.2 0-101.7 82.8-184.5 184.6-184.5 49.3 0 95.6 19.2 130.4 54.1 34.8 34.9 56.2 81.2 56.1 130.5 0 101.8-84.9 184.6-186.6 184.6zm101.2-138.2c-5.5-2.8-32.8-16.2-37.9-18-5.1-1.9-8.8-2.8-12.5 2.8-3.7 5.6-14.3 18-17.6 21.8-3.2 3.7-6.5 4.2-12 1.4-5.5-2.8-23.2-8.5-44.2-27.1-16.4-14.6-27.4-32.7-30.6-38.2-3.2-5.6-.3-8.6 2.5-11.3 2.5-2.5 5.5-6.5 8.3-9.7 2.8-3.3 3.7-5.6 5.5-9.3 1.8-3.7.9-6.9-.5-9.7-1.4-2.8-12.5-30.1-17.1-41.2-4.5-10.8-9.1-9.3-12.5-9.5-3.2-.2-6.9-.2-10.6-.2-3.7 0-9.7 1.4-14.8 6.9-5.1 5.6-19.4 19-19.4 46.3 0 27.3 19.9 53.7 22.6 57.4 2.8 3.7 39.1 59.7 94.8 83.8 13.2 5.8 23.5 9.2 31.5 11.8 13.3 4.2 25.4 3.6 35 2.2 10.7-1.5 32.8-13.4 37.4-26.4 4.6-13 4.6-24.1 3.2-26.4-1.3-2.5-5-3.9-10.5-6.6z"/></svg>
    </a>
    <?php
}
add_action( 'wp_footer', 'zpmfc_output_button' );