# WordPress Blocks

A collection of custom Gutenberg blocks designed to extend the WordPress block editor with icons, dynamic data, and flexible content composition.

This project focuses on reusable and composable blocks that integrate naturally with the WordPress editor while remaining developer-friendly.

---

## Included Blocks

### Icon Picker Block

A utility block that allows users to select and insert icons directly into the editor.

**Features**

- Supports Dashicons (WordPress core icons)
- Supports social icons
- Can be reused inside other blocks
- Outputs editor-safe markup compatible with both editor and frontend

**Use cases**

- Buttons
- Feature lists
- Callouts
- Social links

---

### Icon List Block

A flexible list block powered by the Icon Picker.

**Features**

- Add, remove, and reorder list items
- Each list item includes:

  - An Icon Picker
  - A fully insertable inner block
    - Paragraph
    - Heading
    - Meta Field
    - Any other allowed block

- Built using InnerBlocks for maximum flexibility

**Use cases**

- Feature lists
- Services lists
- Benefits sections
- Custom content lists with icons

---

### Meta Field Block

A dynamic block that allows users to insert values from WordPress data sources directly into the editor.

**Features**

- Insert values from:

  - Options table
  - Post meta table

- Dynamic rendering
- Supports return format templates using placeholder tokens
- Works in both editor preview and frontend output

**Use cases**

- Display custom fields
- Output site options such as address or contact information
- Build dynamic layouts without writing PHP templates

---

### WooCommerce Product Add To Cart Block

A customizable block that allows users to insert a WooCommerce **Add to Cart** button directly into the editor, with support for dynamic product data and flexible quantity handling.

**Features**

- Add to cart for:
  - Specific products by ID
  - Current product context (when used on single product templates)
- Optional quantity selector support
- Dynamic data attributes for frontend handling
- Works seamlessly in both editor preview and frontend output
- Compatible with WooCommerce templates and block-based themes

**Use cases**

- Custom product landing pages
- Sales and promotional sections
- Product comparison layouts
- Block-based WooCommerce product templates

### WooCommerce Product Price Block

A dynamic block that renders the WooCommerce product price using native WooCommerce pricing logic.

This block ensures compatibility with simple, variable, and subscription-based products while preserving WooCommerce formatting.

#### Features

- Displays price for:
  - Specific product by ID
  - Current product context (when used on single product templates)
- Dynamic rendering using WooCommerce `get_price_html()` / `price_html`
- Supports:
  - Simple products
  - Variable products (price ranges)
  - Sale pricing
  - Subscription pricing (if WooCommerce Subscriptions is active)
- Editor preview reflects real product pricing
- Preserves WooCommerce markup and CSS compatibility
- Works in Full Site Editing (FSE) templates

#### Use cases

- Custom single product templates
- Product landing pages
- Pricing tables
- Subscription comparison layouts
- Custom WooCommerce layouts without overriding PHP templates

### WooCommerce Product Rating Block

A dynamic block that displays the WooCommerce product star rating with full frontend compatibility.

The block outputs WooCommerce’s native rating HTML to keep styling and structured data consistent.

#### Features

- Displays rating for:
  - Specific product by ID
  - Current product context
- Uses WooCommerce rating HTML output (star markup + accessible text)
- Supports:
  - Star rating visualization
  - Rating count
  - Average rating
- Editor preview displays real rating data
- Compatible with WooCommerce CSS and structured data
- Works in block-based product templates

#### Use cases

- Custom single product templates
- Product grids and listing layouts
- Landing pages
- Product comparison sections
- Highlighting social proof in sales pages

---

## Installation

### Via Composer

```bash
composer require ziorwebdev/wordpress-blocks
```

After installation, the blocks will be available in your project.

---

## License

GPL-2.0-or-later

---

## Author

ZIORWeb.Dev
[https://github.com/ziorwebdev](https://github.com/ziorwebdev)
