<?php
/**
 * Preview Bots tab view with database storage.
 */

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

if ( ! current_user_can( 'manage_options' ) ) {
    return;
}

// Get current settings
$license_status = Zillametrics_Settings::get( 'license_status', '' );
$selected_bot = Zillametrics_Settings::get_selected_bot();
$selected_page = Zillametrics_Settings::get_selected_page();
$available_bots = Zillametrics_Settings::get_available_bots();
?>
<div class="wrap zillametrics-admin zm-preview">
  <div class="zm-hero">
    <h1 class="zm-page-title"><?php esc_html_e( 'Preview Bots', 'zillametrics-chat' ); ?></h1>
    <p class="zm-muted">Select a bot to preview and choose the page you would like to display it on.</p>
    
    <!-- License Status Check -->
    <?php if ( $license_status !== 'valid' ) : ?>
      <div class="notice notice-warning inline" style="margin-bottom: 20px;">
        <p><strong><?php esc_html_e( 'License Required', 'zillametrics-chat' ); ?></strong></p>
        <p><?php esc_html_e( 'Please authenticate your license first to access bot preview options.', 'zillametrics-chat' ); ?></p>
        <p class="zm-lic">
          <a href="<?php echo esc_url( admin_url( 'admin.php?page=zillametrics-license' ) ); ?>" class="button button-primary"><?php esc_html_e( 'Go to License', 'zillametrics-chat' ); ?>
          </a>
       </p>
      </div>
    <?php endif; ?>
    
    <div class="zm-tab">
      <div class="zm-tab-btns">
        <button type="button" class="zm-tab-btn active">Choose Bot</button>
        <button type="button" class="zm-tab-btn">Select Page</button>
      </div>
      <div class="zm-tab-content">
        <!-- Bot Selection Tab -->
        <div class="zm-tab-content-inner active">
          <h4><?php esc_html_e( 'Choose Chat Bot', 'zillametrics-chat' ); ?></h4>
          
          <?php if ( $license_status !== 'valid' ) : ?>
            <p class="zm-muted"><?php esc_html_e( 'Please authenticate your license to see available bots.', 'zillametrics-chat' ); ?></p>
          <?php elseif ( empty( $available_bots ) ) : ?>
            <p class="zm-muted"><?php esc_html_e( 'No bots available. Please check your license or contact support.', 'zillametrics-chat' ); ?></p>
          <?php else : ?>
            <div class="bot-selection-container">
              <div class="dropdown" id="bot-dropdown">
                <button class="dropdown-btn" id="bot-dropdown-btn">
                  <span class="btn-text">
                    <?php echo ! empty( $selected_bot ) ? esc_html( $selected_bot['bot_name'] ) : esc_html__( 'Select Bot', 'zillametrics-chat' ); ?>
                  </span>
                  <span class="dropdown-arrow">▼</span>
                </button>
                <div class="dropdown-menu" id="bot-dropdown-menu">
                  <?php foreach ( $available_bots as $bot ) : ?>
                    <div class="dropdown-item bot-item" data-bot-id="<?php echo esc_attr( $bot['id'] ); ?>" data-bot-name="<?php echo esc_attr( $bot['bot_name'] ); ?>" data-bot-domain="<?php echo esc_attr( $bot['chat_domain'] ); ?>">
                      <div class="bot-name"><?php echo esc_html( $bot['bot_name'] ); ?></div>
                      <div class="bot-description"><?php echo esc_html( $bot['chat_domain'] ); ?></div>
                    </div>
                  <?php endforeach; ?>
                </div>
              </div>
              
              <?php if ( ! empty( $selected_bot ) ) : ?>
              <div class="selected-bot-info">
                <h5><?php esc_html_e( 'Selected Bot', 'zillametrics-chat' ); ?></h5>
                <p><strong><?php echo esc_html( $selected_bot['bot_name'] ); ?></strong></p>
                <?php if ( ! empty( $selected_bot['chat_domain'] ) ) : ?>
                  <p class="zm-muted"><?php echo esc_html( $selected_bot['chat_domain'] ); ?></p>
                <?php endif; ?>
              </div>
              <?php endif; ?>
            </div>
          <?php endif; ?>
        </div>
        
        <!-- Page Selection Tab -->
        <div class="zm-tab-content-inner">
          <h4><?php esc_html_e( 'Select Display Page', 'zillametrics-chat' ); ?></h4>
          <?php if ( $license_status !== 'valid' ) : ?>
            <p class="zm-muted"><?php esc_html_e( 'Please authenticate your license to select a page for preview.', 'zillametrics-chat' ); ?></p>
          <?php else : ?>
          <div class="page-selection-container">
            <div class="dropdown" id="pages-dropdown">
              <button class="dropdown-btn" id="pages-dropdown-btn">
                <span class="btn-text">
                  <?php echo ! empty( $selected_page ) && ! empty( $selected_page['title'] ) ? esc_html( $selected_page['title'] ) : esc_html__( 'Select Page', 'zillametrics-chat' ); ?>
                </span>
                <span class="loading-spinner" style="display: none; margin-left: 8px;">Loading...</span>
                <span class="dropdown-arrow">▼</span>
              </button>
              <div class="dropdown-menu" id="pages-dropdown-menu">
                <div class="dropdown-item loading-item" style="display: none;">Loading...</div>
                <div class="dropdown-item no-pages-item" style="display: none;"><?php esc_html_e( 'No pages found', 'zillametrics-chat' ); ?></div>
              </div>
            </div>

            <?php if ( ! empty( $selected_page ) && ! empty( $selected_page['title'] ) ) : ?>
            <div class="selected-page-info">
              <h5><?php esc_html_e( 'Selected Page', 'zillametrics-chat' ); ?></h5>
              <p><strong><?php echo esc_html( $selected_page['title'] ); ?></strong></p>
              <?php if ( ! empty( $selected_page['url'] ) ) : ?>
                <p class="zm-muted"><?php echo esc_url( $selected_page['url'] ); ?></p>
              <?php endif; ?>
            </div>
            <?php endif; ?>
          </div>
          <?php endif; ?>
        </div>
      </div>
      
    </div>
    
    <!-- Preview Actions -->
    <div class="zm-preview-actions" style="margin-top: 20px;">
      <?php 
        $has_bot = ! empty( $selected_bot ) && ! empty( $selected_bot['id'] );
        $has_page = ! empty( $selected_page ) && ! empty( $selected_page['url'] );
        $button_disabled = ( $license_status !== 'valid' ) || ! $has_bot || ! $has_page;
      ?>
      <button id="view-preview-btn" class="button button-primary" <?php disabled( $button_disabled ); ?>>
        <?php esc_html_e( 'View Preview', 'zillametrics-chat' ); ?>
      </button>
      <span class="zm-muted" style="margin-left: 10px;">
        <?php esc_html_e( 'Opens the selected page with the chosen bot in preview mode.', 'zillametrics-chat' ); ?>
      </span>
    </div>
    
    <!-- Message Container -->
    <div id="zillametrics-preview-message-container" style="margin-top: 20px;"></div>
    
    <div class="zm-how-box">
      <h4><?php esc_html_e( 'How it works', 'zillametrics-chat' ); ?></h4>
      <p><?php esc_html_e( 'Select a bot and page to preview how the bot will appear on your website. Your selections are automatically saved.', 'zillametrics-chat' ); ?></p>
    </div>
  </div>
</div>
<!-- Inline styles and scripts have been moved to admin.css and admin.js for proper enqueuing -->
<!-- PHP data is now passed to JavaScript via wp_localize_script in the admin class -->
