<?php
/**
 * Combined License + Preview settings view.
 */

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( ! current_user_can( 'manage_options' ) ) {
	return;
}

$license      = Zillametrics_Settings::get( 'license_key', '' );
$licenseStatus = Zillametrics_Settings::get( 'license_status', '' );
$licenseData   = Zillametrics_Settings::get( 'license_data', array() );
$selectedBot   = Zillametrics_Settings::get_selected_bot();
$selectedPage  = Zillametrics_Settings::get_selected_page();
$availableBots = Zillametrics_Settings::get_available_bots();
?>
<div class="wrap zillametrics-admin zm-lic <?php echo $licenseStatus === 'valid' ? '' : 'zm-welcome-active'; ?>">
	<!-- About section (always at top; hidden when license active) -->
	<div id="zillametrics-about-wrapper" style="<?php echo $licenseStatus === 'valid' ? 'display:none;' : ''; ?>">
		<div class="zm-hero zm-about-card">
			<h1 class="zm-about-title"><?php esc_html_e( 'Welcome to Zillametrics Chat!', 'zillametrics-chat' ); ?></h1>
			<h2 class="zm-about-subtitle"><?php esc_html_e( 'About Plugin', 'zillametrics-chat' ); ?></h2>
			<p class="zm-about-desc"><?php esc_html_e( 'ZillaMetrics Chat is a powerful customer engagement solution that seamlessly integrates with WordPress. It enables website owners and businesses to connect with visitors in real time, provide instant support, and build stronger customer relationships. With its intuitive setup and smooth integration, the plugin helps you deliver a better user experience and boost engagement—directly from your WordPress site.', 'zillametrics-chat' ); ?></p>

			<div class="zm-about-ctas">
				<div class="zm-about-panel">
					<h3 class="zm-about-panel-title"><?php esc_html_e( 'Have a license already?', 'zillametrics-chat' ); ?></h3>
					<a class="button button-primary zm-big-btn" id="enter-license-btn" href="#zillametrics-settings-section">
						<?php esc_html_e( 'Enter License Key', 'zillametrics-chat' ); ?>
					</a>
				</div>
				<div class="zm-about-panel">
					<h3 class="zm-about-panel-title"><?php esc_html_e( 'New to ZillaMetrics Chat?', 'zillametrics-chat' ); ?></h3>
					<a class="button button-primary zm-big-btn" href="https://zillametrics.com/chat" target="_blank" rel="noopener noreferrer">
						<?php esc_html_e( 'Get Free License', 'zillametrics-chat' ); ?>
					</a>
				</div>
			</div>
		</div>
	</div>

	<!-- Settings section (license + preview). Hidden until user clicks Enter License when invalid) -->
	<div id="zillametrics-settings-section" style="<?php echo $licenseStatus === 'valid' ? '' : 'display:none;'; ?>">
		<div class="zm-hero">
			<h2 class="zm-page-title"><?php esc_html_e( 'Zillametrics Chat Settings', 'zillametrics-chat' ); ?></h2>
			<p class="zm-muted"><?php esc_html_e( 'Add or deactivate license. When active, choose a bot and a page to preview.', 'zillametrics-chat' ); ?></p>

			<!-- License Status Display -->
			<div id="zillametrics-license-status" class="license-status" style="margin-bottom: 20px;">
				<?php if ( $licenseStatus === 'valid' && ! empty( $licenseData ) ) : ?>
					<div class="notice notice-success inline">
						<p><strong><?php esc_html_e( 'License Status: Active', 'zillametrics-chat' ); ?></strong></p>
						<?php if ( isset( $licenseData['plan'] ) ) : ?>
							<?php /* translators: %s: License plan name */ ?>
							<p><?php printf( esc_html__( 'Plan: %s', 'zillametrics-chat' ), esc_html( $licenseData['plan'] ) ); ?></p>
						<?php endif; ?>
						<?php if ( isset( $licenseData['expires_at'] ) ) : ?>
							<?php /* translators: %s: License expiration date */ ?>
							<p><?php printf( esc_html__( 'Expires: %s', 'zillametrics-chat' ), esc_html( gmdate( 'F j, Y', strtotime( $licenseData['expires_at'] ) ) ) ); ?></p>
						<?php endif; ?>
					</div>
				<?php elseif ( $licenseStatus === 'invalid' && ! empty( $license ) ) : ?>
					<div class="notice notice-error inline">
						<p><strong><?php esc_html_e( 'License Status: Invalid', 'zillametrics-chat' ); ?></strong></p>
					</div>
				<?php endif; ?>
			</div>

			<!-- License Form -->
			<form id="zillametrics-license-form">
				<table class="form-table" role="presentation">
					<tr>
						<th scope="row"><label for="zillametrics_license"><?php esc_html_e( 'License Key', 'zillametrics-chat' ); ?></label></th>
					</tr>
					<tr>
						<td>
							<input name="zillametrics_license" id="zillametrics_license" type="text" class="regular-text" value="<?php echo esc_attr( $license ); ?>" placeholder="<?php esc_attr_e( 'Add license key here', 'zillametrics-chat' ); ?>" />
							<p class="description"><?php esc_html_e( 'No license?', 'zillametrics-chat' ); ?> <a href="https://zillametrics.com/chat/" target="_blank" rel="noopener noreferrer"><?php esc_html_e( 'Click here', 'zillametrics-chat' ); ?></a> <?php esc_html_e( 'to get your free license key', 'zillametrics-chat' ); ?></p>
						</td>
						<td>
							<p>
								<button type="submit" id="zillametrics-save-license" class="button button-primary">
									<span class="button-text"><?php esc_html_e( 'Save License', 'zillametrics-chat' ); ?></span>
									<span class="spinner" style="display: none; float: none; margin: 0 5px;"></span>
								</button>
								<button type="button" id="zillametrics-deactivate-license" class="button zm-button-secondary" style="margin-left:8px; border-color:#cc4b37; color:#cc4b37; background:#fff; <?php echo $licenseStatus === 'valid' ? '' : 'display:none;'; ?>">
									<?php esc_html_e( 'Deactivate License', 'zillametrics-chat' ); ?>
								</button>
							</p>
						</td>
					</tr>
				</table>
			</form>

			<!-- Message Container -->
			<div id="zillametrics-message-container" style="margin-top: 20px;"></div>
		</div>

		<!-- Preview (only when license valid; wrapper toggled separately) -->
		<div id="zillametrics-preview-wrapper" style="<?php echo $licenseStatus === 'valid' ? '' : 'display:none;'; ?>">
			<hr style="margin:24px 0;width: 114%;max-width: 969px;">
			<div class="zm-preview">
				<h2 class="zm-page-title"><?php esc_html_e( 'Preview Bots', 'zillametrics-chat' ); ?></h2>
				<p class="zm-muted"><?php esc_html_e( 'Select a bot to preview and choose the page you would like to display it on.', 'zillametrics-chat' ); ?></p>

				<div class="zm-tab">
					<div class="zm-tab-btns">
						<button type="button" class="zm-tab-btn active"><?php esc_html_e( 'Choose Bot', 'zillametrics-chat' ); ?></button>
						<button type="button" class="zm-tab-btn"><?php esc_html_e( 'Select Page', 'zillametrics-chat' ); ?></button>
					</div>
					<div class="zm-tab-content">
						<!-- Bot Selection Tab -->
						<div class="zm-tab-content-inner active">
							<h4><?php esc_html_e( 'Choose Chat Bot', 'zillametrics-chat' ); ?></h4>
							<?php if ( empty( $availableBots ) ) : ?>
								<p class="zm-muted"><?php esc_html_e( 'No bots available. Please check your license or contact support.', 'zillametrics-chat' ); ?></p>
							<?php else : ?>
								<div class="bot-selection-container">
									<div class="dropdown" id="bot-dropdown">
										<button class="dropdown-btn" id="bot-dropdown-btn">
											<span class="btn-text">
												<?php echo ! empty( $selectedBot ) ? esc_html( $selectedBot['bot_name'] ) : esc_html__( 'Select Bot', 'zillametrics-chat' ); ?>
											</span>
											<span class="dropdown-arrow">▼</span>
										</button>
										<div class="dropdown-menu" id="bot-dropdown-menu">
											<?php foreach ( $availableBots as $bot ) : ?>
												<div class="dropdown-item bot-item" data-bot-id="<?php echo esc_attr( $bot['id'] ); ?>" data-bot-name="<?php echo esc_attr( $bot['bot_name'] ); ?>" data-bot-domain="<?php echo esc_attr( $bot['chat_domain'] ); ?>">
													<div class="bot-name"><?php echo esc_html( $bot['bot_name'] ); ?></div>
													<div class="bot-description"><?php echo esc_html( $bot['chat_domain'] ); ?></div>
												</div>
											<?php endforeach; ?>
										</div>
									</div>
									<?php if ( ! empty( $selectedBot ) ) : ?>
									<div class="selected-bot-info">
										<h5><?php esc_html_e( 'Selected Bot', 'zillametrics-chat' ); ?></h5>
										<p><strong><?php echo esc_html( $selectedBot['bot_name'] ); ?></strong></p>
										<?php if ( ! empty( $selectedBot['chat_domain'] ) ) : ?>
											<p class="zm-muted"><?php echo esc_html( $selectedBot['chat_domain'] ); ?></p>
										<?php endif; ?>
									</div>
									<?php endif; ?>
								</div>
							<?php endif; ?>
						</div>

						<!-- Page Selection Tab -->
						<div class="zm-tab-content-inner">
							<h4><?php esc_html_e( 'Select Display Page', 'zillametrics-chat' ); ?></h4>
							<div class="page-selection-container">
								<div class="dropdown" id="pages-dropdown">
									<button class="dropdown-btn" id="pages-dropdown-btn">
										<span class="btn-text">
											<?php echo ! empty( $selectedPage ) && ! empty( $selectedPage['title'] ) ? esc_html( $selectedPage['title'] ) : esc_html__( 'Select Page', 'zillametrics-chat' ); ?>
										</span>
										<span class="loading-spinner" style="display: none; margin-left: 8px;">Loading...</span>
										<span class="dropdown-arrow">▼</span>
									</button>
									<div class="dropdown-menu" id="pages-dropdown-menu">
										<div class="dropdown-item loading-item" style="display: none;">Loading...</div>
										<div class="dropdown-item no-pages-item" style="display: none;"><?php esc_html_e( 'No pages found', 'zillametrics-chat' ); ?></div>
									</div>
								</div>

								<?php if ( ! empty( $selectedPage ) && ! empty( $selectedPage['title'] ) ) : ?>
								<div class="selected-page-info">
									<h5><?php esc_html_e( 'Selected Page', 'zillametrics-chat' ); ?></h5>
									<p><strong><?php echo esc_html( $selectedPage['title'] ); ?></strong></p>
									<?php if ( ! empty( $selectedPage['url'] ) ) : ?>
										<p class="zm-muted"><?php echo esc_url( $selectedPage['url'] ); ?></p>
									<?php endif; ?>
								</div>
								<?php endif; ?>
							</div>
						</div>
					</div>
				</div>

				<!-- Preview Actions -->
				<div class="zm-preview-actions" style="margin-top: 20px;">
					<?php 
						$hasBot = ! empty( $selectedBot ) && ! empty( $selectedBot['id'] );
						$hasPage = ! empty( $selectedPage ) && ! empty( $selectedPage['url'] );
						$buttonDisabled = ! $hasBot || ! $hasPage;
					?>
					<button id="view-preview-btn" class="button button-primary" <?php disabled( $buttonDisabled ); ?>>
						<?php esc_html_e( 'View Preview', 'zillametrics-chat' ); ?>
					</button>
					<span class="zm-muted" style="margin-left: 10px;">
						<?php esc_html_e( 'Opens the selected page with the chosen bot in preview mode.', 'zillametrics-chat' ); ?>
					</span>
				</div>
			</div>
		</div>
	</div>
</div>
<!-- Inline styles and scripts have been moved to admin.css and admin.js for proper enqueuing -->
<!-- PHP data is now passed to JavaScript via wp_localize_script in the admin class -->