<?php
/**
 * About / Welcome screen.
 *
 * Edit the markup below to match your design content.
 */

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
?>
<div class="wrap zillametrics-admin">
  <div class="zm-hero">
    <h1><?php esc_html_e( 'Welcome to Zillametrics Chat!', 'zillametrics-chat' ); ?></h1>
    <span class="zm-sub-heading">About Plugin</span>
    <p class="zm-muted"><?php esc_html_e( 'Zillametrics is an advanced analytics and optimization platform designed to help website owners, marketers, and businesses make data-driven decisions. Our tool integrates seamlessly with WordPress, providing real-time insights, performance metrics, and actionable recommendations—all from a single, easy-to-use dashboard.', 'zillametrics-chat' ); ?></p>
    <div class="zm-columns">
    <div class="zm-card">
      <h2><?php esc_html_e( 'Have a license already?', 'zillametrics-chat' ); ?></h2>
      <a class="zm-button" href="<?php echo esc_url( admin_url( 'admin.php?page=zillametrics-license' ) ); ?>">
        <?php esc_html_e( 'Enter License Key', 'zillametrics-chat' ); ?>
      </a>
    </div>
    <div class="zm-card">
      <h2><?php esc_html_e( 'New to Zillametrics Chat?', 'zillametrics-chat' ); ?></h2>
      <a class="zm-button" href="https://zillametrics.com/chat" target="_blank" rel="noopener noreferrer">
        <?php esc_html_e( 'Get Free License', 'zillametrics-chat' ); ?>
      </a>
    </div>
  </div>
  </div>
</div>