<?php

/**
 * Plugin Name: ZeroV99 Shipment Tracking
 * Plugin URI:  https://0v99.com/plugins/shipment-tracking
 * Description: Add a 'Shipped' status to WooCommerce orders, track shipments, and provide real-time updates to customers effortlessly.
 * Version: 1.0.3
 * Requires at least: 5.6
 * Requires PHP: 7.4
 * Author: 0v99
 * Author URI: https://0v99.com
 * License: GPL-2.0+
 * License URI: https://www.gnu.org/licenses/gpl-2.0.html
 * Text Domain: zerov99-shipment-tracking
 * Domain Path: /languages
 * Requires Plugins:  woocommerce                                                                                                                    
 */

if (!defined('ABSPATH')) {
    exit;
}                                                              

if (!in_array('woocommerce/woocommerce.php', apply_filters('active_plugins', get_option('active_plugins')))) {
    add_action('admin_notices', function () {
        echo '<div class="notice notice-error is-dismissible">
                <p>' . esc_html__('Please activate WooCommerce Plugin', 'zerov99-shipment-tracking') . '</p>
              </div>';
    });
    return;
}

// Autoload classes
$autoloader = plugin_dir_path(__FILE__) . 'vendor/autoload.php';
if (file_exists($autoloader)) {
    require_once $autoloader;
} else {
    add_action('admin_notices', function () {
        echo "<div class='notice notice-error is-dismissible'>
                <p>" . esc_html__('Autoloader file is missing. Please reinstall the plugin.', 'zerov99-shipment-tracking') . "</p>
              </div>";
    });
    return; 
}

// Inizialitates the plugin
ZeroV99\ShipmentTracking\ZeroV99_Shipment_Tracking::init();
