<?php

/**
 * Uninstall script for the plugin.
 *
 * @package zerov99-SHIPMENT-TRACKING
 */

defined('WP_UNINSTALL_PLUGIN') || exit;


if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly


// Load plugin constants
require_once __DIR__ . '/includes/helpers/ZeroV99_Shipment_Tracking_Config.php';

use ZeroV99\ShipmentTracking\helpers\ZeroV99_Shipment_Tracking_Config;


// Check if plugin data should be deleted
$delete_plugin_data = get_option(ZeroV99_Shipment_Tracking_Config::OPTION_DELETE_PLUGIN_DATA);

if ($delete_plugin_data === 'yes') {
    global $wpdb;

    // 1. Completely remove scheduled tasks (future and historical)
    $deleted_rows = $wpdb->query(
        $wpdb->prepare(
            "DELETE FROM {$wpdb->prefix}actionscheduler_actions WHERE hook = %s",
            ZeroV99_Shipment_Tracking_Config::TASK_AUTO_COMPLETE_SHIPPED_ORDERS
        )
    );

    // 2. Deleted pluign related logs in actionscheduler_logs
    $deleted_scheduler_logs = $wpdb->query(
        $wpdb->prepare(
            "DELETE FROM {$wpdb->prefix}actionscheduler_logs 
        WHERE message LIKE %s",
            '%zerov99%'
        )
    );

    // 3. Check and delete custom metadata 
    $meta_keys_to_delete = array(
        ZeroV99_Shipment_Tracking_Config::META_WAS_SHIPPED_BEFORE_DEACTIVATION,
        ZeroV99_Shipment_Tracking_Config::META_ORDER_PICKED_UP,
        ZeroV99_Shipment_Tracking_Config::META_TRACKING_CODE,
        ZeroV99_Shipment_Tracking_Config::META_CARRIER_NAME,
        ZeroV99_Shipment_Tracking_Config::META_CARRIER_WEBSITE,
        ZeroV99_Shipment_Tracking_Config::META_PICKUP_DATE,
        ZeroV99_Shipment_Tracking_Config::META_SEND_EMAIL,
        ZeroV99_Shipment_Tracking_Config::META_LAST_SHIPPED_DATE,
    );

    $orders = wc_get_orders(array(
        'limit' => -1,
        'return' => 'ids',
    ));

    foreach ($orders as $order_id) {
        $order = wc_get_order($order_id);
        foreach ($meta_keys_to_delete as $meta_key) {
            $order->delete_meta_data($meta_key);
        }
        $order->save();
    }

    // 4. Check and delete order notes related to "Shipped" if they exist
    $deleted_comments = $wpdb->query(
        $wpdb->prepare(
            "DELETE FROM {$wpdb->comments} WHERE comment_type = %s AND comment_content LIKE %s",
            'order_note',
            '%Shipped%'
        )
    );

    // 5. Check and delete plugin options only if they exist
    $options_to_delete = array(
        ZeroV99_Shipment_Tracking_Config::OPTION_ENABLE_SHIPPED_STATUS,
        ZeroV99_Shipment_Tracking_Config::OPTION_SHIPPED_LABEL_COLOR,
        ZeroV99_Shipment_Tracking_Config::OPTION_SHIPPING_PROVIDERS,
        ZeroV99_Shipment_Tracking_Config::OPTION_ENABLE_AUTO_COMPLETE,
        ZeroV99_Shipment_Tracking_Config::OPTION_AUTO_COMPLETE_DAYS,
        ZeroV99_Shipment_Tracking_Config::OPTION_DELETE_PLUGIN_DATA,
        ZeroV99_Shipment_Tracking_Config::OPTION_SEND_EMAIL
    );

    foreach ($options_to_delete as $option) {
        if (false !== get_option($option)) { // Only delete if the option exists
            delete_option($option);
        }
    }

    // Clear WordPress cache to ensure data removal is reflected
    wp_cache_flush();
}
