<?php
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly
?>

<h2><?php esc_html_e('Tracking Details', 'zerov99-shipment-tracking'); ?></h2>
<table class="woocommerce-table woocommerce-table--order-details shop_table order_details tracking-details-table">
    <tbody>
        <tr>
            <th><?php esc_html_e('Carrier:', 'zerov99-shipment-tracking'); ?></th>
            <td><?php echo esc_html($carrier_name); ?></td>
        </tr>
        <tr>
            <th><?php esc_html_e('Tracking Code:', 'zerov99-shipment-tracking'); ?></th>
            <td><?php echo esc_html($tracking_code); ?></td>
        </tr>
        <tr>
            <th><?php esc_html_e('Pick-up Date:', 'zerov99-shipment-tracking'); ?></th>
            <td><?php echo esc_html(date_i18n(get_option('date_format'), strtotime($pickup_date))); ?></td>
        </tr>
        <tr>
            <th><?php esc_html_e('Tracking URL:', 'zerov99-shipment-tracking'); ?></th>
            <td>
                <a href="<?php echo esc_url($carrier_website); ?>" target="_blank"><?php esc_html_e('Track your order', 'zerov99-shipment-tracking'); ?></a>
            </td>
        </tr>
    </tbody>
</table>


