<?php
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly
?>

<!DOCTYPE html>
<html lang="<?php echo esc_attr(get_locale()); ?>">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo esc_html(get_bloginfo('name')); ?></title>
   <style type="text/css">
        @media screen and (max-width: 600px) {
            #header_wrapper {
                padding: 27px 36px !important;
                font-size: 24px;
            }

            #body_content_inner {
                font-size: 10px !important;
            }
        }
    </style> 
</head>

<body style="background-color: <?php echo esc_attr($body_background_color); ?>; text-align: center;">
    <table width="100%" id="outer_wrapper" style="background-color: <?php echo esc_attr($body_background_color); ?>;">
        <tr>
            <td></td>
            <td width="600">
                <div id="wrapper" style="margin: 0 auto; padding: 70px 0; width: 100%; max-width: 600px;">
                    <table width="100%" id="template_container" style="background-color: #fff; border: 1px solid #dedede; box-shadow: 0 1px 4px rgba(0,0,0,.1); border-radius: 3px;">
                        <tr>
                            <td>
                                <!-- Header -->
                                <table width="100%" id="template_header" style="background-color: <?php echo esc_attr($base_color); ?>; color: #fff; padding: 36px 48px;">
                                    <tr>
                                        <td id="header_wrapper">
                                            <?php if (!empty($header_image)) {
                                                echo wp_get_attachment_image(
                                                    attachment_url_to_postid($header_image),
                                                    'full',
                                                    false,
                                                    ['style' => 'max-width:100%; height:auto;', 'alt' => esc_attr(get_bloginfo('name'))]
                                                );
                                            }
                                            ?>
                                            <h1 style="font-size: 30px; font-weight: 300; color: #fff;"><?php esc_html_e('Your order has been shipped!', 'zerov99-shipment-tracking'); ?></h1>
                                        </td>
                                    </tr>
                                </table>
                                <!-- End Header -->
                            </td>
                        </tr>
                        <tr>
                            <td>
                                <!-- Body -->
                                <table width="100%" id="template_body">
                                    <tr>
                                        <td id="body_content" style="background-color: #fff;">
                                            <table width="100%" cellpadding="20">
                                                <tr>
                                                    <td id="body_content_inner" style="color: <?php echo esc_attr($body_text_color); ?>; font-size: 14px; text-align: left;">
                                                        <p><?php echo esc_html($greeting); ?></p>
                                                        <p><?php esc_html_e('We are pleased to inform you that your order has been shipped. Below are the details:', 'zerov99-shipment-tracking'); ?></p>
                                                        <table cellspacing="0" cellpadding="6" border="1" style="width:100%; border: 1px solid #e5e5e5;">
                                                            <tr>
                                                                <th><?php esc_html_e('Order ID', 'zerov99-shipment-tracking'); ?></th>
                                                                <td><?php echo esc_html($order_id); ?></td>
                                                            </tr>
                                                            <tr>
                                                                <th><?php esc_html_e('Carrier', 'zerov99-shipment-tracking'); ?></th>
                                                                <td><?php echo esc_html($carrier_name); ?></td>
                                                            </tr>
                                                            <tr>
                                                                <th><?php esc_html_e('Tracking Code', 'zerov99-shipment-tracking'); ?></th>
                                                                <td><?php echo esc_html($tracking_code); ?></td>
                                                            </tr>
                                                            <tr>
                                                                <th><?php esc_html_e('Pick-up Date:', 'zerov99-shipment-tracking'); ?></th>
                                                                <td><?php echo esc_html(date_i18n(get_option('date_format'), strtotime($pickup_date))); ?></td>
                                                            </tr>
                                                            <tr>
                                                                <th><?php esc_html_e('Tracking URL', 'zerov99-shipment-tracking'); ?></th>
                                                                <td><a href="<?php echo esc_url($carrier_web); ?>" style="color: <?php echo esc_attr($base_color); ?>; text-decoration:underline;"><?php esc_html_e('Track your order', 'zerov99-shipment-tracking'); ?></a></td>
                                                            </tr>
                                                        </table>
                                                        <p><?php esc_html_e('Thank you for shopping with us!', 'zerov99-shipment-tracking'); ?></p>
                                                    </td>
                                                </tr>
                                            </table>
                                        </td>
                                    </tr>
                                </table>
                                <!-- End Body -->
                            </td>
                        </tr>
                        <tr>
                            <td>
                                <!-- Footer -->
                                <table width="100%" id="template_footer" style="background-color: <?php echo esc_attr($body_background_color); ?>; border-top: 1px solid #dedede; color: <?php echo esc_attr($footer_text_color); ?>; padding: 20px 48px;">
                                    <tr>
                                        <td id="footer_content" style="text-align: center; font-size: 12px;">
                                            <?php echo wp_kses_post($footer_text); ?>
                                        </td>
                                    </tr>
                                </table>
                                <!-- End Footer -->
                            </td>
                        </tr>
                    </table>
                </div>
            </td>
            <td></td>
        </tr>
    </table>
</body>

</html>