<?php
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly
?>

<tr valign="top">
    <th scope="row" class="titledesc">
        <label><?php echo esc_html($value['name']); ?></label>
    </th>
    <td class="forminp">
        <table class="widefat wc_input_table sortable" cellspacing="0">
            <thead>
                <tr>
                    <th style="width: 25%;"><?php esc_html_e('Provider Name', 'zerov99-shipment-tracking'); ?></th>
                    <th><?php esc_html_e('Tracking URL', 'zerov99-shipment-tracking'); ?>
                        <div class="zerov99-url-tooltip-container">
                            <span class="zerov99-url-tooltip-icon">?</span>
                            <span class="zerov99-url-tooltip-text">
                            <?php 
                                    echo wp_kses_post(
                                        __(
                                            'To correctly enter the tracking URL, you have two options.<br> The first option is to enter the URL with the associated tracking number. If you choose this option, you must replace the tracking number with the placeholder {tracking_code}.<br> The second option is the general tracking URL of the selected provider.<br><br> Example 1: https://www.dhl.com/us-en/home/tracking.html?tracking-id={tracking_code}<br><br> Example 2: https://www.dhl.com/us-en/home/tracking.html',
                                            'zerov99-shipment-tracking'
                                        )
                                    );
                                ?>
                            </span>
                        </div>
                    </th>
                </tr>
            </thead>
            <tbody class="zerov99-providers">
                <?php if (! empty($providers)) : ?>
                    <?php foreach ($providers as $index => $provider) : ?>
                        <tr class="zerov99-provider">
                            <td>
                                <input type="text" value="<?php echo esc_attr($provider['name']); ?>" name="zerov99_shipping_providers_name[<?php echo esc_attr($index); ?>]"  />
                            </td>
                            <td>
                                <input type="text" value="<?php echo esc_attr($provider['url']); ?>" name="zerov99_shipping_providers_url[<?php echo esc_attr($index); ?>]"  />
                            </td>
                        </tr>
                    <?php endforeach; ?>
                <?php endif; ?>
            </tbody>
            <tfoot>
                <tr>
                    <th colspan="3">
                        <a href="#" class="add button"><?php esc_html_e('+ Add Provider', 'zerov99-shipment-tracking'); ?></a>
                        <a href="#" class="remove_rows button"><?php esc_html_e('Remove selected provider(s)', 'zerov99-shipment-tracking'); ?></a>
                    </th>
                </tr>
            </tfoot>
        </table>
    </td>
</tr>