<?php
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly
?>

<div id="zerov99_order_tracking_modal" class="zerov99-tracking-modal-overlay" style="display: none;">
    <div class="zerov99-tracking-modal">
        <h2><?php esc_html_e('Order Tracking Details', 'zerov99-shipment-tracking'); ?></h2>
        <form  id="zerov99_tracking_form" data-nonce="<?php echo esc_attr(wp_create_nonce('zerov99_save_tracking_nonce')); ?>">
            <div class="zerov99-tracking-field">
                <label><?php esc_html_e('Carrier Name:', 'zerov99-shipment-tracking'); ?></label>
                <select id="zerov99_modal_carrier_name" name="zerov99_modal_carrier_name" required>
                    <option value=""><?php esc_html_e('Select a provider', 'zerov99-shipment-tracking'); ?></option>
                    <?php
                    $providers = get_option('zerov99_shipping_providers', []);
                    if (!empty($providers)) {
                        foreach ($providers as $provider) {
                            echo '<option value="' . esc_attr($provider['name']) . '">' . esc_html($provider['name']) . '</option>';
                        }
                    }
                    ?>
                </select>
            </div>

            <div class="zerov99-tracking-field">
                <label><?php esc_html_e('Tracking Code:', 'zerov99-shipment-tracking'); ?></label>
                <input type="text" id="zerov99_modal_tracking_code" name="zerov99_modal_tracking_code" pattern="[a-zA-Z0-9\-_]{8,30}" required>
            </div>

            <div class="zerov99-tracking-field">
                <label><?php esc_html_e('Pick-up Date:', 'zerov99-shipment-tracking'); ?></label>
                <input type="date" id="zerov99_modal_pickup_date" name="zerov99_modal_pickup_date" value="<?php echo esc_attr($current_date); ?>"  required>
            </div>

            <div class="zerov99-tracking-field email">
                <label for="zerov99_modal_send_email">
                    <?php esc_html_e('Send email to Customer', 'zerov99-shipment-tracking'); ?>
                    <input type="checkbox" id="zerov99_modal_send_email" name="zerov99_modal_send_email" value="yes" <?php checked($send_email, 'yes'); ?>>
                </label>
            </div>

            <div class="zerov99-tracking-field">
                <input type="hidden" id="zerov99_modal_carrier_website" name="zerov99_modal_carrier_website" readonly>
            </div>

            <div class="zerov99-modal-actions">
                <button type="submit" id="zerov99_save_tracking_modal"><?php esc_html_e('Save & Ship', 'zerov99-shipment-tracking'); ?></button>
                <button type="button" id="zerov99_close_tracking_modal"><?php esc_html_e('Cancel', 'zerov99-shipment-tracking'); ?></button>
            </div>
        </form>
    </div>
</div>