<?php
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly
?>

<div class="zerov99-order-tracking-metabox">
    <div class="zerov99-tracking-label"><?php esc_html_e('Order picked up by Carrier', 'zerov99-shipment-tracking'); ?></div>
    <label class="zerov99-toggle-switch">
        <input type="checkbox" id="zerov99_order_picked_up" name="zerov99_order_picked_up" value="yes" <?php checked($picked_up, 'yes'); ?> />
        <span class="zerov99-slider"></span>
    </label>

    <div id="zerov99_tracking_fields">
        <div class="zerov99-tracking-field">
            <label for="zerov99_carrier_name"><?php esc_html_e('Carrier Name:', 'zerov99-shipment-tracking'); ?></label>
            <select id="zerov99_carrier_name" name="zerov99_carrier_name" class="widefat" >
                <option value=""><?php esc_html_e('Select a provider', 'zerov99-shipment-tracking'); ?></option>
                <?php if (!empty($providers)) : ?>
                    <?php foreach ($providers as $provider) : ?>
                        <option value="<?php echo esc_attr($provider['name']); ?>" <?php selected($carrier_name, $provider['name']); ?>>
                            <?php echo esc_html($provider['name']); ?>
                        </option>
                    <?php endforeach; ?>
                <?php endif; ?>
            </select>
        </div>

        <div class="zerov99-tracking-field">
            <label for="zerov99_tracking_code"><?php esc_html_e('Tracking Code:', 'zerov99-shipment-tracking'); ?></label>
            <input type="text" id="zerov99_tracking_code" name="zerov99_tracking_code" value="<?php echo esc_attr($tracking_code); ?>" class="widefat"  />
        </div>

        <div class="zerov99-tracking-field">
            <label for="zerov99_pickup_date"><?php esc_html_e('Pick Up Date:', 'zerov99-shipment-tracking'); ?></label>
            <input type="date" id="zerov99_pickup_date" name="zerov99_pickup_date" value="<?php echo esc_attr($pickup_date); ?>" class="widefat"  />
        </div>

        

        <div class="zerov99-tracking-field">
            <input type="hidden" id="zerov99_carrier_website" name="zerov99_carrier_website" value="<?php echo esc_attr($carrier_website); ?>" class="widefat" readonly />
        </div>

        <div class="zerov99-tracking-field email">
            <label for="zerov99_send_email">
                <?php esc_html_e('Send Email to Customer', 'zerov99-shipment-tracking'); ?>
                <input type="checkbox" id="zerov99_send_email" name="zerov99_send_email" value="yes" <?php checked($send_email, 'yes'); ?> />
            </label>
        </div>
    </div>
</div>
