<?php
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly
?>

<div class="zerov99-completed-tracking-metabox">
    <div class="zerov99-tracking-field">
        <label for="completed_carrier"><?php esc_html_e('Carrier:', 'zerov99-shipment-tracking'); ?></label>
        <input type="text" id="completed_carrier" name="completed_carrier" value="<?php echo esc_attr($carrier_name); ?>" readonly class="widefat" />
    </div>

    <div class="zerov99-tracking-field">
        <label for="completed_tracking_code"><?php esc_html_e('Tracking Code:', 'zerov99-shipment-tracking'); ?></label>
        <input type="text" id="completed_tracking_code" name="completed_tracking_code" value="<?php echo esc_attr($tracking_code); ?>" readonly class="widefat" />
    </div>

    <div class="zerov99-tracking-field">
        <label for="completed_pickup_date"><?php esc_html_e('Pick-up Date:', 'zerov99-shipment-tracking'); ?></label>
        <input type="date" id="completed_pickup_date" name="completed_pickup_date" value="<?php echo esc_attr($pickup_date); ?>" readonly class="widefat" />
    </div>

    <div class="zerov99-tracking-field email">
        <label for="completed_send_email">
            <?php esc_html_e('Shipping Notification Sent', 'zerov99-shipment-tracking'); ?>
            <input type="checkbox" id="completed_send_email" name="completed_send_email" value="yes"
                <?php checked($send_email, 'yes'); ?> disabled class="widefat" ?>
        </label>
    </div>
</div>