<?php
namespace ZeroV99\ShipmentTracking\helpers;

if (!defined('ABSPATH')) {
    exit;
}

use ZeroV99\ShipmentTracking\helpers\ZeroV99_Shipment_Tracking_Config;

/**
 * Returns a dynamic version for asset cache busting.
 *
 * In development mode (when WP_DEBUG is true), returns the file modification time.
 * In production, returns the fallback version.
 *
 * @param string $file_path         Absolute path to the asset file.
 * @param string $fallback_version Optional fallback version for production.
 * @return string
 */
function get_asset_version(string $file_path, string $fallback_version = ZeroV99_Shipment_Tracking_Config::PLUGIN_VERSION): string {
    $is_dev = defined('WP_DEBUG') && WP_DEBUG;

    if ($is_dev && file_exists($file_path)) {
        return (string) filemtime($file_path);
    }

    return $fallback_version;
}
